/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.settingsui.SupportPackageThirdPartyData;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SupportPackageData {
    private String fName;
    private String fDisplayName;
    private String fProduct;
    private boolean fEnabled;
    private List<SupportPackageThirdPartyData> fThirdPartyData;
    private static final String ENABLED_STRING = "enabled";
    private static final String NAME_STRING = "name";
    private static final String PRODUCT_STRING = "product";
    private static final String DISPLAY_NAME_STRING = "displayname";

    public SupportPackageData(String string, String string2, String string3, boolean bl) {
        this.fName = string;
        this.fProduct = string3;
        this.fEnabled = bl;
        this.fDisplayName = string2;
        this.fThirdPartyData = new ArrayList<SupportPackageThirdPartyData>();
    }

    public SupportPackageData(String string) throws DataFormatException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            Element element = document.getDocumentElement();
            this.fName = element.getAttribute(NAME_STRING);
            if (this.fName == null || this.fName.isEmpty()) {
                throw new DataFormatException("Support package name not specified");
            }
            this.fDisplayName = element.getAttribute(DISPLAY_NAME_STRING);
            this.fProduct = element.getAttribute(PRODUCT_STRING);
            this.fEnabled = element.getAttribute(ENABLED_STRING).equals("true");
            this.fThirdPartyData = new ArrayList<SupportPackageThirdPartyData>();
            NodeList nodeList = document.getElementsByTagName("thirdparty");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                SupportPackageThirdPartyData supportPackageThirdPartyData = new SupportPackageThirdPartyData(element2);
                this.fThirdPartyData.add(supportPackageThirdPartyData);
            }
        }
        catch (Exception exception) {
            throw new DataFormatException(exception.getMessage());
        }
    }

    public void setEnabled(boolean bl) {
        this.fEnabled = bl;
    }

    public String toString() {
        String string = "";
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("package");
            document.appendChild(element);
            element.setAttribute(ENABLED_STRING, String.valueOf(this.fEnabled));
            element.setAttribute(NAME_STRING, this.fName);
            element.setAttribute(DISPLAY_NAME_STRING, this.fDisplayName);
            element.setAttribute(PRODUCT_STRING, this.fProduct);
            for (int i = 0; i < this.fThirdPartyData.size(); ++i) {
                element.appendChild(document.adoptNode(this.fThirdPartyData.get(i).getXML().getDocumentElement().cloneNode(true)));
            }
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            string = stringWriter.toString();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return string;
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public String getName() {
        return this.fName;
    }

    public String getProduct() {
        return this.fProduct;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public void addThirdPartyDependency(SupportPackageThirdPartyData supportPackageThirdPartyData) {
        this.fThirdPartyData.add(supportPackageThirdPartyData);
    }

    public List<SupportPackageThirdPartyData> getThirdPartyDependencies() {
        return this.fThirdPartyData;
    }

    public int getThirdPartyCount() {
        return this.fThirdPartyData.size();
    }

    public boolean hasThirdPartyDependencies() {
        return !this.fThirdPartyData.isEmpty();
    }

    public String getThirdPartyInfo() {
        String string = "";
        for (SupportPackageThirdPartyData supportPackageThirdPartyData : this.fThirdPartyData) {
            string = string + MessageFormat.format(BuiltInResources.getString("thirdparty.info.detail"), supportPackageThirdPartyData.getName(), supportPackageThirdPartyData.getUrl(), supportPackageThirdPartyData.getDownloadUrl()) + "\n";
        }
        return string;
    }

    public String getThirdPartyInfoSummary() {
        String string = "";
        for (SupportPackageThirdPartyData supportPackageThirdPartyData : this.fThirdPartyData) {
            if (!string.isEmpty()) {
                string = string + "\n";
            }
            string = string + MessageFormat.format(BuiltInResources.getString("thirdparty.info.summary"), supportPackageThirdPartyData.getName(), supportPackageThirdPartyData.getUrl());
        }
        return string;
    }
}

