/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.project.impl.settingsui.SettingsPaintingUtils;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTablePaintingUtils;
import com.mathworks.project.impl.table.RowPaintContext;
import com.mathworks.services.ColorPrefs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;

public class DefaultPropertyTablePainter<T>
implements PropertyTablePainter<T> {
    private static final int EXPANDER_HEIGHT = 9;
    private static final int EXPANDER_WIDTH = 5;
    private static final Color GRAY_BACKGROUND_COLOR = new Color(240, 240, 240);
    private static final Color DISABLED_FOREGROUND_COLOR = new Color(109, 109, 109);

    @Override
    public int getGridLineHeight() {
        return 1;
    }

    @Override
    public int getGridLineWidth() {
        return 1;
    }

    @Override
    public void paintGridLine(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setColor(GRAY_BACKGROUND_COLOR);
        graphics2D.fill(rectangle2D);
    }

    @Override
    public Color paintGroupBackground(RowPaintContext<T> rowPaintContext) {
        Graphics2D graphics2D = rowPaintContext.getGraphics();
        graphics2D.setColor(GRAY_BACKGROUND_COLOR);
        graphics2D.fill(rowPaintContext.getRowRect());
        return GRAY_BACKGROUND_COLOR;
    }

    @Override
    public Color paintNormalBackground(RowPaintContext<T> rowPaintContext) {
        Color color = ColorPrefs.getBackgroundColor();
        PropertyTablePaintingUtils.paintBackgroundWithHighlight(rowPaintContext, color);
        return color;
    }

    @Override
    public Color paintSelectedBackground(RowPaintContext<T> rowPaintContext) {
        if (rowPaintContext.isExpandable() && !rowPaintContext.isSelectingExandableRowsAllowed()) {
            return this.paintNormalBackground(rowPaintContext.withoutHighlight());
        }
        Color color = ColorUtils.getSelectionBackgroundColor();
        if (!rowPaintContext.isFocused()) {
            color = ColorUtils.getUnfocusedSelectionBackgroundColor((Component)rowPaintContext.getComponent());
        }
        PropertyTablePaintingUtils.paintBackgroundWithHighlight(rowPaintContext, color);
        return color;
    }

    @Override
    public boolean canFitText(CellPaintContext<T> cellPaintContext) {
        int n = cellPaintContext.getColumnIndex() == 0 ? 3 + 16 * Math.max(cellPaintContext.getNestLevel(), 1) : 3;
        int n2 = 0;
        if (cellPaintContext.getLink() != null && cellPaintContext.getLink().isVisible()) {
            n2 = (int)(cellPaintContext.getLink().getPreferredSize().getWidth() + 10.0);
        }
        String string = SettingsPaintingUtils.trim(cellPaintContext.getGraphics(), cellPaintContext.getText(), (int)(cellPaintContext.getCellRect().getWidth() - (double)n - (double)n2));
        return string.equals(cellPaintContext.getText());
    }

    @Override
    public Color paintText(CellPaintContext<T> cellPaintContext) {
        Color color = ColorPrefs.getTextColor();
        if (!cellPaintContext.isLeaf()) {
            color = ColorUtils.getContrastingForegroundVariant((Color)ColorPrefs.getBackgroundColor(), (Color)new Color(143, 158, 177));
        } else if (cellPaintContext.isDisabled()) {
            color = DISABLED_FOREGROUND_COLOR;
        } else if (cellPaintContext.isSelected()) {
            color = ColorUtils.getSelectionForegroundColor();
        }
        Graphics2D graphics2D = cellPaintContext.getGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = cellPaintContext.getLineHeight() - (fontMetrics.getAscent() + fontMetrics.getDescent());
        int n2 = cellPaintContext.getColumnIndex() == 0 ? 3 + 16 * Math.max(cellPaintContext.getNestLevel(), 1) : 3;
        int n3 = 0;
        if (cellPaintContext.getLink() != null && cellPaintContext.getLink().isVisible()) {
            n3 = (int)(cellPaintContext.getLink().getPreferredSize().getWidth() + 10.0);
        }
        String string = cellPaintContext.getText().isEmpty() ? " " : cellPaintContext.getText();
        Font font = graphics2D.getFont();
        font = !cellPaintContext.isLeaf() || cellPaintContext.isNonDefault() ? font.deriveFont(1) : font.deriveFont(0);
        graphics2D.setFont(font);
        String string2 = SettingsPaintingUtils.trim(graphics2D, string, (int)(cellPaintContext.getCellRect().getWidth() - (double)n2 - (double)n3));
        AttributedString attributedString = new AttributedString(string2);
        attributedString.addAttribute(TextAttribute.FONT, font);
        color = PropertyTablePaintingUtils.adjustForegroundColorForHighlight(cellPaintContext, color);
        if (cellPaintContext.getDataChangePhase() < 1.0) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(cellPaintContext.getDataChangePhase() * 255.0));
        }
        attributedString = PropertyTablePaintingUtils.adjustTextForHighlight(cellPaintContext, attributedString, font);
        if (cellPaintContext.matchesSearch()) {
            attributedString = PropertyTablePaintingUtils.markSearchMatch(cellPaintContext, attributedString, string2);
        }
        graphics2D.setColor(color);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        int n4 = (int)cellPaintContext.getCellRect().getX() + n2;
        if (cellPaintContext.getColumn().isNumericallyAligned()) {
            int n5 = string.indexOf(".");
            if (n5 < 0) {
                n5 = string.length();
            }
            int n6 = cellPaintContext.getColumn().getRightMargin(n5 < string.length(), cellPaintContext.getColumn().hasHiddenDigits(cellPaintContext.getValue(), string, graphics2D, cellPaintContext.getCellRect()), graphics2D);
            n4 = (int)(cellPaintContext.getCellRect().getX() + cellPaintContext.getCellRect().getWidth() - (double)n6 - textLayout.getBounds().getWidth());
            n4 = (int)Math.max(cellPaintContext.getCellRect().getX() + (double)n2, (double)n4);
        }
        textLayout.draw(graphics2D, n4, (int)(cellPaintContext.getCellRect().getY() + (double)fontMetrics.getAscent() + (double)n / 2.0));
        if (cellPaintContext.isSelected() && cellPaintContext.isExpandable() && !cellPaintContext.isSelectingExandableRowsAllowed() && cellPaintContext.getColumnIndex() == 0) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1, 1.5f, new float[]{1.5f}, 0.0f));
            graphics2D.draw(new Rectangle2D.Double(cellPaintContext.getCellRect().getX() + (double)n2 - 1.5, cellPaintContext.getCellRect().getY() + 2.0, textLayout.getBounds().getWidth() + 3.0, cellPaintContext.getCellRect().getHeight() - 4.0));
            graphics2D.setStroke(stroke);
        }
        if (cellPaintContext.getLink() != null && cellPaintContext.getLink().isVisible()) {
            Dimension dimension = cellPaintContext.getLink().getPreferredSize();
            cellPaintContext.getLink().setFont(graphics2D.getFont());
            cellPaintContext.getLink().setBounds((int)(cellPaintContext.getCellRect().getX() + (double)n2 + textLayout.getBounds().getWidth() + 10.0), (int)(cellPaintContext.getCellRect().getY() + cellPaintContext.getCellRect().getHeight() / 2.0 - dimension.getHeight() / 2.0), (int)dimension.getWidth(), (int)dimension.getHeight());
            graphics2D.translate(cellPaintContext.getLink().getX(), cellPaintContext.getLink().getY());
            cellPaintContext.getLink().paint(graphics2D);
            graphics2D.translate(-cellPaintContext.getLink().getX(), -cellPaintContext.getLink().getY());
        }
        graphics2D.setFont(font);
        return color;
    }

    @Override
    public int getCollapsedPhaseIndex() {
        return 1;
    }

    @Override
    public Rectangle2D getExpanderRect(RowPaintContext<T> rowPaintContext) {
        Rectangle2D rectangle2D = rowPaintContext.getRowRect();
        double d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 4.5;
        double d2 = rectangle2D.getX() + Math.max(8.0, (double)(3 + Math.max(0, rowPaintContext.getNestLevel() - 1) * 16));
        double d3 = d2 + 5.0;
        double d4 = d + 9.0;
        return new Rectangle2D.Double(d2, d, d3 - d2 + 1.0, d4 - d + 1.0);
    }

    @Override
    public void paintExpander(RowPaintContext<T> rowPaintContext) {
        Graphics2D graphics2D = rowPaintContext.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        Rectangle2D rectangle2D = this.getExpanderRect(rowPaintContext);
        if (rowPaintContext.getExpansionPhase() == 0) {
            double d = (int)rectangle2D.getY() + 2;
            double d2 = (int)rectangle2D.getX();
            double d3 = d2 + 6.0;
            double d4 = d + 6.0;
            generalPath.append(new Line2D.Double(d2, d4, d3, d4), true);
            generalPath.append(new Line2D.Double(d3, d4, d3, d), true);
            generalPath.append(new Line2D.Double(d3, d, d2, d4), true);
        } else {
            double d = (int)rectangle2D.getY();
            double d5 = (int)rectangle2D.getX();
            double d6 = d5 + 4.0;
            double d7 = d + 8.0;
            double d8 = (d + d7) / 2.0;
            generalPath.append(new Line2D.Double(d5, d, d6, d8), true);
            generalPath.append(new Line2D.Double(d6, d8, d5, d7), true);
            generalPath.append(new Line2D.Double(d5, d7, d5, d), true);
        }
        if (rowPaintContext.isSelected() && rowPaintContext.isSelectingExandableRowsAllowed()) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(generalPath);
        } else if (rowPaintContext.getExpansionPhase() == 0) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fill(generalPath);
        } else {
            graphics2D.setColor(new Color(166, 166, 166));
            graphics2D.draw(generalPath);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }
}

