/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.table.Cell;
import com.mathworks.util.Predicate;
import java.awt.Color;
import java.awt.Font;
import java.text.AttributedString;
import java.util.List;

public class PropertyTableHighlighter<T> {
    private final Color fBackgroundColor;
    private final Color fForegroundColor;
    private final Predicate<T> fAffectedItemPredicate;
    private final Predicate<Cell<T>> fColumnPredicate;

    public PropertyTableHighlighter(Color color, Color color2, List<T> list) {
        this(color, color2, list, null);
    }

    public PropertyTableHighlighter(Color color, Color color2, Predicate<T> predicate) {
        this(color, color2, predicate, null);
    }

    public PropertyTableHighlighter(Color color, Color color2, final List<T> list, Predicate<Cell<T>> predicate) {
        this(color, color2, new Predicate<T>(){

            public boolean accept(T t) {
                return list.contains(t);
            }
        }, predicate);
    }

    public PropertyTableHighlighter(Color color, Color color2, Predicate<T> predicate, Predicate<Cell<T>> predicate2) {
        this.fBackgroundColor = color;
        this.fForegroundColor = color2;
        this.fAffectedItemPredicate = predicate;
        this.fColumnPredicate = predicate2;
    }

    public Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    public Color getForegroundColor() {
        return this.fForegroundColor;
    }

    public static Color getPhaseColor(Color color, double d) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(d * 255.0));
    }

    public boolean isColumnSpecific() {
        return this.fColumnPredicate != null;
    }

    public boolean isAffected(T t) {
        return this.fAffectedItemPredicate.accept(t);
    }

    public boolean isAffected(Cell<T> cell) {
        return this.fAffectedItemPredicate.accept(cell.getValue()) && (this.fColumnPredicate == null || this.fColumnPredicate.accept(cell));
    }

    public AttributedString mark(int n, T t, AttributedString attributedString, Font font, double d) {
        return attributedString;
    }
}

