/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.table.Cell;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.RowPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.text.AttributedString;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class PropertyTablePaintingUtils {
    private PropertyTablePaintingUtils() {
    }

    public static <T> void paintBackgroundWithHighlight(RowPaintContext<T> rowPaintContext, Color color) {
        Graphics2D graphics2D = rowPaintContext.getGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(rowPaintContext.getRowRect());
        for (PropertyTableHighlighter<T> propertyTableHighlighter : rowPaintContext.getHighlighters()) {
            if (propertyTableHighlighter.getBackgroundColor() == null) continue;
            if (!propertyTableHighlighter.isColumnSpecific() && propertyTableHighlighter.isAffected(rowPaintContext.getValue())) {
                graphics2D.setColor(PropertyTableHighlighter.getPhaseColor(propertyTableHighlighter.getBackgroundColor(), rowPaintContext.getHighlightPhase(propertyTableHighlighter)));
                graphics2D.fill(rowPaintContext.getRowRect());
                continue;
            }
            if (!propertyTableHighlighter.isColumnSpecific()) continue;
            for (int i = 0; i < rowPaintContext.getColumnCount(); ++i) {
                if (!propertyTableHighlighter.isAffected(new Cell<T>(rowPaintContext.getRowIndex(), i, rowPaintContext.getValue()))) continue;
                graphics2D.setColor(PropertyTableHighlighter.getPhaseColor(propertyTableHighlighter.getBackgroundColor(), rowPaintContext.getHighlightPhase(propertyTableHighlighter)));
                graphics2D.fill(rowPaintContext.getCellRect(i));
            }
        }
    }

    public static <T> AttributedString adjustTextForHighlight(CellPaintContext<T> cellPaintContext, AttributedString attributedString, Font font) {
        AttributedString attributedString2 = attributedString;
        for (PropertyTableHighlighter propertyTableHighlighter : cellPaintContext.getHighlighters()) {
            if (!propertyTableHighlighter.isAffected(new Cell(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex(), cellPaintContext.getValue())) || !(cellPaintContext.getHighlightPhase(propertyTableHighlighter) > 0.5)) continue;
            attributedString2 = propertyTableHighlighter.mark(cellPaintContext.getColumnIndex(), cellPaintContext.getValue(), attributedString, font, cellPaintContext.getHighlightPhase(propertyTableHighlighter));
        }
        return attributedString2;
    }

    public static <T> AttributedString markSearchMatch(CellPaintContext<T> cellPaintContext, AttributedString attributedString, String string) {
        int n;
        int n2;
        if (cellPaintContext.getColumnIndex() > 0) {
            return attributedString;
        }
        String string2 = cellPaintContext.getText().toUpperCase(Locale.ENGLISH);
        String string3 = cellPaintContext.getSearchText().toUpperCase(Locale.ENGLISH);
        for (int i = 0; i < string2.length() && (n2 = string2.indexOf(string3, i)) >= 0 && (n = PropertyTablePaintingUtils.determinePaintableMatchLength(string3.toLowerCase(), string.toLowerCase(), n2)) > 0; ++i) {
            attributedString.addAttribute(TextAttribute.BACKGROUND, new Color(255, 255, 170), n2, n2 + n);
            attributedString.addAttribute(TextAttribute.FOREGROUND, Color.BLACK, n2, n2 + n);
            i = n2 + n - 1;
        }
        return attributedString;
    }

    private static int determinePaintableMatchLength(String string, String string2, int n) {
        if (n + string.length() <= string2.length() && string2.substring(n, n + string.length()).equals(string)) {
            return string.length();
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == string2.charAt(i + n)) continue;
            return i;
        }
        return 0;
    }

    public static <T> Color adjustForegroundColorForHighlight(CellPaintContext<T> cellPaintContext, Color color) {
        Color color2 = color;
        for (PropertyTableHighlighter propertyTableHighlighter : cellPaintContext.getHighlighters()) {
            if (!propertyTableHighlighter.isAffected(new Cell(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex(), cellPaintContext.getValue())) || !(cellPaintContext.getHighlightPhase(propertyTableHighlighter) > 0.5)) continue;
            color2 = propertyTableHighlighter.getForegroundColor();
        }
        return color2;
    }

    public static Icon rotate(GeneralPath generalPath, Color color, double d, boolean bl, boolean bl2) {
        Rectangle rectangle = generalPath.getBounds();
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        if (bl2) {
            int n3;
            n = n3 = (int)Math.sqrt(rectangle.getWidth() * rectangle.getWidth() + rectangle.getHeight() * rectangle.getHeight()) + 1;
            n2 = n3;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setTransform(AffineTransform.getRotateInstance(d, rectangle.getWidth() / 2.0, rectangle.getHeight() / 2.0));
        graphics2D.setColor(color);
        if (bl) {
            graphics2D.fill(generalPath);
        } else {
            graphics2D.draw(generalPath);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static String trim(Graphics2D graphics2D, String string, int n) {
        String string2 = string;
        Font font = graphics2D.getFont();
        for (int i = 1; i <= string.length() && font.getStringBounds(string2, graphics2D.getFontRenderContext()).getWidth() >= (double)n; ++i) {
            string2 = string.substring(0, string.length() - i) + "...";
        }
        return string2;
    }

    public static Rectangle2D[] splitVertically(Rectangle2D rectangle2D) {
        return new Rectangle2D[]{new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() / 2.0), new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight() / 2.0)};
    }

    public static void gradientFill(Graphics2D graphics2D, Rectangle2D rectangle2D, Color color, Color color2, Color color3, Color color4) {
        Rectangle2D[] rectangle2DArray = PropertyTablePaintingUtils.splitVertically(rectangle2D);
        graphics2D.setPaint(new GradientPaint(new Point2D.Double(0.0, rectangle2DArray[0].getY()), color, new Point2D.Double(0.0, rectangle2DArray[0].getY() + rectangle2DArray[0].getHeight() - 1.0), color2));
        graphics2D.fill(rectangle2DArray[0]);
        graphics2D.setPaint(new GradientPaint(new Point2D.Double(0.0, rectangle2DArray[1].getY()), color3, new Point2D.Double(0.0, rectangle2DArray[1].getY() + rectangle2DArray[1].getHeight() - 1.0), color4));
        graphics2D.fill(rectangle2DArray[1]);
    }

    public static <T> void drawBorder(RowPaintContext<T> rowPaintContext, Color color, boolean bl) {
        Graphics2D graphics2D = rowPaintContext.getGraphics();
        Rectangle2D rectangle2D = rowPaintContext.getRowRect();
        graphics2D.setColor(color);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() - 1.0, bl ? rectangle2D.getY() : rectangle2D.getY() - 1.0, rectangle2D.getWidth() + 2.0, bl ? rectangle2D.getHeight() - 1.0 : rectangle2D.getHeight());
        graphics2D.draw(double_);
    }

    public static Icon makeDarkIcon(Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        BufferedImage bufferedImage2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        RescaleOp rescaleOp = new RescaleOp(new float[]{0.6f, 0.6f, 0.6f, 1.0f}, new float[4], null);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(bufferedImage, rescaleOp, 0, 0);
        graphics2D2.dispose();
        return new ImageIcon(bufferedImage2);
    }
}

