/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.util;

import java.awt.Component;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class StringUtils {
    public static final String LIST_DELIMITER = ";";

    private StringUtils() {
    }

    public static List<String> delimitedStringToList(String string) {
        return StringUtils.delimitedStringToList(string, LIST_DELIMITER);
    }

    public static List<String> delimitedStringToList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static String listToDelimitedString(List<?> list) {
        return StringUtils.listToDelimitedString(list, LIST_DELIMITER);
    }

    public static String listToDelimitedString(List<?> list, String string) {
        return StringUtils.listToDelimitedString(list, string, false);
    }

    public static String listToDelimitedString(List<?> list, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : list) {
            String string2 = obj.toString();
            if (string2.trim().isEmpty()) continue;
            if (bl && !string2.startsWith("\"") && string2.contains(" ")) {
                string2 = "\"" + string2 + "\"";
            }
            stringBuilder.append(string2);
            stringBuilder.append(string);
        }
        if (stringBuilder.toString().endsWith(string)) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static String quotePathIfNecessary(Object object) {
        if (object == null) {
            return null;
        }
        if (object.toString().contains(" ") && !object.toString().startsWith("\"")) {
            return "\"" + object.toString() + "\"";
        }
        return object.toString();
    }

    public static boolean matchesWildcardPattern(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string3 = string2;
        if (string3.endsWith(".*")) {
            string3 = string3.substring(0, string3.length() - 2) + "*";
        }
        for (int i = 0; i <= string3.length(); ++i) {
            if (i == string3.length() || string3.charAt(i) == '*') {
                if (stringBuilder2.length() > 0) {
                    stringBuilder.append("\\Q");
                    stringBuilder.append(stringBuilder2.toString());
                    stringBuilder.append("\\E");
                    stringBuilder2.setLength(0);
                }
                if (i >= string3.length() || string3.charAt(i) != '*') continue;
                stringBuilder.append(".*");
                continue;
            }
            stringBuilder2.append(string3.charAt(i));
        }
        return Pattern.compile(stringBuilder.toString(), 34).matcher(string).matches();
    }

    public static String upperCaseToCamelCase(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (int i = 0; i < string.length(); ++i) {
            if (bl2) {
                stringBuilder.append(string.charAt(i));
                bl2 = false;
                continue;
            }
            if (string.charAt(i) == '_') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(Character.toLowerCase(string.charAt(i)));
        }
        String string2 = stringBuilder.toString();
        if (bl && string2.length() > 0) {
            return String.valueOf(string2.charAt(0)).toUpperCase(Locale.ENGLISH) + string2.substring(1);
        }
        if (!bl && string2.length() > 0) {
            return String.valueOf(string2.charAt(0)).toLowerCase(Locale.ENGLISH) + string2.substring(1);
        }
        return string2;
    }

    public static String camelCaseToLowerCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && Character.isUpperCase(string.charAt(i))) {
                stringBuilder.append('_');
            }
            stringBuilder.append(Character.toLowerCase(string.charAt(i)));
        }
        return stringBuilder.toString();
    }

    public static String normalizeSpace(String string) {
        return StringUtils.normalizeSpace(string, true);
    }

    public static String normalizeSpace(String string, boolean bl) {
        return string.trim().replaceAll("\\r[\\s]*", bl ? "" : " ").replaceAll("\\n[\\s]*", bl ? "" : " ").replaceAll("[\\s]+", " ");
    }

    public static String createWordWrappedHtml(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder2.setLength(0);
                stringBuilder.append("<br>");
                continue;
            }
            if (Character.isWhitespace(c) && c != '\r') {
                if (stringBuilder2.length() > n) {
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder2.setLength(0);
                    stringBuilder.append("<br>");
                    continue;
                }
                stringBuilder2.append(c);
                continue;
            }
            stringBuilder2.append(c);
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        return stringBuilder.toString();
    }

    public static String addWordWrappingWithNewLines(String string, Component component, int n, boolean bl) {
        int n2 = n;
        String[] stringArray = string.split("\\s+");
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        int n3 = fontMetrics.stringWidth(" ");
        String string2 = "";
        String string3 = "\n";
        if (bl) {
            string3 = "<br>";
        }
        for (String string4 : stringArray) {
            if (fontMetrics.stringWidth(string4) + n3 > n2) {
                string2 = string2 + string3 + string4;
                n2 = n - fontMetrics.stringWidth(string4);
                continue;
            }
            if (string2.isEmpty()) {
                string2 = string4;
                n2 = n - fontMetrics.stringWidth(string4);
                continue;
            }
            string2 = string2 + " " + string4;
            n2 -= fontMetrics.stringWidth(string4) + n3;
        }
        if (bl) {
            string2 = "<html>" + string2 + "</html>";
        }
        return string2;
    }

    public static String addWordWrappingWithNewLinesByRatio(String string, Component component, float f) {
        int n = (int)((float)component.getWidth() * f);
        return StringUtils.addWordWrappingWithNewLines(string, component, n, false);
    }

    public static String addWordWrappingWithHTMLByRatio(String string, Component component, float f) {
        int n = (int)((float)component.getWidth() * f);
        return StringUtils.addWordWrappingWithNewLines(string, component, n, true);
    }

    public static String read(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[1024];
        while ((n = inputStreamReader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        inputStreamReader.close();
        stringWriter.close();
        return stringWriter.toString();
    }

    public static String stripLinks(String string) {
        return string.replaceAll("\\Q<a\\E.*\\Q</a>\\E", "");
    }

    public static String transformXML(String string, String string2, String string3) {
        try {
            TransformerFactory transformerFactory;
            if (string3 != null) {
                try {
                    transformerFactory = TransformerFactory.newInstance(string3, null);
                }
                catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                    throw new IllegalStateException(transformerFactoryConfigurationError);
                }
            } else {
                transformerFactory = TransformerFactory.newInstance();
            }
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new StringReader(string2)));
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new StreamSource(new StringReader(string)), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException);
        }
    }
}

