/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.util;

import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class ThreadDumper {
    private ThreadDumper() {
    }

    public static Timer setThreadDumpTimer(int n) {
        return ThreadDumper.setThreadDumpTimer(n, null);
    }

    public static Timer setThreadDumpTimer(int n, String string) {
        final File file = string == null ? null : ThreadDumper.resolve(string);
        Timer timer = new Timer("ThreadDumper", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    ThreadDumper.dump(file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, n * 1000);
        return timer;
    }

    public static void dump(File file) throws IOException {
        PrintWriter printWriter = file == null ? new PrintWriter(System.err) : new PrintWriter(new FileWriter(file));
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            printWriter.println(entry.getKey() + " " + (Object)((Object)entry.getKey().getState()));
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                printWriter.println("\t" + stackTraceElement);
            }
            printWriter.println();
        }
        printWriter.flush();
        if (file != null) {
            printWriter.close();
        }
    }

    private static File resolve(String string) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            return new File(MatlabPathModel.getInstance().getCurrentFolder().toFile(), string);
        }
        return file;
    }
}

