/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.BreakBox;
import ice.pilots.html4.BulletBox;
import ice.pilots.html4.ButtonBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.CSSManager;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DStyleDeclaration;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.FloatBox;
import ice.pilots.html4.HtmlToCss;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.Selector;
import ice.pilots.html4.SimpleSelector;
import ice.pilots.html4.StormData;
import ice.pilots.html4.TableBox;
import ice.pilots.html4.TableCellBox;
import ice.pilots.html4.TableColBox;
import ice.pilots.html4.TableRowBox;
import ice.pilots.html4.TableRowGroupBox;
import ice.pilots.html4.TextBox;
import ice.pilots.html4.ThePilot;
import ice.util.alg.CharKit;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.stylesheets.StyleSheetList;

class CSSMatcher {
    private String media;
    private DDocument doc;
    private StormData sdata;
    private DCSSRule[] curSelectors;
    private Hashtable universalSelectorsByClass;
    private CSSDecl[] blocks = new CSSDecl[50];
    private byte[] pseudo_value = new byte[50];
    private int numBlocks = 0;
    private DCSSRule htmlProxy;
    private Vector countersToInc = null;
    private Vector countersToReset = null;

    CSSMatcher(String string, StormData stormData, DDocument dDocument) {
        this.media = string;
        this.sdata = stormData;
        this.doc = dDocument;
        this.htmlProxy = new DCSSRule(1, null, null);
        this.htmlProxy.sel = new Selector();
        this.htmlProxy.sel.weight = 20000;
        this.htmlProxy.sel.addSimpleSelector(new SimpleSelector(stormData.names, 0));
        this.htmlProxy.decl = dDocument.getDom().createDStyleDeclaration(this.htmlProxy, null);
        this.htmlProxy.decl.firstDecl = new CSSDecl(1000, 0, null);
        this.build();
    }

    final void build() {
        this.htmlProxy._next = null;
        this.htmlProxy.decl.firstDecl.next = null;
        this.curSelectors = new DCSSRule[this.sdata.names.getNumTags()];
        this.universalSelectorsByClass = new Hashtable();
        DStyleSheet dStyleSheet = CSSManager.getUaStyle(this.doc);
        if (dStyleSheet != null) {
            this.build_ss(dStyleSheet, 0);
        }
        if ((dStyleSheet = CSSManager.getUserStyle(this.sdata)) != null) {
            this.build_ss(dStyleSheet, 10000);
        }
        this.insertHtmlProxyStyle();
        StyleSheetList styleSheetList = this.doc.getStyleSheets();
        for (int i = 0; i < styleSheetList.getLength(); ++i) {
            this.build_ss((DStyleSheet)styleSheetList.item(i), 20000);
        }
    }

    private final void insertHtmlProxyStyle() {
        DCSSRule dCSSRule = this.htmlProxy;
        Selector selector = this.htmlProxy.sel;
        int n = 0;
        DCSSRule dCSSRule2 = this.curSelectors[0];
        if (dCSSRule2 == null || selector.weight < dCSSRule2.sel.weight) {
            this.curSelectors[n] = dCSSRule;
            dCSSRule._next = dCSSRule2;
        } else {
            while (dCSSRule2._next != null && dCSSRule2._next.sel.weight <= selector.weight) {
                dCSSRule2 = dCSSRule2._next;
            }
            dCSSRule._next = dCSSRule2._next;
            dCSSRule2._next = dCSSRule;
        }
    }

    private final void build_ss(DStyleSheet dStyleSheet, int n) {
        if (dStyleSheet.getDisabled()) {
            return;
        }
        if (!dStyleSheet.mediaList.worksWith(this.media)) {
            return;
        }
        this.build_rlist(dStyleSheet.getCssRules(), n);
    }

    private final void build_rlist(CSSRuleList cSSRuleList, int n) {
        block5: for (int i = 0; i < cSSRuleList.getLength(); ++i) {
            Object object = (DCSSRule)cSSRuleList.item(i);
            switch (((DCSSRule)object).getType()) {
                case 1: {
                    Object object2;
                    int n2;
                    Object object3;
                    if (n == 0) {
                        object3 = new DCSSRule(1, null, null);
                        ((DCSSRule)object3).sel = ((DCSSRule)object).sel;
                        ((DCSSRule)object3).decl = ((DCSSRule)object).decl;
                        object = object3;
                    }
                    object3 = ((DCSSRule)object).sel;
                    if (((Selector)object3).weight < 10000 && n > 0) {
                        ((Selector)object3).weight += n;
                    }
                    if ((n2 = ((Selector)object3).getSelectorKey()) < 0 || n2 >= this.curSelectors.length) continue block5;
                    if (n2 == 0 && (object2 = ((Selector)object3).getUniversalClassKey()) != null) {
                        DCSSRule dCSSRule = (DCSSRule)this.universalSelectorsByClass.get(object2);
                        if (dCSSRule == null || ((Selector)object3).weight < dCSSRule.sel.weight) {
                            this.universalSelectorsByClass.put(object2, object);
                            ((DCSSRule)object)._next = dCSSRule;
                            continue block5;
                        }
                        while (dCSSRule._next != null && dCSSRule._next.sel.weight <= ((Selector)object3).weight) {
                            dCSSRule = dCSSRule._next;
                        }
                        ((DCSSRule)object)._next = dCSSRule._next;
                        dCSSRule._next = object;
                        continue block5;
                    }
                    object2 = this.curSelectors[n2];
                    if (object2 == null || ((Selector)object3).weight < ((DCSSRule)object2).sel.weight) {
                        this.curSelectors[n2] = object;
                        ((DCSSRule)object)._next = object2;
                        continue block5;
                    }
                    while (((DCSSRule)object2)._next != null && ((DCSSRule)object2)._next.sel.weight <= ((Selector)object3).weight) {
                        object2 = ((DCSSRule)object2)._next;
                    }
                    ((DCSSRule)object)._next = ((DCSSRule)object2)._next;
                    ((DCSSRule)object2)._next = object;
                    continue block5;
                }
                case 3: {
                    if (((DCSSRule)object).importedStyleSheet == null) continue block5;
                    this.build_ss(((DCSSRule)object).importedStyleSheet, n);
                    continue block5;
                }
                case 4: {
                    if (!((DCSSRule)object).mediaList.worksWith(this.media)) continue block5;
                    this.build_rlist(((DCSSRule)object).ruleList, n);
                }
            }
        }
    }

    CSSBox createCSSBox(DElement dElement, CSSBox cSSBox, CSSLayout cSSLayout) {
        Object object;
        Object object2;
        Object object3;
        CSSDecl cSSDecl;
        int n;
        CSSAttribs cSSAttribs;
        byte by = this.makeStyleBlocks(dElement);
        byte by2 = (byte)(by & 7);
        Object object4 = null;
        CSSAttribs cSSAttribs2 = null;
        if (cSSBox != null) {
            cSSAttribs2 = cSSBox.css;
            cSSAttribs = new CSSAttribs(this.sdata, cSSAttribs2);
            if (cSSBox.dynamic > 0 && by2 == 0) {
                by2 = cSSBox.dynamic;
                by = (byte)(by | by2);
            }
        } else {
            cSSAttribs = new CSSAttribs(this.sdata, cSSLayout.zoom);
            if (dElement == cSSLayout.doc.getDocumentElement()) {
                cSSAttribs.misc = (short)(cSSAttribs.misc | 1);
            }
        }
        int n2 = cSSAttribs.font_size;
        for (n = 0; n < this.numBlocks; ++n) {
            if (this.pseudo_value[n] != 0) continue;
            cSSDecl = this.blocks[n];
            while (cSSDecl != null) {
                if (cSSDecl.id == 46) {
                    n2 = CSSLookup.computeFontSize(this.sdata, cSSDecl, cSSAttribs, cSSLayout.zoom);
                }
                cSSDecl = cSSDecl.next;
            }
        }
        cSSAttribs.font_size = n2;
        for (n = 0; n < this.numBlocks; ++n) {
            if (this.pseudo_value[n] != 0) continue;
            cSSDecl = this.blocks[n];
            while (cSSDecl != null) {
                if (cSSDecl.id == 36) {
                    if (cSSDecl.type == -13) {
                        this.countersToReset = (Vector)cSSDecl.value;
                    }
                } else if (cSSDecl.id == 35) {
                    if (cSSDecl.type == -13) {
                        this.countersToInc = (Vector)cSSDecl.value;
                    }
                } else if (cSSDecl.id == 1000) {
                    HtmlToCss.apply(dElement, cSSAttribs, cSSBox, cSSLayout.zoom);
                } else {
                    CSSLookup.apply(cSSAttribs, cSSDecl, cSSLayout.zoom, cSSAttribs2);
                }
                cSSDecl = cSSDecl.next;
            }
        }
        this.checkCounters(dElement, cSSLayout);
        if (cSSAttribs.border_top_width > 0 && cSSAttribs.border_top_style == 8) {
            cSSAttribs.border_top_width = 0;
        }
        if (cSSAttribs.border_left_width > 0 && cSSAttribs.border_left_style == 8) {
            cSSAttribs.border_left_width = 0;
        }
        if (cSSAttribs.border_right_width > 0 && cSSAttribs.border_right_style == 8) {
            cSSAttribs.border_right_width = 0;
        }
        if (cSSAttribs.border_bottom_width > 0 && cSSAttribs.border_bottom_style == 8) {
            cSSAttribs.border_bottom_width = 0;
        }
        this.checkOutline(cSSAttribs, cSSLayout);
        if (cSSAttribs.color != Color.black && !cSSLayout.getPrintBack() && Color.white.equals(cSSAttribs.color)) {
            cSSAttribs.color = Color.black;
        }
        if (cSSAttribs.display != 41 && cSSAttribs.display != 46 && dElement == cSSLayout.doc.getDocumentElement()) {
            cSSAttribs.display = 41;
        } else if (dElement.getNameId() == 79 && cSSAttribs.display == 40) {
            cSSAttribs.display = 47;
        }
        n = 0;
        if (ThePilot.viewNoframes & (58 == dElement.getNameId() || 34 == dElement.getNameId())) {
            cSSAttribs.display = 41;
        }
        if (cSSAttribs.directionFlag == 1) {
            if (cSSAttribs.text_align == 15) {
                cSSAttribs.text_align = 3;
            } else if (cSSAttribs.text_align == 130) {
                cSSAttribs.text_align = 3;
            }
            int n3 = cSSAttribs.margin_left;
            cSSAttribs.margin_left = cSSAttribs.margin_right;
            cSSAttribs.margin_right = n3;
            n3 = cSSAttribs.padding_left;
            cSSAttribs.padding_left = cSSAttribs.padding_right;
            cSSAttribs.padding_right = n3;
        } else if (cSSAttribs.directionFlag == 2 && cSSAttribs.text_align == 3) {
            cSSAttribs.text_align = 1;
            int n4 = cSSAttribs.margin_right;
            cSSAttribs.margin_right = cSSAttribs.margin_left;
            cSSAttribs.margin_left = n4;
            n4 = cSSAttribs.padding_right;
            cSSAttribs.padding_right = cSSAttribs.padding_left;
            cSSAttribs.padding_left = n4;
        }
        if ((cSSAttribs.position == 6 || cSSAttribs.position == 126 || cSSAttribs.position == 125) && dElement.getNameId() == 87) {
            cSSAttribs.position = 124;
        }
        switch (cSSAttribs.display) {
            case 41: {
                if (cSSAttribs.position == 126 || cSSAttribs.position == 6) {
                    cSSAttribs.do_floats = 0;
                    object4 = new PositionedBox(dElement, cSSAttribs, cSSLayout, by2, cSSBox.getLast());
                    break;
                }
                object4 = new BlockBox(dElement, cSSAttribs, cSSLayout, by2);
                break;
            }
            case 8: {
                object4 = null;
                return null;
            }
            case 46: 
            case 47: {
                object4 = new TableBox(dElement, cSSAttribs, cSSLayout);
                break;
            }
            case 55: {
                object4 = new TableCellBox(dElement, cSSAttribs, cSSLayout);
                n = 1;
                break;
            }
            case 52: {
                object4 = new TableColBox(dElement, cSSAttribs, cSSLayout, true);
                n = 1;
                break;
            }
            case 53: {
                object4 = new TableColBox(dElement, cSSAttribs, cSSLayout, false);
                n = 1;
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                object4 = new TableRowGroupBox(dElement, cSSAttribs, cSSLayout);
                n = 1;
                break;
            }
            case 51: {
                object4 = new TableRowBox(dElement, cSSAttribs, cSSLayout);
                n = 1;
                break;
            }
            case 54: {
                object4 = new TableCellBox(dElement, cSSAttribs, cSSLayout);
                n = 1;
                break;
            }
            default: {
                if (cSSAttribs.position == 126 || cSSAttribs.position == 6) {
                    cSSAttribs.do_floats = 0;
                    object4 = new PositionedBox(dElement, cSSAttribs, cSSLayout, by2, cSSBox.getLast());
                    break;
                }
                object4 = (cSSAttribs.do_floats & 3) != 0 ? new BlockBox(dElement, cSSAttribs, cSSLayout, by2) : (dElement.tagId == 15 ? new ButtonBox(dElement, cSSAttribs, cSSLayout, by2) : new InlineBox(dElement, cSSAttribs, cSSLayout, by2));
            }
        }
        if (cSSAttribs.position == 126) {
            cSSLayout.addAbsoluteBox((CSSBox)object4, cSSBox);
        } else if ((cSSAttribs.do_floats & 3) != 0) {
            FloatBox floatBox = new FloatBox(dElement, (CSSBox)object4);
            if (cSSBox != null) {
                cSSBox = cSSBox.addChild(floatBox);
            }
        } else if (cSSAttribs.position == 124 || cSSAttribs.position == 125) {
            if (cSSBox != null) {
                if (n != 0 && cSSBox instanceof BlockBox) {
                    CSSAttribs cSSAttribs3 = new CSSAttribs(this.sdata, cSSAttribs);
                    cSSAttribs3.display = 46;
                    object3 = new TableBox(null, cSSAttribs3, cSSLayout);
                    cSSBox.addChild((CSSBox)object3);
                    cSSBox = ((TableBox)object3).addChild((CSSBox)object4);
                } else {
                    cSSBox = cSSBox.addChild((CSSBox)object4);
                }
            }
        } else if (cSSAttribs.position == 6) {
            cSSLayout.addFixedBox((CSSBox)object4);
        }
        if (cSSAttribs.position == 125) {
            cSSLayout.addRelativeBox((CSSBox)object4, cSSBox);
        }
        if ((by & 8) != 0) {
            int n5 = 0;
            object3 = null;
            CSSAttribs cSSAttribs4 = new CSSAttribs(this.sdata, cSSAttribs);
            for (int i = 0; i < this.numBlocks; ++i) {
                if ((this.pseudo_value[i] & 8) == 0) continue;
                CSSDecl cSSDecl2 = this.blocks[i];
                while (cSSDecl2 != null) {
                    if (cSSDecl2.id == 36) {
                        if (cSSDecl2.type == -13) {
                            this.countersToReset = (Vector)cSSDecl2.value;
                        }
                    } else if (cSSDecl2.id == 35) {
                        if (cSSDecl2.type == -13) {
                            this.countersToInc = (Vector)cSSDecl2.value;
                        }
                    } else if (cSSDecl2.id == 34) {
                        if (cSSDecl2.type == -1) {
                            object3 = (String)cSSDecl2.value;
                        }
                    } else {
                        CSSLookup.apply(cSSAttribs4, cSSDecl2, cSSLayout.zoom, cSSAttribs2);
                    }
                    cSSDecl2 = cSSDecl2.next;
                }
            }
            this.checkCounters(dElement, cSSLayout);
            if (object3 != null) {
                if (((String)object3).startsWith("attr(") && ((String)object3).endsWith(")")) {
                    String string = dElement.getAttribute(((String)object3).substring(5, ((String)object3).length() - 1).trim());
                    if (string != null) {
                        object3 = string;
                    }
                } else if (((String)object3).startsWith("counter(") && ((String)object3).endsWith(")")) {
                    String string = null;
                    int n6 = ((String)object3).indexOf(44);
                    if (n6 > 8) {
                        string = ((String)object3).substring(8, n6).trim();
                        object2 = ((String)object3).substring(n6 + 1, ((String)object3).length() - 1).trim();
                        n5 = CSSLookup.getListStyle((String)object2);
                    } else {
                        string = ((String)object3).substring(8, ((String)object3).length() - 1).trim();
                        n5 = cSSAttribs.listStyleType;
                    }
                    object3 = n5 == 97 || n5 == 98 || n5 == 99 || n5 == 8 ? null : cSSLayout.getCounterValue(string, false, null, n5) + ".";
                } else if (((String)object3).startsWith("counters(") && ((String)object3).endsWith(")")) {
                    String string = "disc";
                    int n7 = ((String)object3).indexOf(44);
                    if (n7 > 9) {
                        object2 = ((String)object3).substring(9, n7).trim();
                        object = null;
                        int n8 = ((String)object3).indexOf(n7 + 1, 44);
                        if (n8 > 0) {
                            object = ((String)object3).substring(n7 + 1, n8).trim();
                            string = ((String)object3).substring(n8 + 1, ((String)object3).length() - 1).trim();
                        } else {
                            object = ((String)object3).substring(n7 + 1, ((String)object3).length() - 1).trim();
                        }
                        if (object2 != null) {
                            object3 = cSSLayout.getCounterValue((String)object2, true, ".", 100);
                        }
                    }
                } else if (((String)object3).equals("\\A")) {
                    object3 = null;
                    cSSLayout.pseudoBefore = new BreakBox(dElement, cSSAttribs4, cSSLayout);
                }
                if (object3 != null && ((String)object3).length() == 0) {
                    object3 = null;
                }
                if (object3 != null || n5 != 0) {
                    CSSBox cSSBox2 = null;
                    CSSBox cSSBox3 = null;
                    if (object3 != null) {
                        object2 = dElement.getOwnerDDocument().createDTextNode((String)object3);
                        cSSBox2 = new TextBox((DTextNode)object2, cSSLayout);
                    } else {
                        cSSBox2 = new BulletBox(dElement, cSSAttribs4, n5, cSSLayout);
                    }
                    cSSBox3 = !(cSSAttribs4.display != 41 && cSSAttribs4.display != 45 || cSSAttribs.text_align != 1 && cSSAttribs.text_align != 15 && cSSAttribs.directionFlag != 1) ? new BlockBox(dElement, cSSAttribs4, cSSLayout, 0) : new InlineBox(dElement, cSSAttribs4, cSSLayout, 0);
                    cSSBox3 = cSSBox3.addChild(cSSBox2);
                    if (cSSAttribs4.display == 45 && (cSSAttribs.text_align == 1 || cSSAttribs.text_align == 15 || cSSAttribs.directionFlag == 1)) {
                        if (object4 instanceof BlockBox) {
                            ((BlockBox)object4).markerBefore = (BlockBox)cSSBox3;
                            cSSBox3.setParentBox((CSSBox)object4);
                        }
                    } else {
                        cSSLayout.pseudoBefore = cSSBox3;
                    }
                }
            }
        }
        if ((by & 0x10) != 0) {
            String string = null;
            object3 = new CSSAttribs(this.sdata, cSSAttribs);
            for (int i = 0; i < this.numBlocks; ++i) {
                if ((this.pseudo_value[i] & 0x10) == 0) continue;
                CSSDecl cSSDecl3 = this.blocks[i];
                while (cSSDecl3 != null) {
                    if (cSSDecl3.id == 34) {
                        if (cSSDecl3.type == -1) {
                            string = (String)cSSDecl3.value;
                        }
                    } else {
                        CSSLookup.apply((CSSAttribs)object3, cSSDecl3, cSSLayout.zoom, cSSAttribs2);
                    }
                    cSSDecl3 = cSSDecl3.next;
                }
            }
            if (string != null) {
                String string2;
                if (string.startsWith("attr(") && string.endsWith(")") && (string2 = dElement.getAttribute(string.substring(5, string.length() - 1))) != null) {
                    string = string2;
                }
                if (string.equals("\\A")) {
                    string = "\n";
                }
                char[] cArray = string.toCharArray();
                DTextNode dTextNode = dElement.getOwnerDDocument().createDTextNode(cArray, 0, cArray.length, false);
                TextBox textBox = new TextBox(dTextNode, cSSLayout);
                object2 = new InlineBox(dElement, (CSSAttribs)object3, cSSLayout, 0);
                cSSLayout.pseudoAfter = object2 = ((CSSBox)object2).addChild(textBox);
            }
        }
        if (by2 > 0) {
            ((CSSBox)object4).dynamic = by2;
            CSSAttribs[] cSSAttribsArray = new CSSAttribs[4];
            cSSAttribsArray[0] = cSSAttribs;
            cSSLayout.dynamicStyles.put(dElement, cSSAttribsArray);
            if ((by & 1) != 0) {
                int n9;
                object3 = cSSAttribs;
                boolean bl = false;
                if (cSSBox != null) {
                    object3 = cSSLayout.getDynamicStyle(cSSBox, 1);
                    if (object3 == null) {
                        object3 = cSSAttribs;
                    } else {
                        bl = true;
                    }
                }
                CSSAttribs cSSAttribs5 = new CSSAttribs(this.sdata, (CSSAttribs)object3);
                for (n9 = 0; n9 < this.numBlocks; ++n9) {
                    byte by3 = this.pseudo_value[n9];
                    if ((by3 & 1) == 0 && (!bl || by3 != 0)) continue;
                    this.updateFontSize(cSSAttribs5, this.blocks[n9], cSSLayout);
                }
                for (n9 = 0; n9 < this.numBlocks; ++n9) {
                    byte by4 = this.pseudo_value[n9];
                    if (by4 != 0) continue;
                    object = this.blocks[n9];
                    while (object != null) {
                        if (((CSSDecl)object).id == 1000) {
                            HtmlToCss.apply(dElement, cSSAttribs5, cSSBox, cSSLayout.zoom);
                        } else {
                            CSSLookup.apply(cSSAttribs5, (CSSDecl)object, cSSLayout.zoom, (CSSAttribs)object3);
                        }
                        object = ((CSSDecl)object).next;
                    }
                }
                for (n9 = 0; n9 < this.numBlocks; ++n9) {
                    byte by5 = this.pseudo_value[n9];
                    if ((by5 & 1) == 0) continue;
                    object = this.blocks[n9];
                    while (object != null) {
                        CSSLookup.apply(cSSAttribs5, (CSSDecl)object, cSSLayout.zoom, (CSSAttribs)object3);
                        object = ((CSSDecl)object).next;
                    }
                }
                cSSAttribsArray[1] = cSSAttribs5;
                this.checkOutline(cSSAttribs5, cSSLayout);
            }
            if ((by & 2) != 0) {
                int n10;
                object3 = cSSAttribs;
                boolean bl = false;
                if (cSSBox != null) {
                    object3 = cSSLayout.getDynamicStyle(cSSBox, 2);
                    if (object3 == null) {
                        object3 = cSSAttribs;
                    } else {
                        bl = true;
                    }
                }
                CSSAttribs cSSAttribs6 = new CSSAttribs(this.sdata, (CSSAttribs)object3);
                for (n10 = 0; n10 < this.numBlocks; ++n10) {
                    byte by6 = this.pseudo_value[n10];
                    if ((by6 & 3) == 0 && (!bl || by6 != 0)) continue;
                    this.updateFontSize(cSSAttribs6, this.blocks[n10], cSSLayout);
                }
                for (n10 = 0; n10 < this.numBlocks; ++n10) {
                    byte by7 = this.pseudo_value[n10];
                    if (by7 != 0) continue;
                    object = this.blocks[n10];
                    while (object != null) {
                        if (((CSSDecl)object).id == 1000) {
                            HtmlToCss.apply(dElement, cSSAttribs6, cSSBox, cSSLayout.zoom);
                        } else {
                            CSSLookup.apply(cSSAttribs6, (CSSDecl)object, cSSLayout.zoom, (CSSAttribs)object3);
                        }
                        object = ((CSSDecl)object).next;
                    }
                }
                for (n10 = 0; n10 < this.numBlocks; ++n10) {
                    byte by8 = this.pseudo_value[n10];
                    if ((by8 & 3) == 0) continue;
                    object = this.blocks[n10];
                    while (object != null) {
                        CSSLookup.apply(cSSAttribs6, (CSSDecl)object, cSSLayout.zoom, (CSSAttribs)object3);
                        object = ((CSSDecl)object).next;
                    }
                }
                cSSAttribsArray[2] = cSSAttribs6;
                this.checkOutline(cSSAttribs6, cSSLayout);
            }
            if ((by & 4) != 0) {
                int n11;
                object3 = cSSAttribs;
                boolean bl = false;
                if (cSSBox != null) {
                    object3 = cSSLayout.getDynamicStyle(cSSBox, 3);
                    if (object3 == null) {
                        object3 = cSSAttribs;
                    } else {
                        bl = true;
                    }
                }
                CSSAttribs cSSAttribs7 = new CSSAttribs(this.sdata, (CSSAttribs)object3);
                for (n11 = 0; n11 < this.numBlocks; ++n11) {
                    byte by9 = this.pseudo_value[n11];
                    if ((by9 & 4) == 0 && (!bl || by9 != 0)) continue;
                    this.updateFontSize(cSSAttribs7, this.blocks[n11], cSSLayout);
                }
                for (n11 = 0; n11 < this.numBlocks; ++n11) {
                    byte by10 = this.pseudo_value[n11];
                    if (by10 != 0) continue;
                    object = this.blocks[n11];
                    while (object != null) {
                        if (((CSSDecl)object).id == 1000) {
                            HtmlToCss.apply(dElement, cSSAttribs7, cSSBox, cSSLayout.zoom);
                        } else {
                            CSSLookup.apply(cSSAttribs7, (CSSDecl)object, cSSLayout.zoom, (CSSAttribs)object3);
                        }
                        object = ((CSSDecl)object).next;
                    }
                }
                for (n11 = 0; n11 < this.numBlocks; ++n11) {
                    byte by11 = this.pseudo_value[n11];
                    if ((by11 & 4) == 0) continue;
                    object = this.blocks[n11];
                    while (object != null) {
                        CSSLookup.apply(cSSAttribs7, (CSSDecl)object, cSSLayout.zoom, (CSSAttribs)object3);
                        object = ((CSSDecl)object).next;
                    }
                }
                cSSAttribsArray[3] = cSSAttribs7;
                this.checkOutline(cSSAttribs7, cSSLayout);
            }
        }
        if (!cSSLayout.getPrintBack() && cSSAttribs.background_color != null) {
            cSSAttribs.background_color = Color.white;
        }
        if ((cSSAttribs.misc & 0x10) != 0 && object4 instanceof BlockBox) {
            CSSAttribs cSSAttribs8 = new CSSAttribs(this.sdata, cSSAttribs);
            cSSAttribs8.display = 41;
            cSSAttribs8.percentage_flag |= 0x100008;
            cSSAttribs8.width = 100;
            cSSAttribs8.height = 100;
            cSSAttribs8.stealBackgroundFrom(cSSAttribs);
            object3 = new ScrollBox(dElement, cSSAttribs8, cSSLayout, 0);
            ((CSSBox)object4).addChild((CSSBox)object3);
            object4 = object3;
        }
        return object4;
    }

    private final void checkCounters(DElement dElement, CSSLayout cSSLayout) {
        int n;
        String string;
        if (this.countersToReset != null) {
            if (dElement.tagId == 61 && (string = dElement.getAttribute(104)) != null && 0 <= (n = CSSUtil.parseInt(string, -1))) {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement("_hcount");
                vector.addElement(new Integer(n - 1));
                cSSLayout.resetCounters(vector);
                this.countersToReset = null;
                return;
            }
            cSSLayout.resetCounters(this.countersToReset);
            this.countersToReset = null;
        }
        if (this.countersToInc != null) {
            if (dElement.tagId == 53 && (string = dElement.getAttribute(114)) != null && 0 <= (n = CSSUtil.parseInt(string, -1))) {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement("_hcount");
                vector.addElement(new Integer(n));
                cSSLayout.updateCounters(vector);
                this.countersToInc = null;
                return;
            }
            cSSLayout.incCounters(this.countersToInc);
            this.countersToInc = null;
        }
    }

    private final void checkOutline(CSSAttribs cSSAttribs, CSSLayout cSSLayout) {
        if (cSSAttribs.outline_width > 0) {
            if (cSSAttribs.outline_style == 8) {
                cSSAttribs.outline_width = 0;
            } else {
                cSSAttribs.misc = (short)(cSSAttribs.misc | 2);
                if (cSSAttribs.outline_width > cSSLayout.maxOutlineWidth) {
                    cSSLayout.maxOutlineWidth = cSSAttribs.outline_width;
                }
            }
        }
    }

    private final void updateFontSize(CSSAttribs cSSAttribs, CSSDecl cSSDecl, CSSLayout cSSLayout) {
        while (cSSDecl != null) {
            if (cSSDecl.id == 46) {
                cSSAttribs.font_size = CSSLookup.computeFontSize(this.sdata, cSSDecl, cSSAttribs, cSSLayout.zoom);
            }
            cSSDecl = cSSDecl.next;
        }
    }

    private final byte makeStyleBlocks(DElement dElement) {
        CSSDecl cSSDecl;
        Object object;
        this.numBlocks = 0;
        byte by = 0;
        Object object2 = this.curSelectors[0];
        Object object3 = null;
        if (dElement.tagId < this.curSelectors.length) {
            object3 = this.curSelectors[dElement.tagId];
        }
        Object object4 = null;
        String string = dElement.getAttribute(21);
        if (string != null && string.length() > 0) {
            if (!DDocument.STRICT) {
                string = CharKit.toLowerCase((String)string);
            }
            object4 = (DCSSRule)this.universalSelectorsByClass.get(string);
        }
        while (object2 != null || object3 != null || object4 != null) {
            int n;
            int n2 = 99999999;
            int n3 = 99999999;
            int n4 = 99999999;
            int n5 = 99999999;
            if (object2 != null) {
                n4 = ((DCSSRule)object2).sel.weight;
            }
            if (object3 != null) {
                n3 = ((DCSSRule)object3).sel.weight;
            }
            if (object4 != null) {
                n2 = ((DCSSRule)object4).sel.weight;
            }
            object = null;
            if (n4 <= n3) {
                if (n4 <= n2) {
                    object = object2;
                    n = 0;
                    n5 = n3 <= n2 ? n3 : n2;
                } else {
                    object = object4;
                    n = 2;
                    n5 = n4;
                }
            } else if (n3 <= n2) {
                object = object3;
                n = 1;
                n5 = n4 <= n2 ? n4 : n2;
            } else {
                object = object4;
                n = 2;
                n5 = n3;
            }
            while (object != null && ((DCSSRule)object).sel.weight <= n5) {
                if (((DCSSRule)object).sel.match(dElement)) {
                    this.appendBlock(((DCSSRule)object).decl.firstDecl);
                    this.pseudo_value[this.numBlocks - 1] = ((DCSSRule)object).sel.pseudo;
                    by = (byte)(by | ((DCSSRule)object).sel.pseudo);
                }
                object = ((DCSSRule)object)._next;
            }
            if (n == 0) {
                object2 = object;
                continue;
            }
            if (n == 1) {
                object3 = object;
                continue;
            }
            if (n != 2) continue;
            object4 = object;
        }
        object = dElement.inlineStyle;
        if (object != null && (cSSDecl = ((DStyleDeclaration)object).firstDecl) != null) {
            this.appendBlock(cSSDecl);
            this.pseudo_value[this.numBlocks - 1] = 0;
        }
        return by;
    }

    private final void appendBlock(CSSDecl cSSDecl) {
        if (this.numBlocks >= this.blocks.length) {
            CSSDecl[] cSSDeclArray = new CSSDecl[this.blocks.length * 2];
            System.arraycopy(this.blocks, 0, cSSDeclArray, 0, this.blocks.length);
            this.blocks = cSSDeclArray;
            byte[] byArray = new byte[this.pseudo_value.length * 2];
            System.arraycopy(this.pseudo_value, 0, byArray, 0, this.pseudo_value.length);
            this.pseudo_value = byArray;
        }
        this.blocks[this.numBlocks++] = cSSDecl;
    }
}

