/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.util.alg.HashArray;

public class DRange {
    DDocument doc;
    DNode commonAncestorContainer;
    DNode startContainer;
    DNode endContainer;
    int startOffset;
    int endOffset;
    private HashArray pathStart = new HashArray();
    private HashArray pathEnd = new HashArray();

    protected DRange(DDocument dDocument) {
        this.doc = dDocument;
    }

    public void empty() {
        this.commonAncestorContainer = null;
        this.endContainer = null;
        this.startContainer = null;
        this.pathStart.clear();
        this.pathEnd.clear();
    }

    void setStart(DNode dNode, int n) {
        this.startContainer = dNode;
        this.startOffset = n;
        this.findCommon();
    }

    void setEnd(DNode dNode, int n) {
        this.endContainer = dNode;
        this.endOffset = n;
        this.findCommon();
    }

    void setRange(DNode dNode, int n, DNode dNode2, int n2) {
        this.startContainer = dNode;
        this.startOffset = n;
        this.endContainer = dNode2;
        this.endOffset = n2;
        this.findCommon();
    }

    DNode getCommonAncestor() {
        return this.commonAncestorContainer;
    }

    public String toString() {
        if (this.startOffset < 0) {
            this.startOffset = 0;
        }
        if (this.startContainer == null || this.endContainer == null || this.commonAncestorContainer == null) {
            return null;
        }
        if (this.startContainer == this.endContainer) {
            DNode dNode = this.startContainer;
            if (dNode instanceof DTextNode) {
                DTextNode dTextNode = (DTextNode)dNode;
                return new String(dTextNode.text, this.startOffset, this.endOffset - this.startOffset);
            }
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        DNode dNode = this.commonAncestorContainer.first;
        while (dNode != null && this.pathStart.get((Object)dNode) == null) {
            dNode = dNode.next;
        }
        while (dNode != null) {
            if (this.isVisible(dNode)) {
                this.addToStringBuffer_r(dNode, stringBuffer);
            }
            if (this.pathEnd.get((Object)dNode) != null) break;
            dNode = dNode.next;
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private boolean isVisible(DNode dNode) {
        int n = dNode.getNameId();
        boolean bl = true;
        switch (n) {
            case 57: 
            case 58: 
            case 59: 
            case 70: 
            case 76: 
            case 86: {
                bl = false;
            }
        }
        return bl;
    }

    private final void addToStringBuffer_r(DNode dNode, StringBuffer stringBuffer) {
        if (dNode == null) {
            return;
        }
        if (this.isBreak(dNode)) {
            stringBuffer.append("\n");
            return;
        }
        if (this.isPrependBlock(dNode)) {
            stringBuffer.append(this.getBlockPrependChars(dNode));
        }
        if (dNode instanceof DTextNode) {
            DTextNode dTextNode = (DTextNode)dNode;
            if (this.isVisible(dNode)) {
                if (dNode == this.startContainer) {
                    stringBuffer.append(dTextNode.text, this.startOffset, dTextNode.getLength() - this.startOffset);
                } else if (dNode == this.endContainer) {
                    stringBuffer.append(dTextNode.text, 0, this.endOffset);
                } else {
                    stringBuffer.append(dTextNode.text);
                }
            }
            return;
        }
        DNode dNode2 = dNode.first;
        if (this.pathStart.get((Object)dNode) != null) {
            while (dNode2 != null && this.pathStart.get((Object)dNode2) == null) {
                dNode2 = dNode2.next;
            }
            while (dNode2 != null) {
                if (this.isVisible(dNode2)) {
                    this.addToStringBuffer_r(dNode2, stringBuffer);
                }
                dNode2 = dNode2.next;
            }
        } else if (this.pathEnd.get((Object)dNode) != null) {
            while (dNode2 != null) {
                if (this.isVisible(dNode2)) {
                    this.addToStringBuffer_r(dNode2, stringBuffer);
                }
                if (this.pathEnd.get((Object)dNode2) == null) {
                    dNode2 = dNode2.next;
                    continue;
                }
                break;
            }
        } else {
            while (dNode2 != null) {
                if (this.isVisible(dNode2)) {
                    this.addToStringBuffer_r(dNode2, stringBuffer);
                }
                dNode2 = dNode2.next;
            }
        }
        if (this.isPostpendBlock(dNode)) {
            stringBuffer.append(this.getBlockPostpendChars(dNode));
        }
    }

    private final void findCommon() {
        this.pathStart.clear();
        this.pathEnd.clear();
        this.commonAncestorContainer = null;
        DNode dNode = this.startContainer;
        while (dNode != null) {
            DNode dNode2 = this.endContainer;
            while (dNode2 != null && dNode2 != dNode) {
                dNode2 = dNode2.parent;
            }
            if (dNode2 == dNode) {
                this.commonAncestorContainer = dNode2;
                this.recordPaths();
                break;
            }
            dNode = dNode.parent;
        }
    }

    private final void recordPaths() {
        if (this.startContainer == null || this.endContainer == null || this.commonAncestorContainer == null) {
            return;
        }
        DNode dNode = this.startContainer;
        DNode dNode2 = null;
        DNode dNode3 = null;
        this.pathStart.put((Object)dNode, (Object)dNode);
        while (dNode != this.commonAncestorContainer) {
            this.pathStart.put((Object)dNode, (Object)dNode);
            dNode2 = dNode;
            dNode = dNode.parent;
        }
        dNode = this.endContainer;
        this.pathEnd.put((Object)dNode, (Object)dNode);
        while (dNode != this.commonAncestorContainer) {
            this.pathEnd.put((Object)dNode, (Object)dNode);
            dNode3 = dNode;
            dNode = dNode.parent;
        }
        if (dNode2 != dNode3 || this.startContainer == this.endContainer) {
            dNode = dNode3;
            while (dNode != null && dNode != dNode2) {
                dNode = dNode.next;
            }
            if (this.startContainer == this.endContainer && this.startOffset <= this.endOffset) {
                return;
            }
            if (dNode == dNode2) {
                dNode = this.startContainer;
                this.startContainer = this.endContainer;
                this.endContainer = dNode;
                int n = this.startOffset;
                this.startOffset = this.endOffset;
                this.endOffset = n;
                HashArray hashArray = this.pathStart;
                this.pathStart = this.pathEnd;
                this.pathEnd = hashArray;
            }
        }
    }

    boolean isInside(DNode dNode) {
        if (dNode == this.startContainer || dNode == this.endContainer) {
            return true;
        }
        while (dNode != null && dNode != this.commonAncestorContainer) {
            DNode dNode2 = dNode.prev;
            while (dNode2 != null) {
                if (this.pathEnd.get((Object)dNode2) != null) {
                    return false;
                }
                if (this.pathStart.get((Object)dNode2) != null) {
                    return true;
                }
                dNode2 = dNode2.prev;
            }
            dNode2 = dNode.next;
            while (dNode2 != null) {
                if (this.pathStart.get((Object)dNode2) != null) {
                    return false;
                }
                if (this.pathEnd.get((Object)dNode2) != null) {
                    return true;
                }
                dNode2 = dNode2.next;
            }
            dNode = dNode.parent;
        }
        return false;
    }

    private boolean isBreak(DNode dNode) {
        int n = dNode.getNameId();
        boolean bl = false;
        switch (n) {
            case 14: {
                bl = true;
            }
        }
        return bl;
    }

    private String getBlockPrependChars(DNode dNode) {
        int n = dNode.getNameId();
        StringBuffer stringBuffer = new StringBuffer("\n");
        switch (n) {
            case 64: {
                stringBuffer.append("\n");
                break;
            }
            case 22: {
                stringBuffer.append("    ");
            }
        }
        return stringBuffer.toString();
    }

    private String getBlockPostpendChars(DNode dNode) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        return stringBuffer.toString();
    }

    private boolean isPrependBlock(DNode dNode) {
        int n = dNode.getNameId();
        boolean bl = false;
        switch (n) {
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 64: 
            case 66: {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isPostpendBlock(DNode dNode) {
        int n = dNode.getNameId();
        boolean bl = false;
        switch (n) {
            case 26: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 66: {
                bl = true;
            }
        }
        return bl;
    }
}

