/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DHrefElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DefaultEventHandler;
import ice.pilots.html4.DirectionFocusManager;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FocusExitHandler;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.ScrollHandler;
import ice.pilots.html4.SmoothScrollHandler;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.util.Defs;
import ice.util.JavaVersion;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class DefaultActionHandler
implements DefaultEventHandler {
    static final int KEY_TAB = 9;
    static final int KEY_SHIFTTAB = 411;
    static final int KEY_HELP = 112;
    static final int KEY_ACTION = 32;
    static final int KEY_SUBMIT = 10;
    static final int KEY_SUBMIT2 = 13;
    static final int KEY_UP = 38;
    static final int KEY_DOWN = 40;
    static final int KEY_LEFT = 37;
    static final int KEY_RIGHT = 39;
    static final int KEY_PGDOWN = 34;
    static final int KEY_PGUP = 33;
    static final int KEY_END = 35;
    static final int KEY_HOME = 36;
    static final int KEY_ZOOM_IN = 107;
    static final int KEY_ZOOM_OUT = 109;
    ThePilot pilot;
    FocusManager focusManager;
    FocusExitHandler focusExitHandler = null;
    ScrollHandler scrollHandler;
    KeyAdapter fKeyAdapter = null;
    private DNode lastNode;
    private boolean shouldScrollOnly = false;
    private boolean shouldFocusOnly = false;
    private long previousTabAction = -1L;
    public static final String ACCESSIBILTIY_NONE = "none";
    public static final String ACCESSIBILTIY_JAVA = "java";
    public static final String ACCESSIBILTIY_JAWS = "jaws";
    static String accessibility = "none";
    static boolean isAccessible = false;

    DefaultActionHandler(ThePilot thePilot) {
        this.pilot = thePilot;
        CSSLayout cSSLayout = thePilot.getCSSLayout();
        String string = Defs.sysProperty((String)"ice.browser.directionFocus");
        this.focusManager = string != null && string.equalsIgnoreCase("true") ? new DirectionFocusManager(thePilot.getDDocument(), cSSLayout, thePilot) : new FocusManager(thePilot.getDDocument(), cSSLayout, thePilot);
        cSSLayout.setFocusManager(this.focusManager);
        String string2 = Defs.sysProperty((String)"ice.browser.scroll");
        this.scrollHandler = string2 != null && string2.equalsIgnoreCase("smooth") ? new SmoothScrollHandler(thePilot) : new ScrollHandler(thePilot);
    }

    private void copySelectedToClipboard() {
        String string = this.pilot.getSelectedText();
        if (string != null && string.length() > 0) {
            if (string.length() > 1 && string.charAt(string.length() - 1) == '\n') {
                string = string.substring(0, string.length() - 1);
            }
            char c = '\u00c3';
            string = string.replace(c, ' ');
            c = '\u0082';
            string = string.replace(c, ' ');
            c = '\u00c2';
            string = string.replace(c, ' ');
            c = '\u00a0';
            string = string.replace(c, ' ');
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    protected boolean isTabKey(long l) {
        return l == 9L;
    }

    protected boolean isActionKey(long l) {
        return l == 32L;
    }

    protected boolean isFormSubmitKey(long l) {
        return l == 10L || l == 13L;
    }

    protected boolean isDirectionKey(long l) {
        return l == 38L || l == 40L || l == 37L || l == 39L;
    }

    protected boolean isZoomKey(long l) {
        return l == 107L || l == 109L;
    }

    protected boolean scrollOnly() {
        return this.shouldScrollOnly;
    }

    protected boolean focusOnly() {
        return this.shouldFocusOnly;
    }

    private void changeZoom(int n) {
        CSSLayout cSSLayout = this.pilot.getCSSLayout();
        cSSLayout.setLayoutZoom(cSSLayout.getLayoutZoom() + n);
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        if (dOMEvent.isDefaultDone()) {
            return;
        }
        EventListener eventListener = dOMEvent.getAction();
        if (eventListener != null) {
            eventListener.handleEvent(dOMEvent);
            if (dOMEvent.isDefaultDone()) {
                return;
            }
        }
        if (dOMEvent instanceof DOMUIEvent) {
            this.shouldScrollOnly = ((DOMUIEvent)dOMEvent).getCtrlKey();
        }
        DNode dNode = dOMEvent.target;
        block0 : switch (dOMEvent.typeId) {
            case 5: {
                this.updateCursor(dNode);
            }
            case 1: 
            case 6: 
            case 7: {
                DOMUIEvent dOMUIEvent = (DOMUIEvent)dOMEvent;
                while (dNode != null) {
                    int n = dNode.tagId;
                    if (n == 1 || n == 6) {
                        this.handleDefaultActionOnLinks(dOMUIEvent, (DElement)dNode);
                        break block0;
                    }
                    if (dOMEvent.typeId == 1 && (n == 15 || n == 47)) {
                        dNode.dispatchEvent(dOMUIEvent);
                        break block0;
                    }
                    dNode = DDocument.getEventChainParent(dNode, dOMEvent);
                }
                break;
            }
            case 3: {
                for (DNode dNode2 = dNode; dNode2 != null; dNode2 = (DNode)dNode2.getParentNode()) {
                    if (dNode2.getNameId() != 15) continue;
                    dNode = dNode2;
                    break;
                }
                while (!(dNode == null || dNode instanceof DElement && ((DElement)dNode).isFocusable())) {
                    dNode = DDocument.getEventChainParent(dNode, dOMEvent);
                }
                this.focusManager.setFocusedBox(dNode);
                break;
            }
            case 4: {
                int n;
                DOMUIEvent dOMUIEvent = (DOMUIEvent)dOMEvent;
                DNode dNode3 = (DNode)dOMUIEvent.getRelatedNode();
                DNode dNode4 = this.convertTargetToBody(dNode, dNode3);
                if (dNode4 != null) {
                    dNode = dNode3 = dNode4;
                }
                for (DNode dNode5 = dNode; dNode5 != null; dNode5 = (DNode)dNode5.getParentNode()) {
                    if (dNode5.getNameId() != 15) continue;
                    dNode3 = dNode = dNode5;
                    break;
                }
                if (dNode3 != dNode) break;
                if (dOMUIEvent.getMouseButtons() == 2) {
                    n = 24;
                } else {
                    n = 1;
                    int n2 = dOMUIEvent.getDetail();
                    if ((n2 & 1) == 0) {
                        n = 2;
                    }
                }
                DDocument dDocument = this.pilot.getDDocument();
                DOMUIEvent dOMUIEvent2 = (DOMUIEvent)dDocument.createDOMEvent(n);
                dOMUIEvent2.copyUIDataFrom(dOMEvent);
                dNode.dispatchEvent(dOMUIEvent2);
                break;
            }
            case 9: {
                this.onKeyDown((DOMUIEvent)dOMEvent);
                break;
            }
            case 10: {
                this.onKeyUp((DOMUIEvent)dOMEvent);
                break;
            }
            case 8: {
                this.onKeyPress((DOMUIEvent)dOMEvent);
                break;
            }
            case 21: {
                this.onFocus((DOMUIEvent)dOMEvent);
                break;
            }
            case 22: {
                this.onBlur((DOMUIEvent)dOMEvent);
            }
        }
    }

    private DNode convertTargetToBody(DNode dNode, DNode dNode2) {
        if (dNode2 != null && dNode2.getNameId() == 43) {
            DNode dNode3 = dNode2.first;
            while (dNode3 != null) {
                if (dNode3.getNameId() == 13) {
                    return dNode3;
                }
                dNode3 = dNode3.next;
            }
        }
        return null;
    }

    private void updateCursor(DNode dNode) {
        DAreaElement dAreaElement;
        if (this.lastNode == dNode) {
            return;
        }
        DocPane docPane = this.pilot.getDocPane();
        if (docPane == null) {
            return;
        }
        this.lastNode = dNode;
        CSSLayout cSSLayout = this.pilot.getCSSLayout();
        CSSBox cSSBox = cSSLayout.findCSSBox(dNode);
        if (cSSBox != null && cSSBox.css.cursor > -1) {
            return;
        }
        if (dNode instanceof DTextNode) {
            while (dNode != null && !(dNode instanceof DDocument)) {
                DElement dElement;
                if ((dNode = dNode.getParentDNode()) instanceof DHrefElement && (dElement = (DHrefElement)dNode).getAttribute(46) != null) {
                    docPane.setCursor(12);
                    return;
                }
                if (!(dNode instanceof DInputElement)) continue;
                dElement = (DInputElement)dNode;
                if (((DInputElement)dElement).getType().equals("button")) {
                    docPane.setCursor(0);
                }
                return;
            }
            if (((DocPaneXml)docPane).enableTextSelection) {
                docPane.setCursor(2);
            }
            return;
        }
        if (dNode != null && dNode instanceof DAreaElement && (dAreaElement = (DAreaElement)dNode).getHref() != null) {
            docPane.setCursor(12);
            return;
        }
        docPane.setCursor(0);
    }

    private DNode getButtonBox(DNode dNode) {
        while (dNode != null && dNode.getNameId() != 13) {
            if (dNode.getNameId() == 15) {
                return dNode;
            }
            dNode = (DNode)dNode.getParentNode();
        }
        return null;
    }

    private void onKeyDown(DOMUIEvent dOMUIEvent) {
        if (dOMUIEvent.isDefaultCancelled()) {
            return;
        }
        long l = dOMUIEvent.getKeyCode();
        if (this.isTabKey(l)) {
            if (this.previousTabAction == l + (long)(dOMUIEvent.getShiftKey() ? 1 : 0) && this.focusManager.getFocusedElement() == null) {
                this.previousTabAction = -1L;
                if (JavaVersion.isV14orGreater()) {
                    if (dOMUIEvent.getShiftKey()) {
                        this.focusManager.previousExternalFocus();
                    } else {
                        this.focusManager.nextExternalFocus();
                    }
                }
                return;
            }
            this.previousTabAction = l + (long)(dOMUIEvent.getShiftKey() ? 1 : 0);
            int n = dOMUIEvent.getShiftKey() ? this.focusManager.previousFocus() : this.focusManager.nextFocus();
            boolean bl = false;
            if (this.focusExitHandler != null && n == -1) {
                bl = dOMUIEvent.getShiftKey() ? this.focusExitHandler.focusExit(411) : this.focusExitHandler.focusExit(9);
            }
            if (bl) {
                this.focusManager.setFocusedBox(null);
                dOMUIEvent.preventDefault();
            } else {
                this.focusManager.setFocusedBox(n);
                dOMUIEvent.preventDefault();
            }
            return;
        }
        if (this.isActionKey(l)) {
            String string;
            DNode dNode = this.focusManager.getFocusedElement();
            if (dNode == null) {
                this.scrollHandler.scrollRequest(34);
                return;
            }
            int n = dNode.getNameId();
            if (n == 1) {
                return;
            }
            if (n == 71) {
                return;
            }
            if (n == 82) {
                return;
            }
            if (n == 47 && ((string = ((DInputElement)dNode).getType()) == null || string.equalsIgnoreCase("text") || string.equalsIgnoreCase("password"))) {
                return;
            }
            this.doAction(dNode);
            dOMUIEvent.preventDefault();
            return;
        }
        if (this.isDirectionKey(l) && !dOMUIEvent.getAltKey()) {
            if (this.doDirectionKey((int)l)) {
                dOMUIEvent.preventDefault();
            }
            return;
        }
        if (this.isZoomKey(l) && Defs.booleanProperty((String)"ice.pilots.html4.disableZoomKeys", (boolean)false)) {
            return;
        }
        if (dOMUIEvent.getObjectPainter() != null) {
            return;
        }
        if (!this.scrollAction((int)l)) {
            switch ((int)l) {
                case 107: {
                    this.changeZoom(16);
                    dOMUIEvent.preventDefault();
                    break;
                }
                case 109: {
                    this.changeZoom(-16);
                    dOMUIEvent.preventDefault();
                    break;
                }
                case 45: 
                case 67: 
                case 88: 
                case 155: {
                    if (!dOMUIEvent.getCtrlKey()) break;
                    this.copySelectedToClipboard();
                    dOMUIEvent.preventDefault();
                    break;
                }
                case 65: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection || !dOMUIEvent.getCtrlKey()) break;
                    this.pilot.getCSSLayout().selectAll();
                    dOMUIEvent.preventDefault();
                }
            }
            if (this.fKeyAdapter != null && this.focusManager.getFocusedElement() == null) {
                int n = 0;
                if (dOMUIEvent.getCtrlKey()) {
                    n |= 0x11;
                }
                if (dOMUIEvent.getAltKey()) {
                    n |= 0x12;
                }
                KeyEvent keyEvent = new KeyEvent(this.pilot.getPilotViewport().getContainer(), 0, 0L, 0, n, (char)dOMUIEvent.getKeyCode(), 0);
                keyEvent.setModifiers(n);
                this.fKeyAdapter.keyPressed(keyEvent);
            }
        } else {
            dOMUIEvent.preventDefault();
        }
    }

    public void setKeyHandler(KeyAdapter keyAdapter) {
        this.fKeyAdapter = keyAdapter;
    }

    protected boolean doDirectionKey(int n) {
        if (isAccessible) {
            return false;
        }
        if (!this.scrollOnly() && this.focusManager.localDFM(n)) {
            return true;
        }
        if (!this.focusOnly() && this.scrollHandler.scrollRequest(n)) {
            return true;
        }
        if (this.focusExitHandler != null) {
            boolean bl = this.focusExitHandler.focusExit(n);
            if (bl) {
                this.focusManager.setFocusedBox(null);
            }
            return bl;
        }
        return !this.scrollOnly() && this.focusManager.globalDFM(n);
    }

    private void processFormSubmitKey(DOMUIEvent dOMUIEvent) {
        DNode dNode = this.focusManager.getFocusedElement();
        if (dNode == null) {
            return;
        }
        if (dNode instanceof DInputElement) {
            DInputElement dInputElement = (DInputElement)dNode;
            String string = dInputElement.getType();
            if (string.equalsIgnoreCase("text") || string.equalsIgnoreCase("password")) {
                DFormElement dFormElement = dInputElement.getDForm();
                if (dFormElement != null && dFormElement.submitUsingSubmitkey()) {
                    dOMUIEvent.preventDefault();
                }
            } else if (string.equalsIgnoreCase("button") || string.equalsIgnoreCase("submit") || string.equalsIgnoreCase("image") || string.equalsIgnoreCase("reset")) {
                this.doAction(dNode);
                dOMUIEvent.preventDefault();
            }
        } else if (dNode instanceof DHrefElement) {
            this.doAction(dNode);
            dOMUIEvent.preventDefault();
        }
    }

    private void onKeyPress(DOMUIEvent dOMUIEvent) {
        if (dOMUIEvent.isDefaultCancelled()) {
            return;
        }
        long l = dOMUIEvent.getKeyCode();
        if (JavaVersion.isV12orGreater() && this.isFormSubmitKey(l)) {
            this.processFormSubmitKey(dOMUIEvent);
            return;
        }
        if (dOMUIEvent.getAltKey()) {
            l = dOMUIEvent.getCharCode();
            if (!dOMUIEvent.getShiftKey() && l >= 65L && l <= 93L) {
                l -= 32L;
            }
            if (this.focusManager.processAccessKey(l)) {
                dOMUIEvent.preventDefault();
            }
        }
    }

    private void onKeyUp(DOMUIEvent dOMUIEvent) {
        if (dOMUIEvent.isDefaultCancelled()) {
            return;
        }
        long l = dOMUIEvent.getKeyCode();
        if (!JavaVersion.isV12orGreater() && this.isFormSubmitKey(l)) {
            this.processFormSubmitKey(dOMUIEvent);
            return;
        }
    }

    private void onFocus(DOMUIEvent dOMUIEvent) {
        DocPane docPane = this.pilot.getDocPane();
        Rectangle rectangle = new Rectangle();
        this.pilot.getView().findBoundingBox((DNode)dOMUIEvent.getTarget(), rectangle);
        Point point = new Point();
        this.pilot.getView().findPosition((DNode)dOMUIEvent.getTarget(), point);
        int n = docPane.getScrollX();
        int n2 = docPane.getScrollY();
        int n3 = docPane.getPaneWidth();
        int n4 = docPane.getPaneHeight();
        int n5 = n;
        int n6 = n2;
        if (point.x < n || point.x > n + n3) {
            n5 = point.x < n ? point.x : 5 + point.x - n3;
        }
        if (point.y < n2 || point.y > n2 + n4) {
            n6 = point.y < n2 ? point.y : rectangle.height + point.y - n4;
        }
        if (n5 != n || n6 != n2) {
            this.scrollHandler.scrollRequest(n5, n6);
        }
    }

    private void onBlur(DOMUIEvent dOMUIEvent) {
    }

    protected void doAction(DNode dNode) {
        DDocument dDocument = (DDocument)this.pilot.getDocument();
        if (dDocument == null) {
            return;
        }
        DOMEvent dOMEvent = dDocument.createDOMEvent(1);
        dNode.dispatchEvent(dOMEvent);
    }

    private boolean scrollAction(int n) {
        if (n == 34 || n == 33 || n == 35 || n == 36) {
            return this.scrollHandler.scrollRequest(n);
        }
        return false;
    }

    private void handleDefaultActionOnLinks(DOMUIEvent dOMUIEvent, DElement dElement) {
        String string = dElement.getAttribute(46);
        if (string != null) {
            boolean bl = string.equals("#");
            boolean bl2 = false;
            if (dElement.tagId == 1 && dOMUIEvent.target instanceof DImageElement && !bl && ((DImageElement)dOMUIEvent.target).getIsMap()) {
                string = string + "?" + dOMUIEvent.posX + "," + dOMUIEvent.posY;
                bl2 = true;
            }
            DDocument dDocument = this.pilot.getDDocument();
            string = dDocument.resolveUrl(string);
            switch (dOMUIEvent.typeId) {
                case 6: {
                    if (!bl2) break;
                    this.pilot.firePropertyChange("statusLine", null, string);
                    break;
                }
                case 5: {
                    this.pilot.firePropertyChange("statusLine", null, string);
                    break;
                }
                case 7: {
                    this.pilot.firePropertyChange("statusLine", null, "");
                    break;
                }
                case 1: {
                    String string2;
                    short s;
                    if (bl || (s = dOMUIEvent.getButton()) != 0 && s != 1) break;
                    if (s == 1) {
                        string2 = "_blank";
                    } else {
                        string2 = dElement.getAttribute(108);
                        if (string2 == null || string2.length() == 0) {
                            string2 = dDocument.getBaseTarget();
                        }
                    }
                    this.pilot.renderContent(string, null, string2);
                }
            }
        }
    }

    public FocusExitHandler getFocusExitHandler() {
        return this.focusExitHandler;
    }

    public void setFocusExitHandler(FocusExitHandler focusExitHandler) {
        this.focusExitHandler = focusExitHandler;
    }

    static {
        accessibility = Defs.sysProperty((String)"ice.pilots.html4.swing.accessible", (String)ACCESSIBILTIY_NONE);
        if (accessibility.equalsIgnoreCase(ACCESSIBILTIY_JAVA) || accessibility.equalsIgnoreCase(ACCESSIBILTIY_JAWS)) {
            isAccessible = true;
        }
    }
}

