/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DElement;
import ice.pilots.html4.FramesDivider;
import ice.storm.Viewport;
import java.awt.Container;
import java.util.Vector;

class FramesetInfo {
    int[] colValues;
    int[] colTypes;
    int[] rowValues;
    int[] rowTypes;
    protected static final int HORIZONTAL_ORIENTATION = 2;
    protected static final int VERTICAL_ORIENTATION = 1;
    DElement framesetElem;
    int[] viewportSizes = null;
    private int orientation;
    FramesetInfo parent;
    private String parentViewportName;
    Vector children = new Vector();
    Vector framesetDividers = new Vector();
    private int x;
    private int y;
    private int w;
    private int h;

    FramesetInfo(DElement dElement, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
        this.framesetElem = dElement;
        this.colValues = nArray;
        this.colTypes = nArray2;
        this.rowValues = nArray3;
        this.rowTypes = nArray4;
        this.orientation = n;
    }

    void dispose() {
        Object e;
        int n;
        for (n = 0; n < this.children.size(); ++n) {
            e = this.children.elementAt(n);
            if (!(e instanceof FramesetInfo)) continue;
            ((FramesetInfo)e).dispose();
        }
        for (n = 0; n < this.framesetDividers.size(); ++n) {
            e = this.framesetDividers.elementAt(n);
            if (!(e instanceof FramesDivider)) continue;
            ((FramesDivider)e).dispose();
        }
    }

    void setParentViewportName(String string) {
        this.parentViewportName = string;
    }

    void upDateSizes(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        if (this.colValues != null && nArray != null && this.rowValues != null && nArray3 != null && this.colValues.length == nArray.length && this.rowValues.length == nArray3.length) {
            if (this.framesetDividers != null) {
                for (int i = 0; i != this.framesetDividers.size(); ++i) {
                    FramesDivider framesDivider = (FramesDivider)this.framesetDividers.elementAt(i);
                    framesDivider.moved_X = 0;
                    framesDivider.moved_Y = 0;
                }
            }
            this.colValues = nArray;
            this.colTypes = nArray2;
            this.rowValues = nArray3;
            this.rowTypes = nArray4;
            this.layout();
        }
    }

    int getOrientation() {
        return this.orientation;
    }

    void setOrientation(int n) {
        this.orientation = n;
    }

    boolean canAddChild() {
        return this.children.size() < this.colValues.length * this.rowValues.length;
    }

    FramesetInfo getParent() {
        return this.parent;
    }

    void addChild(Viewport viewport, FramesDivider framesDivider) {
        this.children.addElement(viewport);
        this.framesetDividers.addElement(framesDivider);
    }

    void addChild(FramesetInfo framesetInfo, FramesDivider framesDivider) {
        framesetInfo.parent = this;
        this.children.addElement(framesetInfo);
        this.framesetDividers.addElement(framesDivider);
    }

    int dividerMoved(int n, FramesDivider framesDivider) {
        int n2 = this.framesetDividers.indexOf(framesDivider);
        int n3 = 7;
        if (n2 >= 0) {
            int n4 = n2 * 2;
            if (this.orientation == 1) {
                if (n > this.viewportSizes[n4 + 3] - n3) {
                    n = this.viewportSizes[n4 + 3] - n3;
                }
                if (-n > this.viewportSizes[n4 + 1] - n3) {
                    n = -this.viewportSizes[n4 + 1] + n3;
                }
                framesDivider.moved_Y += n;
            } else {
                if (n > this.viewportSizes[n4 + 2] - n3) {
                    n = this.viewportSizes[n4 + 2] - n3;
                }
                if (-n > this.viewportSizes[n4] - n3) {
                    n = -this.viewportSizes[n4] + n3;
                }
                framesDivider.moved_X += n;
            }
            this.layout();
        }
        return 1;
    }

    void layout(int n, int n2, int n3, int n4) {
        int n5;
        if (this.framesetDividers.size() > 0) {
            FramesDivider framesDivider = (FramesDivider)this.framesetDividers.lastElement();
            framesDivider.x_width = 0;
            framesDivider.y_width = 0;
        }
        int n6 = 0;
        int n7 = 0;
        for (n5 = 0; n5 != this.framesetDividers.size(); ++n5) {
            FramesDivider framesDivider = (FramesDivider)this.framesetDividers.elementAt(n5);
            n6 += framesDivider.x_width;
            n7 += framesDivider.y_width;
        }
        if (this.viewportSizes == null) {
            this.viewportSizes = new int[this.children.size() * 2];
        } else {
            n5 = 1000;
            int n8 = 1000;
            if (this.w - this.x != 0) {
                n5 = (n3 - n - n6) * 1000 / (this.w - this.x);
            }
            if (this.h - this.y != 0) {
                n8 = (n4 - n2 - n7) * 1000 / (this.h - this.y);
            }
            for (int i = 0; i != this.framesetDividers.size(); ++i) {
                FramesDivider framesDivider = (FramesDivider)this.framesetDividers.elementAt(i);
                framesDivider.moved_X = framesDivider.moved_X * n5 / 1000;
                framesDivider.moved_Y = framesDivider.moved_Y * n8 / 1000;
            }
        }
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        if (this.orientation == 1) {
            this.h -= n7;
        } else {
            this.w -= n6;
        }
        this.layout();
        for (n5 = 0; n5 != this.framesetDividers.size(); ++n5) {
            FramesDivider framesDivider = (FramesDivider)this.framesetDividers.elementAt(n5);
            framesDivider.getComponent().repaint();
        }
    }

    void layout() {
        int n;
        int[] nArray = new int[this.colValues.length];
        int[] nArray2 = new int[this.rowValues.length];
        int n2 = this.w;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.colValues.length; ++n) {
            if (this.colTypes[n] == 1) {
                n4 += this.colValues[n];
                nArray[n] = 0;
                continue;
            }
            if (this.colTypes[n] == 2) {
                n3 += this.colValues[n];
                nArray[n] = 0;
                continue;
            }
            n2 -= this.colValues[n];
            nArray[n] = this.colValues[n];
        }
        if (n2 > 0 && n4 > 0) {
            if (n4 * this.w / 100 > n2) {
                for (n = 0; n < this.colValues.length; ++n) {
                    if (this.colTypes[n] != 1) continue;
                    nArray[n] = n2 * this.colValues[n] / n4;
                    n2 -= nArray[n];
                }
            } else {
                for (n = 0; n < this.colValues.length; ++n) {
                    if (this.colTypes[n] != 1) continue;
                    nArray[n] = this.w * this.colValues[n] / 100;
                    n2 -= nArray[n];
                }
            }
        }
        if (n2 > 0 && n3 > 0) {
            for (n = 0; n < this.colValues.length; ++n) {
                if (this.colTypes[n] != 2) continue;
                nArray[n] = n2 * this.colValues[n] / n3;
            }
        } else if (n2 != 0 && n2 != this.w) {
            for (n = 0; n < this.colValues.length; ++n) {
                int n5 = n;
                nArray[n5] = nArray[n5] + n2 * nArray[n] / (this.w - n2);
            }
        }
        n2 = this.h;
        n3 = 0;
        n4 = 0;
        for (n = 0; n < this.rowValues.length; ++n) {
            if (this.rowTypes[n] == 1) {
                n4 += this.rowValues[n];
                nArray2[n] = 0;
                continue;
            }
            if (this.rowTypes[n] == 2) {
                n3 += this.rowValues[n];
                nArray2[n] = 0;
                continue;
            }
            n2 -= this.rowValues[n];
            nArray2[n] = this.rowValues[n];
        }
        if (n2 > 0 && n4 > 0) {
            if (n4 * this.h / 100 > n2) {
                for (n = 0; n < this.rowValues.length; ++n) {
                    if (this.rowTypes[n] != 1) continue;
                    nArray2[n] = n2 * this.rowValues[n] / n4;
                    n2 -= nArray2[n];
                }
            } else {
                for (n = 0; n < this.rowValues.length; ++n) {
                    if (this.rowTypes[n] != 1) continue;
                    nArray2[n] = this.h * this.rowValues[n] / 100;
                    n2 -= nArray2[n];
                }
            }
        }
        if (n2 > 0 && n3 > 0) {
            for (n = 0; n < this.rowValues.length; ++n) {
                if (this.rowTypes[n] != 2) continue;
                nArray2[n] = n2 * this.rowValues[n] / n3;
            }
        } else if (n2 != 0 && n2 != this.h) {
            for (n = 0; n < this.rowValues.length; ++n) {
                int n6 = n;
                nArray2[n6] = nArray2[n6] + n2 * nArray2[n] / (this.h - n2);
            }
        }
        int n7 = this.children.size();
        int n8 = 0;
        int n9 = 0;
        int n10 = this.x;
        int n11 = this.y;
        int n12 = 0;
        for (n = 0; n < n7; ++n) {
            Container container;
            Viewport viewport;
            FramesDivider framesDivider;
            Object e = this.children.elementAt(n);
            if (n > 0) {
                framesDivider = (FramesDivider)this.framesetDividers.elementAt(n - 1);
            } else {
                framesDivider = new FramesDivider(null);
                framesDivider.setFramesetInfo(this);
            }
            FramesDivider framesDivider2 = (FramesDivider)this.framesetDividers.elementAt(n);
            this.viewportSizes[n12] = nArray[n8] - framesDivider.moved_X + framesDivider2.moved_X;
            this.viewportSizes[n12 + 1] = nArray2[n9] - framesDivider.moved_Y + framesDivider2.moved_Y;
            n12 += 2;
            if (e instanceof Viewport) {
                viewport = (Viewport)e;
                viewport.viewportLayout(n10 + framesDivider.moved_X, n11 + framesDivider.moved_Y, nArray[n8] - framesDivider.moved_X + framesDivider2.moved_X, nArray2[n9] - framesDivider.moved_Y + framesDivider2.moved_Y);
                if (this.orientation == 1) {
                    framesDivider2.getComponent().setBounds(n10, n11 + nArray2[n9] + framesDivider2.moved_Y, nArray[n8], framesDivider2.y_width);
                    n11 += framesDivider2.y_width;
                } else {
                    framesDivider2.getComponent().setBounds(n10 + nArray[n8] + framesDivider2.moved_X, n11, framesDivider2.x_width, nArray2[n9]);
                    n10 += framesDivider2.x_width;
                }
                while (viewport.getParent() != null && !viewport.getName().equals(this.parentViewportName)) {
                    viewport = viewport.getParent();
                }
                container = viewport.getContainer();
                if (container != null && !container.isAncestorOf(framesDivider2.getComponent())) {
                    container.add(framesDivider2.getComponent());
                }
            } else if (e instanceof FramesetInfo) {
                ((FramesetInfo)e).layout(n10 + framesDivider.moved_X, n11 + framesDivider.moved_Y, nArray[n8] - framesDivider.moved_X + framesDivider2.moved_X, nArray2[n9] - framesDivider.moved_Y + framesDivider2.moved_Y);
                if (this.orientation == 1) {
                    framesDivider2.getComponent().setBounds(n10, n11 + nArray2[n9] + framesDivider2.moved_Y, nArray[n8], framesDivider2.y_width);
                    n11 += framesDivider2.y_width;
                } else {
                    framesDivider2.getComponent().setBounds(n10 + nArray[n8] + framesDivider2.moved_X, n11, framesDivider2.x_width, nArray2[n9]);
                    n10 += framesDivider2.x_width;
                }
                if (this.children.size() > 0 && (viewport = this.getViewPort()) != null) {
                    while (viewport.getParent() != null && !viewport.getName().equalsIgnoreCase(this.parentViewportName)) {
                        viewport = viewport.getParent();
                    }
                    container = viewport.getContainer();
                    if (container != null && !container.isAncestorOf(framesDivider2.getComponent())) {
                        container.add(framesDivider2.getComponent());
                    }
                }
            }
            n10 += nArray[n8];
            if (++n8 < nArray.length) continue;
            n8 = 0;
            n10 = this.x;
            n11 += nArray2[n9];
            ++n9;
        }
    }

    private Viewport getViewPort() {
        FramesetInfo framesetInfo = null;
        for (int i = 0; i != this.children.size(); ++i) {
            Object e = this.children.elementAt(i);
            if (e instanceof Viewport) {
                return (Viewport)e;
            }
            if (framesetInfo != null) continue;
            framesetInfo = (FramesetInfo)e;
        }
        return super.getViewPort();
    }
}

