/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.LexBase;
import ice.dombase.LexCallbackBase;
import ice.pilots.html4.LexCallback;
import ice.pilots.html4.ProgressDetail;
import ice.util.ICEException;
import ice.util.encoding.CharIO;
import ice.util.io.LazyCachedInputStream;
import ice.util.io.MarkerInputStream;
import ice.util.memory.MemoryManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

final class Lex2
extends LexBase {
    private String requestedEncoding;
    String curEncoding;
    private boolean lockedEncoding = false;
    private static final int PRESCAN_BUFFER = 512;
    private static final int CHAR_BUFFER_SIZE = 4096;
    private MarkerInputStream markerStream;
    private LazyCachedInputStream cachedStream;
    private final ProgressDetail progDet = new ProgressDetail();

    Lex2(LexCallback lexCallback) {
        super((LexCallbackBase)lexCallback);
        this.char_buf = new char[4096];
    }

    void appendGeneratedContent(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n != 0) {
            this.makeRoomForGeneratedContent(n);
            stringBuffer.getChars(0, n, this.char_buf, this.bufEnd);
            this.bufEnd += n;
        }
    }

    public void appendGeneratedContent(String string) {
        int n = string.length();
        if (n != 0) {
            this.makeRoomForGeneratedContent(n);
            string.getChars(0, n, this.char_buf, this.bufEnd);
            this.bufEnd += n;
        }
    }

    private void makeRoomForGeneratedContent(int n) {
        int n2 = this.bufEnd + n;
        int n3 = this.char_buf.length;
        if (n2 > n3) {
            int n4 = this.bufEnd - this.mark;
            int n5 = n4 + n;
            if (n5 <= n3) {
                System.arraycopy(this.char_buf, this.mark, this.char_buf, 0, n4);
            } else {
                if (n5 > (n3 *= 2)) {
                    n3 = n5;
                }
                char[] cArray = new char[n3];
                System.arraycopy(this.char_buf, this.mark, cArray, 0, n4);
                this.char_buf = cArray;
            }
            this.mark = 0;
            this.bufEnd = n4;
        }
    }

    private void cleanUp() throws IOException {
        if (this.markerStream != null) {
            this.markerStream = null;
        }
        if (this.cachedStream != null) {
            this.cachedStream = null;
        }
    }

    public void close() throws IOException {
        this.cleanUp();
        super.close();
    }

    public int available() throws IOException {
        return this.markerStream.available();
    }

    public int read() throws IOException {
        return this.markerStream.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.markerStream.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.markerStream.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.markerStream.skip(l);
    }

    void setInputStream(InputStream inputStream, String string) {
        this.sourceInputStream = inputStream;
        if (inputStream instanceof MarkerInputStream) {
            this.markerStream = (MarkerInputStream)inputStream;
        } else {
            this.cachedStream = new LazyCachedInputStream(inputStream, 512);
            this.markerStream = new MarkerInputStream(this.cachedStream);
        }
        this.markerStream.mark();
        if (string == null) {
            string = CharIO.getDefaultEncoding();
        }
        this.changeEncoding(string);
    }

    String getEncoding() {
        return this.curEncoding;
    }

    boolean applyEncodingChange(String string) {
        boolean bl = false;
        if (!this.lockedEncoding && !string.equals(this.curEncoding) && this.sourceInputStream != null) {
            this.requestedEncoding = string;
            bl = true;
        }
        return bl;
    }

    void setLockedEncoding(boolean bl) {
        this.lockedEncoding = bl;
    }

    private void doEncodingChange(String string) {
        if (this.sourceInputStream != null) {
            block3: {
                this.changeEncoding(string);
                try {
                    this.markerStream.reset();
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block3;
                    Debug.ex((Throwable)iOException);
                }
            }
            this.mark = 0;
            this.bufEnd = 0;
            this.lexerState = 0;
            this.done = false;
            this.inputReadProgress = 0;
            this.memoryCheckCounter = 0;
            this.lineNumber = 0;
        }
    }

    private void changeEncoding(String string) {
        Reader reader = CharIO.createInputStreamReader((InputStream)((Object)this), (String)(string = Lex2.cleanEncoding(string)));
        if (reader == null) {
            string = "ISO8859_1";
            reader = CharIO.createInputStreamReader((InputStream)((Object)this), (String)string);
        }
        if (reader instanceof InputStreamReader) {
            string = ((InputStreamReader)reader).getEncoding();
        }
        this.curEncoding = string;
        this.setReader(reader);
    }

    private static String cleanEncoding(String string) {
        if (string != null) {
            int n = string.length();
            if (n == 0) {
                string = null;
            } else {
                char c = string.charAt(0);
                char c2 = string.charAt(n - 1);
                if (c == '\"' || c == '\'' || c2 == '\"' || c2 == '\'') {
                    int n2 = c == '\"' || c == '\'' ? 1 : 0;
                    int n3 = c2 == '\"' || c2 == '\'' ? n - 1 : n;
                    string = n2 >= n3 ? null : string.substring(n2, n3);
                }
            }
        }
        return string;
    }

    protected void restoreBuffer(char[] cArray, int n, int n2) {
        super.restoreBuffer(cArray, n, n2);
        if (this.lexerNestingLevel == 1 && this.requestedEncoding != null) {
            this.doEncodingChange(this.requestedEncoding);
            this.requestedEncoding = null;
        }
    }

    protected void readAtLeast(int n) throws IOException {
        int n2 = this.inputReadProgress;
        super.readAtLeast(n);
        this.progDet.length = this.inputReadProgress - n2;
        this.progDet.startpos = this.bufEnd - this.progDet.length;
        this.progDet.buf = this.char_buf;
        this.progDet.enc = this.curEncoding;
        ((LexCallback)this.callback).progress(this.inputReadProgress, this.progDet);
    }

    protected void checkMemory() throws IOException {
        if (this.memoryCheckCounter > 0) {
            --this.memoryCheckCounter;
        } else {
            if (MemoryManager.getInstance().isLowMemory()) {
                throw new ICEException(1, 3, 2);
            }
            this.memoryCheckCounter = 200;
        }
    }
}

