/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class Scroller
extends JPanel
implements AdjustmentListener,
ObjectPainter,
Movable {
    private DocView docView;
    private ObjectBox box;
    private JScrollBar hbar;
    private JScrollBar vbar;
    private View view;

    Scroller(DocView docView) {
        this.docView = docView;
        this.setLayout(new BorderLayout());
        this.hbar = new JScrollBar(0);
        this.vbar = new JScrollBar(1);
        this.view = new View(this, docView);
        this.add((Component)this.hbar, "South");
        this.add((Component)this.vbar, "East");
        this.add((Component)this.view, "Center");
        this.hbar.addAdjustmentListener(this);
        this.vbar.addAdjustmentListener(this);
        this.setOpaque(false);
    }

    Container getView() {
        return this.view;
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void doLayout() {
        super.doLayout();
        ScrollBox scrollBox = this.getScrollBox();
        if (scrollBox != null) {
            Dimension dimension = this.view.getSize();
            scrollBox.layoutScrollable(dimension.width, dimension.height);
            int n = scrollBox.getScrollableWidth();
            int n2 = scrollBox.getScrollableHeight();
            this.hbar.setValues(0, dimension.width, 0, n);
            this.vbar.setValues(0, dimension.height, 0, n2);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        ScrollBox scrollBox = this.getScrollBox();
        if (scrollBox != null) {
            scrollBox.setScrollPosition(this.getScrollX(), this.getScrollY());
        }
        this.view.syncChildren();
        this.view.repaint();
    }

    ScrollBox getScrollBox() {
        ObjectBox objectBox = this.getBox();
        if (objectBox != null) {
            return objectBox.getScrollBox();
        }
        return null;
    }

    int getScrollX() {
        return this.hbar.getValue();
    }

    int getScrollY() {
        return this.vbar.getValue();
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
    }

    private static class View
    extends JPanel {
        private Scroller scroller;
        private DocView docView;

        View(Scroller scroller, DocView docView) {
            this.scroller = scroller;
            this.docView = docView;
            this.setLayout(null);
            this.enableEvents(60L);
            this.setOpaque(false);
        }

        public void doLayout() {
            super.doLayout();
            this.syncChildren();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void syncChildren() {
            Object object = this.getTreeLock();
            synchronized (object) {
                int n = this.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Movable movable;
                    ObjectBox objectBox;
                    Component component = this.getComponent(i);
                    if (!(component instanceof Movable) || (objectBox = (movable = (Movable)((Object)component)).getBox()) == null) continue;
                    Point point = new Point(0, 0);
                    objectBox.findAbsolutePosition(point);
                    int n2 = point.x - this.scroller.getScrollX();
                    int n3 = point.y - this.scroller.getScrollY();
                    movable.syncDom(n2, n3, objectBox.checkIfVisible());
                }
            }
        }

        public void paintComponent(Graphics graphics) {
            ScrollBox scrollBox = this.scroller.getScrollBox();
            if (scrollBox != null) {
                int n = this.scroller.getScrollX();
                int n2 = this.scroller.getScrollY();
                graphics.translate(-n, -n2);
                scrollBox.paintScrollable(graphics);
                graphics.translate(n, n2);
            }
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (this.docView.onComponentEvent(this, aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

