/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core.http;

import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.RequestContent;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class EntityEnclosingRequest
extends HttpRequest {
    private RequestEntity requestContent;

    public EntityEnclosingRequest(HttpMethodName httpMethodName, String endpoint, String resourcePath) {
        super(httpMethodName, endpoint, resourcePath);
    }

    public EntityEnclosingRequest(HttpMethodName httpMethodName, String endpoint, String resourcePath, RequestContent requestContent) {
        super(httpMethodName, endpoint, resourcePath);
        this.setRequestContent(requestContent);
    }

    public void setRequestContent(RequestContent requestContent) {
        if (requestContent == null) {
            throw new IllegalArgumentException("RequestContent cannot be null");
        }
        if (this.getHttpMethodName() != HttpMethodName.POST && this.getHttpMethodName() != HttpMethodName.PUT) {
            throw new IllegalArgumentException("Method body can only be added to a PUT or POST methods");
        }
        this.requestContent = requestContent;
    }

    public void setRequestContent(InputStream contentStream, long contentLength, String contentType) {
        this.setRequestContent(new RequestContent(contentStream, contentLength, contentType));
    }

    public void setRequestContent(byte[] content, String contentType) {
        this.setRequestContent(new RequestContent(content, contentType));
    }

    public RequestEntity getRequestContent() {
        return this.requestContent;
    }

    public HttpMethodBase getRequest(boolean refresh) {
        EntityEnclosingMethod baseMethod = (EntityEnclosingMethod)super.getRequest(refresh);
        if (this.getRequestContent() != null) {
            baseMethod.setRequestEntity(this.getRequestContent());
        }
        return baseMethod;
    }
}

