/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.lease;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;

public abstract class AbstractLeaseMap
implements LeaseMap {
    protected final Map map;

    protected AbstractLeaseMap(Lease lease, long l) {
        this(new HashMap(13), lease, l);
    }

    protected AbstractLeaseMap(Map map, Lease lease, long l) {
        this.map = map;
        map.put(lease, new Long(l));
    }

    protected void checkKey(Object object) {
        if (!this.canContainKey(object)) {
            throw new IllegalArgumentException("key is not valid for this LeaseMap");
        }
    }

    protected static void checkValue(Object object) {
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException("value is not a Long");
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object object) {
        this.checkKey(object);
        return this.map.containsKey(object);
    }

    public boolean containsValue(Object object) {
        AbstractLeaseMap.checkValue(object);
        return this.map.containsValue(object);
    }

    public Object get(Object object) {
        this.checkKey(object);
        return this.map.get(object);
    }

    public Object put(Object object, Object object2) {
        this.checkKey(object);
        AbstractLeaseMap.checkValue(object2);
        return this.map.put(object, object2);
    }

    public Object remove(Object object) {
        this.checkKey(object);
        return this.map.remove(object);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return new EntrySet(this.map.entrySet());
    }

    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    private static final class Entry
    implements Map.Entry {
        private final Map.Entry e;

        public Entry(Map.Entry entry) {
            this.e = entry;
        }

        public Object getKey() {
            return this.e.getKey();
        }

        public Object getValue() {
            return this.e.getValue();
        }

        public Object setValue(Object object) {
            AbstractLeaseMap.checkValue(object);
            return this.e.setValue(object);
        }

        public boolean equals(Object object) {
            return this.e.equals(object);
        }

        public int hashCode() {
            return this.e.hashCode();
        }
    }

    private static final class EntryIterator
    implements Iterator {
        private final Iterator iter;

        public EntryIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return new Entry((Map.Entry)this.iter.next());
        }

        public void remove() {
            this.iter.remove();
        }
    }

    private static final class EntrySet
    extends AbstractSet {
        private final Set set;

        public EntrySet(Set set) {
            this.set = set;
        }

        public Iterator iterator() {
            return new EntryIterator(this.set.iterator());
        }

        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        public boolean remove(Object object) {
            return this.set.remove(object);
        }

        public int size() {
            return this.set.size();
        }

        public void clear() {
            this.set.clear();
        }
    }
}

