/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.emu.ConnectionBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ConnectionBufferL2CAP
extends ConnectionBuffer {
    private final int remoteReceiveMTU;

    ConnectionBufferL2CAP(long remoteAddress, String portID, InputStream is, OutputStream os, int remoteReceiveMTU) {
        super(remoteAddress, portID, is, os);
        this.remoteReceiveMTU = remoteReceiveMTU;
    }

    public int getRemoteReceiveMTU() {
        return this.remoteReceiveMTU;
    }

    void send(byte[] data) throws IOException {
        this.monitor.writeTimeStamp = System.currentTimeMillis();
        ++this.monitor.writeOperations;
        this.monitor.writeBytes += (long)data.length;
        byte[] packet = new byte[data.length + 2];
        packet[0] = (byte)(data.length >> 8 & 0xFF);
        packet[1] = (byte)(0xFF & data.length);
        System.arraycopy(data, 0, packet, 2, data.length);
        this.os.write(packet);
    }

    boolean ready() throws IOException {
        return this.is.available() > 1;
    }

    static void readFully(InputStream is, byte[] b, int off, int len) throws IOException, EOFException {
        int rc;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int got = 0; got < len; got += rc) {
            rc = is.read(b, off + got, len - got);
            if (rc >= 0) continue;
            throw new EOFException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] receive(int len) throws IOException {
        byte[] packetData;
        int packetLen;
        byte[] packetLenData = new byte[2];
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            ConnectionBufferL2CAP.readFully(this.is, packetLenData, 0, 2);
            packetLen = (packetLenData[0] << 8 & 0xFF00) + (packetLenData[1] & 0xFF);
            packetData = new byte[packetLen];
            ConnectionBufferL2CAP.readFully(this.is, packetData, 0, packetLen);
        }
        this.monitor.readTimeStamp = System.currentTimeMillis();
        ++this.monitor.readOperations;
        this.monitor.readBytes += (long)packetLen;
        if (packetLen == len) {
            return packetData;
        }
        if (packetLen > len) {
            packetLen = len;
        }
        byte[] b2 = new byte[packetLen];
        System.arraycopy(packetData, 0, b2, 0, packetLen);
        return b2;
    }
}

