/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.emu.Device;
import com.intel.bluetooth.emu.DeviceCommand;
import com.intel.bluetooth.emu.DeviceManagerServiceImpl;
import com.intel.bluetooth.emu.MonitorConnection;
import com.intel.bluetooth.emu.MonitorDevice;
import com.intel.bluetooth.emu.MonitorService;
import com.intel.bluetooth.emu.MonitoringService;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringServiceImpl
implements MonitoringService {
    private static Map<MonitorConnection, Object> connections = new WeakHashMap<MonitorConnection, Object>();
    private static Map<MonitorService, Object> servicess = new WeakHashMap<MonitorService, Object>();

    static void registerService(MonitorService monitorService) {
        servicess.put(monitorService, null);
    }

    static void registerConnection(MonitorConnection monitorConnection) {
        connections.put(monitorConnection, null);
    }

    @Override
    public List<MonitorDevice> getDevices() {
        return DeviceManagerServiceImpl.getMonitorDevices();
    }

    @Override
    public List<MonitorService> getServices() {
        Vector<MonitorService> r = new Vector<MonitorService>();
        r.addAll(servicess.keySet());
        return r;
    }

    @Override
    public List<MonitorConnection> getConnections() {
        Vector<MonitorConnection> r = new Vector<MonitorConnection>();
        r.addAll(connections.keySet());
        return r;
    }

    @Override
    public void setDevicePower(long address, boolean on) {
        Device d = DeviceManagerServiceImpl.getDevice(address);
        if (d != null) {
            d.setDevicePower(on);
        }
    }

    @Override
    public void setDeviceDiscoverable(long address, int mode) {
        Device d = DeviceManagerServiceImpl.getDevice(address);
        if (d != null) {
            d.getDescriptor().setDiscoverableMode(mode);
        }
    }

    @Override
    public void createThreadDumpFile(long address) {
        Device d = DeviceManagerServiceImpl.getDevice(address);
        if (d != null) {
            d.putCommand(new DeviceCommand(DeviceCommand.DeviceCommandType.createThreadDumpFile));
        }
    }

    @Override
    public void shutdownJVM(long address) {
        Device d = DeviceManagerServiceImpl.getDevice(address);
        if (d != null) {
            d.putCommand(new DeviceCommand(DeviceCommand.DeviceCommandType.shutdownJVM));
        }
    }

    @Override
    public void connectionDellayDelivery(long address, long connectionId, int msecDelay) {
    }

    @Override
    public void connectionBreak(long address, long connectionId) {
    }
}

