/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.hdfs;

import com.mathworks.storage.hdfs.ConfigurationSingleton;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;

final class FilesystemCache {
    private final String scheme_;
    private Map<String, FilesystemTaskRunner> fs_cache_;

    public FilesystemCache(String scheme) {
        this.scheme_ = scheme;
        this.fs_cache_ = new HashMap<String, FilesystemTaskRunner>();
    }

    public FilesystemTaskRunner getTaskRunnerForIRI(String iri) throws Exception {
        String auth = FilesystemCache.GetAuthFromIRI(iri);
        FilesystemTaskRunner tr = this.fs_cache_.get(auth);
        if (tr == null) {
            tr = FilesystemCache.GetFilesystemTaskRunnerForAuth(this.scheme_, auth);
            this.fs_cache_.put(auth, tr);
        }
        return tr;
    }

    private static FilesystemTaskRunner GetFilesystemTaskRunnerForAuth(String scheme, String auth) throws Exception {
        URI baseUri = null;
        baseUri = scheme.toLowerCase() == "file" ? URI.create("file:///") : URI.create(scheme + "://" + auth);
        FileSystem fs = null;
        try {
            fs = ConfigurationSingleton.getFileSystem(baseUri);
        }
        catch (Exception e) {
            throw new Exception("Could not get file system for auth: " + auth);
        }
        return new FilesystemTaskRunner(fs, scheme + "://" + auth);
    }

    private static String GetAuthFromIRI(String iri) {
        String auth = "";
        if (iri.length() > 3) {
            int colonSlashSlashPos = iri.indexOf("://");
            int endOfAuth = colonSlashSlashPos != -1 ? iri.indexOf("/", colonSlashSlashPos + 3) : -1;
            auth = colonSlashSlashPos != -1 && endOfAuth != -1 ? iri.substring(colonSlashSlashPos + 3, endOfAuth) : "";
        }
        return auth;
    }

    public static final class FilesystemTaskRunner {
        private FileSystem fs_;
        private final String scheme_and_auth_;

        public FilesystemTaskRunner(FileSystem fs, String schemeAndAuth) {
            this.fs_ = fs;
            this.scheme_and_auth_ = schemeAndAuth;
        }

        public <RetType> RetType runTask(FilesystemTask<RetType> task) throws Exception {
            return task.run(this.fs_);
        }
    }

    public static interface FilesystemTask<RetType> {
        public RetType run(FileSystem var1) throws Exception;
    }
}

