/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.sg.GrowableDataBuffer;
import com.sun.javafx.sg.PGCanvas;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGText;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrTexture;
import java.nio.IntBuffer;
import java.util.LinkedList;
import javafx.geometry.VPos;
import javafx.scene.text.Font;

public class NGCanvas
extends NGNode
implements PGCanvas {
    private static Image TMP_IMAGE = Image.fromIntArgbPreData(new int[1], 1, 1);
    private static Blend BLENDER = new MyBlend(Blend.Mode.SRC_OVER, null, null);
    private GrowableDataBuffer<Object> thebuf;
    private int tw;
    private int th;
    private RenderBuf cv;
    private RenderBuf temp;
    private RenderBuf clip;
    private float globalAlpha = 1.0f;
    private byte fillRule = 0;
    private Blend.Mode blendmode;
    private Paint fillPaint;
    private Paint strokePaint;
    private float linewidth = 1.0f;
    private int linecap = 2;
    private int linejoin = 0;
    private float miterlimit = 10.0f;
    private BasicStroke stroke = null;
    private Path2D path;
    private NGText ngtext;
    private PGFont pgfont;
    private int align = 0;
    private int baseline;
    private Affine2D transform;
    private Affine2D inverseTransform;
    private boolean inversedirty;
    private LinkedList<Path2D> clipStack;
    private Effect effect;
    private int arctype;
    static float[] TEMP_COORDS = new float[6];
    private static Arc2D TEMP_ARC = new Arc2D();
    private static RectBounds TEMP_RECTBOUNDS = new RectBounds();
    static final Affine2D TEMP_PATH_TX = new Affine2D();
    static final int[] numCoords = new int[]{2, 2, 4, 6, 0};
    Shape untransformedPath = new Shape(){

        @Override
        public RectBounds getBounds() {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                RectBounds rectBounds = NGCanvas.this.path.getBounds();
                if (NGCanvas.this.transform.isIdentity()) {
                    return rectBounds;
                }
                float f = (float)NGCanvas.this.transform.getMxt();
                float f2 = (float)NGCanvas.this.transform.getMyt();
                return new RectBounds(rectBounds.getMinX() - f, rectBounds.getMinY() - f2, rectBounds.getMaxX() - f, rectBounds.getMaxY() - f2);
            }
            float f = Float.POSITIVE_INFINITY;
            float f3 = Float.POSITIVE_INFINITY;
            float f4 = Float.NEGATIVE_INFINITY;
            float f5 = Float.NEGATIVE_INFINITY;
            PathIterator pathIterator = NGCanvas.this.path.getPathIterator(NGCanvas.this.getInverseTransform());
            while (!pathIterator.isDone()) {
                int n = numCoords[pathIterator.currentSegment(TEMP_COORDS)];
                for (int i = 0; i < n; i += 2) {
                    if (f > TEMP_COORDS[i + 0]) {
                        f = TEMP_COORDS[i + 0];
                    }
                    if (f4 < TEMP_COORDS[i + 0]) {
                        f4 = TEMP_COORDS[i + 0];
                    }
                    if (f3 > TEMP_COORDS[i + 1]) {
                        f3 = TEMP_COORDS[i + 1];
                    }
                    if (!(f5 < TEMP_COORDS[i + 1])) continue;
                    f5 = TEMP_COORDS[i + 1];
                }
                pathIterator.next();
            }
            return new RectBounds(f, f3, f4, f5);
        }

        @Override
        public boolean contains(float f, float f2) {
            NGCanvas.TEMP_COORDS[0] = f;
            NGCanvas.TEMP_COORDS[1] = f2;
            NGCanvas.this.transform.transform(TEMP_COORDS, 0, TEMP_COORDS, 0, 1);
            f = TEMP_COORDS[0];
            f2 = TEMP_COORDS[1];
            return NGCanvas.this.path.contains(f, f2);
        }

        @Override
        public boolean intersects(float f, float f2, float f3, float f4) {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                f = (float)((double)f + NGCanvas.this.transform.getMxt());
                f2 = (float)((double)f2 + NGCanvas.this.transform.getMyt());
                return NGCanvas.this.path.intersects(f, f2, f3, f4);
            }
            PathIterator pathIterator = NGCanvas.this.path.getPathIterator(NGCanvas.this.getInverseTransform());
            int n = Shape.rectCrossingsForPath(pathIterator, f, f2, f + f3, f2 + f4);
            return n != 0;
        }

        @Override
        public boolean contains(float f, float f2, float f3, float f4) {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                f = (float)((double)f + NGCanvas.this.transform.getMxt());
                f2 = (float)((double)f2 + NGCanvas.this.transform.getMyt());
                return NGCanvas.this.path.contains(f, f2, f3, f4);
            }
            PathIterator pathIterator = NGCanvas.this.path.getPathIterator(NGCanvas.this.getInverseTransform());
            int n = Shape.rectCrossingsForPath(pathIterator, f, f2, f + f3, f2 + f4);
            return n != Integer.MIN_VALUE && n != 0;
        }

        public BaseTransform getCombinedTransform(BaseTransform baseTransform) {
            if (NGCanvas.this.transform.isIdentity()) {
                return baseTransform;
            }
            if (NGCanvas.this.transform.equals(baseTransform)) {
                return null;
            }
            Affine2D affine2D = NGCanvas.this.getInverseTransform();
            if (baseTransform == null || baseTransform.isIdentity()) {
                return affine2D;
            }
            TEMP_PATH_TX.setTransform(baseTransform);
            TEMP_PATH_TX.concatenate(affine2D);
            return TEMP_PATH_TX;
        }

        @Override
        public PathIterator getPathIterator(BaseTransform baseTransform) {
            return NGCanvas.this.path.getPathIterator(this.getCombinedTransform(baseTransform));
        }

        @Override
        public PathIterator getPathIterator(BaseTransform baseTransform, float f) {
            return NGCanvas.this.path.getPathIterator(this.getCombinedTransform(baseTransform), f);
        }

        @Override
        public Shape copy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private static final int[] prcaps = new int[]{0, 1, 2};
    private static final int[] prjoins = new int[]{0, 1, 2};
    private static final int[] prbases = new int[]{VPos.TOP.ordinal(), VPos.CENTER.ordinal(), VPos.BASELINE.ordinal(), VPos.BOTTOM.ordinal()};
    private static final Affine2D TEMP_TX = new Affine2D();

    public NGCanvas() {
        this.cv = new RenderBuf(InitType.PRESERVE_UPPER_LEFT);
        this.temp = new RenderBuf(InitType.CLEAR);
        this.clip = new RenderBuf(InitType.FILL_WHITE);
        this.blendmode = Blend.Mode.SRC_OVER;
        this.fillPaint = Color.BLACK;
        this.strokePaint = Color.BLACK;
        this.path = new Path2D();
        this.ngtext = new NGText();
        this.pgfont = (PGFont)Font.getDefault().impl_getNativeFont();
        this.baseline = VPos.BASELINE.ordinal();
        this.transform = new Affine2D(highestPixelScale, 0.0f, 0.0f, highestPixelScale, 0.0f, 0.0f);
        this.clipStack = new LinkedList();
    }

    private Affine2D getInverseTransform() {
        if (this.inverseTransform == null) {
            this.inverseTransform = new Affine2D();
            this.inversedirty = true;
        }
        if (this.inversedirty) {
            this.inverseTransform.setTransform(this.transform);
            try {
                this.inverseTransform.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                this.inverseTransform.setToScale(0.0, 0.0);
            }
            this.inversedirty = false;
        }
        return this.inverseTransform;
    }

    @Override
    protected boolean hasOverlappingContents() {
        return true;
    }

    private static void shapebounds(Shape shape, RectBounds rectBounds, BaseTransform baseTransform) {
        NGCanvas.TEMP_COORDS[1] = Float.POSITIVE_INFINITY;
        NGCanvas.TEMP_COORDS[0] = Float.POSITIVE_INFINITY;
        NGCanvas.TEMP_COORDS[3] = Float.NEGATIVE_INFINITY;
        NGCanvas.TEMP_COORDS[2] = Float.NEGATIVE_INFINITY;
        Shape.accumulate(TEMP_COORDS, shape, baseTransform);
        rectBounds.setBounds(TEMP_COORDS[0], TEMP_COORDS[1], TEMP_COORDS[2], TEMP_COORDS[3]);
    }

    private static void strokebounds(BasicStroke basicStroke, Shape shape, RectBounds rectBounds, BaseTransform baseTransform) {
        NGCanvas.TEMP_COORDS[1] = Float.POSITIVE_INFINITY;
        NGCanvas.TEMP_COORDS[0] = Float.POSITIVE_INFINITY;
        NGCanvas.TEMP_COORDS[3] = Float.NEGATIVE_INFINITY;
        NGCanvas.TEMP_COORDS[2] = Float.NEGATIVE_INFINITY;
        basicStroke.accumulateShapeBounds(TEMP_COORDS, shape, baseTransform);
        rectBounds.setBounds(TEMP_COORDS[0], TEMP_COORDS[1], TEMP_COORDS[2], TEMP_COORDS[3]);
    }

    @Override
    protected void renderContent(Graphics graphics) {
        this.initCanvas(graphics);
        if (this.cv.tex != null) {
            if (this.thebuf != null) {
                this.thebuf.switchToRead();
                this.renderStream(this.thebuf);
                this.thebuf.resetForWrite();
                this.thebuf = null;
            }
            float f = (float)this.tw / highestPixelScale;
            float f2 = (float)this.th / highestPixelScale;
            graphics.drawTexture(this.cv.tex, 0.0f, 0.0f, f, f2, 0.0f, 0.0f, this.tw, this.th);
            this.cv.save(graphics, this.tw, this.th);
        }
        this.cv.g = null;
        this.clip.g = null;
        this.temp.g = null;
    }

    private void initCanvas(Graphics graphics) {
        if (this.tw <= 0 || this.th <= 0) {
            this.cv.dispose();
            return;
        }
        this.cv.validate(graphics, this.tw, this.th);
    }

    private void initClip() {
        if (this.clip.validate(this.cv.g, this.tw, this.th)) {
            for (Path2D path2D : this.clipStack) {
                this.renderClip(path2D);
            }
        }
    }

    private void renderClip(Path2D path2D) {
        this.temp.validate(this.cv.g, this.tw, this.th);
        this.temp.g.setPaint(Color.WHITE);
        this.temp.g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        this.temp.g.fill(path2D);
        this.blendAthruBintoC(this.temp, Blend.Mode.SRC_IN, this.clip, null, CompositeMode.SRC, this.clip);
    }

    private Rectangle applyEffectOnAintoC(Effect effect, Effect effect2, BaseTransform baseTransform, Rectangle rectangle, CompositeMode compositeMode, RenderBuf renderBuf) {
        PrFilterContext prFilterContext = PrFilterContext.getInstance(renderBuf.tex.getAssociatedScreen());
        ImageData imageData = effect2.filter(prFilterContext, baseTransform, rectangle, null, effect);
        Rectangle rectangle2 = imageData.getUntransformedBounds();
        Filterable filterable = imageData.getUntransformedImage();
        Object t = ((PrTexture)((Object)filterable)).getTextureObject();
        renderBuf.g.setTransform(imageData.getTransform());
        renderBuf.g.setCompositeMode(compositeMode);
        renderBuf.g.drawTexture((Texture)t, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        renderBuf.g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        renderBuf.g.setCompositeMode(CompositeMode.SRC_OVER);
        Rectangle rectangle3 = imageData.getTransformedBounds(rectangle);
        imageData.unref();
        return rectangle3;
    }

    private void blendAthruBintoC(RenderBuf renderBuf, Blend.Mode mode, RenderBuf renderBuf2, RectBounds rectBounds, CompositeMode compositeMode, RenderBuf renderBuf3) {
        BLENDER.setTopInput(renderBuf.input);
        BLENDER.setBottomInput(renderBuf2.input);
        BLENDER.setMode(mode);
        Rectangle rectangle = rectBounds != null ? new Rectangle(rectBounds) : null;
        this.applyEffectOnAintoC(null, BLENDER, BaseTransform.IDENTITY_TRANSFORM, rectangle, compositeMode, renderBuf3);
    }

    private void setupFill(Graphics graphics) {
        graphics.setPaint(this.fillPaint);
    }

    private BasicStroke getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.linewidth, this.linecap, this.linejoin, this.miterlimit);
        }
        return this.stroke;
    }

    private void setupStroke(Graphics graphics) {
        graphics.setStroke(this.getStroke());
        graphics.setPaint(this.strokePaint);
    }

    private void renderStream(GrowableDataBuffer growableDataBuffer) {
        block35: while (!growableDataBuffer.isEmpty()) {
            byte by = growableDataBuffer.getByte();
            switch (by) {
                case 40: {
                    this.path.reset();
                    continue block35;
                }
                case 41: {
                    this.path.moveTo(growableDataBuffer.getFloat(), growableDataBuffer.getFloat());
                    continue block35;
                }
                case 42: {
                    this.path.lineTo(growableDataBuffer.getFloat(), growableDataBuffer.getFloat());
                    continue block35;
                }
                case 43: {
                    this.path.quadTo(growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat());
                    continue block35;
                }
                case 44: {
                    this.path.curveTo(growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat());
                    continue block35;
                }
                case 45: {
                    this.path.closePath();
                    continue block35;
                }
                case 46: {
                    if (highestPixelScale == 1.0f) continue block35;
                    TEMP_TX.setToScale(highestPixelScale, highestPixelScale);
                    this.path.transform(TEMP_TX);
                    continue block35;
                }
                case 13: {
                    Object object3 = (Path2D)growableDataBuffer.getObject();
                    if (highestPixelScale != 1.0f) {
                        TEMP_TX.setToScale(highestPixelScale, highestPixelScale);
                        ((Path2D)object3).transform(TEMP_TX);
                    }
                    this.initClip();
                    this.renderClip((Path2D)object3);
                    this.clipStack.addLast((Path2D)object3);
                    continue block35;
                }
                case 14: {
                    this.clip.dispose();
                    this.clipStack.removeLast();
                    continue block35;
                }
                case 15: {
                    byte by2 = growableDataBuffer.getByte();
                    switch (by2) {
                        case 0: {
                            this.arctype = 0;
                            break;
                        }
                        case 1: {
                            this.arctype = 1;
                            break;
                        }
                        case 2: {
                            this.arctype = 2;
                        }
                    }
                    continue block35;
                }
                case 52: {
                    float f = growableDataBuffer.getInt();
                    float f2 = growableDataBuffer.getInt();
                    int n = growableDataBuffer.getInt();
                    TMP_IMAGE.setArgb(0, 0, n);
                    Graphics graphics = this.cv.g;
                    graphics.setExtraAlpha(1.0f);
                    graphics.setCompositeMode(CompositeMode.SRC);
                    graphics.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                    ResourceFactory resourceFactory = graphics.getResourceFactory();
                    Object object = resourceFactory.getCachedTexture(TMP_IMAGE, false);
                    graphics.drawTexture((Texture)object, f *= highestPixelScale, f2 *= highestPixelScale, f + highestPixelScale, f2 + highestPixelScale, 0.0f, 0.0f, 1.0f, 1.0f);
                    continue block35;
                }
                case 53: {
                    float f = growableDataBuffer.getInt();
                    float f3 = growableDataBuffer.getInt();
                    int n = growableDataBuffer.getInt();
                    int n2 = growableDataBuffer.getInt();
                    byte[] byArray = (byte[])growableDataBuffer.getObject();
                    Object object = Image.fromByteBgraPreData(byArray, n, n2);
                    Graphics graphics = this.cv.g;
                    ResourceFactory resourceFactory = graphics.getResourceFactory();
                    Texture texture = resourceFactory.getCachedTexture((Image)object, false);
                    graphics.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                    graphics.setCompositeMode(CompositeMode.SRC);
                    float f4 = f + (float)n;
                    float f5 = f3 + (float)n2;
                    graphics.drawTexture(texture, f *= highestPixelScale, f3 *= highestPixelScale, f4 *= highestPixelScale, f5 *= highestPixelScale, 0.0f, 0.0f, n, n2);
                    graphics.setCompositeMode(CompositeMode.SRC_OVER);
                    continue block35;
                }
                case 11: {
                    double d = growableDataBuffer.getDouble() * (double)highestPixelScale;
                    double d2 = growableDataBuffer.getDouble() * (double)highestPixelScale;
                    double d3 = growableDataBuffer.getDouble() * (double)highestPixelScale;
                    double d4 = growableDataBuffer.getDouble() * (double)highestPixelScale;
                    double d5 = growableDataBuffer.getDouble() * (double)highestPixelScale;
                    double d6 = growableDataBuffer.getDouble() * (double)highestPixelScale;
                    this.transform.setTransform(d, d4, d2, d5, d3, d6);
                    this.inversedirty = true;
                    continue block35;
                }
                case 0: {
                    this.globalAlpha = growableDataBuffer.getFloat();
                    continue block35;
                }
                case 16: {
                    this.fillRule = growableDataBuffer.getByte();
                    if (this.fillRule == 0) {
                        this.path.setWindingRule(1);
                        continue block35;
                    }
                    this.path.setWindingRule(0);
                    continue block35;
                }
                case 1: {
                    this.blendmode = (Blend.Mode)((Object)growableDataBuffer.getObject());
                    continue block35;
                }
                case 2: {
                    this.fillPaint = (Paint)growableDataBuffer.getObject();
                    continue block35;
                }
                case 3: {
                    this.strokePaint = (Paint)growableDataBuffer.getObject();
                    continue block35;
                }
                case 4: {
                    this.linewidth = growableDataBuffer.getFloat();
                    this.stroke = null;
                    continue block35;
                }
                case 5: {
                    this.linecap = prcaps[growableDataBuffer.getUByte()];
                    this.stroke = null;
                    continue block35;
                }
                case 6: {
                    this.linejoin = prjoins[growableDataBuffer.getUByte()];
                    this.stroke = null;
                    continue block35;
                }
                case 7: {
                    this.miterlimit = growableDataBuffer.getFloat();
                    this.stroke = null;
                    continue block35;
                }
                case 8: {
                    this.pgfont = (PGFont)growableDataBuffer.getObject();
                    continue block35;
                }
                case 9: {
                    this.align = growableDataBuffer.getUByte();
                    continue block35;
                }
                case 10: {
                    this.baseline = prbases[growableDataBuffer.getUByte()];
                    continue block35;
                }
                case 60: {
                    BaseTransform baseTransform;
                    RenderBuf renderBuf;
                    Object object3 = (Effect)growableDataBuffer.getObject();
                    RenderBuf renderBuf2 = renderBuf = this.clipStack.isEmpty() ? this.cv : this.temp;
                    if (highestPixelScale != 1.0f) {
                        TEMP_TX.setToScale(highestPixelScale, highestPixelScale);
                        baseTransform = TEMP_TX;
                        this.cv.input.setPixelScale(highestPixelScale);
                    } else {
                        baseTransform = BaseTransform.IDENTITY_TRANSFORM;
                    }
                    this.applyEffectOnAintoC(this.cv.input, (Effect)object3, baseTransform, null, CompositeMode.SRC, renderBuf);
                    this.cv.input.setPixelScale(1.0f);
                    if (renderBuf == this.cv) continue block35;
                    this.blendAthruBintoC(renderBuf, Blend.Mode.SRC_IN, this.clip, null, CompositeMode.SRC, this.cv);
                    continue block35;
                }
                case 12: {
                    this.effect = (Effect)growableDataBuffer.getObject();
                    continue block35;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 47: 
                case 48: 
                case 50: 
                case 51: {
                    Object object;
                    Object object2;
                    Object object3;
                    if (this.clipStack.isEmpty() && this.blendmode == Blend.Mode.SRC_OVER) {
                        object3 = this.cv;
                    } else {
                        this.temp.validate(this.cv.g, this.tw, this.th);
                        object3 = this.temp;
                    }
                    if (this.effect != null) {
                        growableDataBuffer.save();
                        this.handleRenderOp(by, growableDataBuffer, null, TEMP_RECTBOUNDS);
                        object2 = new RenderInput(by, growableDataBuffer, this.transform, TEMP_RECTBOUNDS);
                        object = this.applyEffectOnAintoC((Effect)object2, this.effect, this.transform, null, CompositeMode.SRC_OVER, (RenderBuf)object3);
                        if (object3 != this.cv) {
                            TEMP_RECTBOUNDS.setBounds(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height);
                        }
                    } else {
                        object2 = ((RenderBuf)object3).g;
                        object2.setExtraAlpha(this.globalAlpha);
                        object2.setTransform(this.transform);
                        object = object3 != this.cv ? TEMP_RECTBOUNDS : null;
                        this.handleRenderOp(by, growableDataBuffer, (Graphics)object2, (RectBounds)object);
                    }
                    if (!this.clipStack.isEmpty()) {
                        if (this.blendmode == Blend.Mode.SRC_OVER) {
                            object3 = this.cv;
                            object2 = CompositeMode.SRC_OVER;
                        } else {
                            object3 = this.temp;
                            object2 = CompositeMode.SRC;
                        }
                        this.initClip();
                        this.blendAthruBintoC(this.temp, Blend.Mode.SRC_IN, this.clip, TEMP_RECTBOUNDS, (CompositeMode)((Object)object2), (RenderBuf)object3);
                    }
                    if (this.blendmode == Blend.Mode.SRC_OVER) continue block35;
                    this.blendAthruBintoC(this.temp, this.blendmode, this.cv, TEMP_RECTBOUNDS, CompositeMode.SRC, this.cv);
                    continue block35;
                }
            }
            throw new InternalError("Unrecognized PGCanvas token: " + by);
        }
    }

    public void handleRenderOp(int n, GrowableDataBuffer growableDataBuffer, Graphics graphics, RectBounds rectBounds) {
        float f;
        boolean bl = false;
        boolean bl2 = false;
        switch (n) {
            case 47: {
                if (rectBounds != null) {
                    NGCanvas.shapebounds(this.path, rectBounds, BaseTransform.IDENTITY_TRANSFORM);
                }
                if (graphics == null) break;
                this.setupFill(graphics);
                graphics.fill(this.untransformedPath);
                break;
            }
            case 48: {
                if (rectBounds != null) {
                    NGCanvas.strokebounds(this.getStroke(), this.untransformedPath, rectBounds, this.transform);
                }
                if (graphics == null) break;
                this.setupStroke(graphics);
                graphics.draw(this.untransformedPath);
                break;
            }
            case 23: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f3 = growableDataBuffer.getFloat();
                float f4 = growableDataBuffer.getFloat();
                if (rectBounds != null) {
                    rectBounds.setBoundsAndSort(f2, f, f3, f4);
                    bl = true;
                    bl2 = true;
                }
                if (graphics == null) break;
                this.setupStroke(graphics);
                graphics.drawLine(f2, f, f3, f4);
                break;
            }
            case 21: 
            case 25: {
                bl = true;
            }
            case 20: 
            case 22: 
            case 24: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f5 = growableDataBuffer.getFloat();
                float f6 = growableDataBuffer.getFloat();
                if (rectBounds != null) {
                    rectBounds.setBounds(f2, f, f2 + f5, f + f6);
                    bl2 = true;
                }
                if (graphics == null) break;
                switch (n) {
                    case 20: {
                        this.setupFill(graphics);
                        graphics.fillRect(f2, f, f5, f6);
                        break;
                    }
                    case 24: {
                        this.setupFill(graphics);
                        graphics.fillEllipse(f2, f, f5, f6);
                        break;
                    }
                    case 21: {
                        this.setupStroke(graphics);
                        graphics.drawRect(f2, f, f5, f6);
                        break;
                    }
                    case 25: {
                        this.setupStroke(graphics);
                        graphics.drawEllipse(f2, f, f5, f6);
                        break;
                    }
                    case 22: {
                        graphics.setPaint(Color.TRANSPARENT);
                        graphics.setCompositeMode(CompositeMode.SRC);
                        graphics.fillRect(f2, f, f5, f6);
                        graphics.setCompositeMode(CompositeMode.SRC_OVER);
                    }
                }
                break;
            }
            case 27: {
                bl = true;
            }
            case 26: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f7 = growableDataBuffer.getFloat();
                float f8 = growableDataBuffer.getFloat();
                float f9 = growableDataBuffer.getFloat();
                float f10 = growableDataBuffer.getFloat();
                if (rectBounds != null) {
                    rectBounds.setBounds(f2, f, f2 + f7, f + f8);
                    bl2 = true;
                }
                if (graphics == null) break;
                if (n == 26) {
                    this.setupFill(graphics);
                    graphics.fillRoundRect(f2, f, f7, f8, f9, f10);
                    break;
                }
                this.setupStroke(graphics);
                graphics.drawRoundRect(f2, f, f7, f8, f9, f10);
                break;
            }
            case 28: 
            case 29: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f11 = growableDataBuffer.getFloat();
                float f12 = growableDataBuffer.getFloat();
                float f13 = growableDataBuffer.getFloat();
                float f14 = growableDataBuffer.getFloat();
                TEMP_ARC.setArc(f2, f, f11, f12, f13, f14, this.arctype);
                if (n == 28) {
                    if (rectBounds != null) {
                        NGCanvas.shapebounds(TEMP_ARC, rectBounds, this.transform);
                    }
                    if (graphics == null) break;
                    this.setupFill(graphics);
                    graphics.fill(TEMP_ARC);
                    break;
                }
                if (rectBounds != null) {
                    NGCanvas.strokebounds(this.getStroke(), TEMP_ARC, rectBounds, this.transform);
                }
                if (graphics == null) break;
                this.setupStroke(graphics);
                graphics.draw(TEMP_ARC);
                break;
            }
            case 50: 
            case 51: {
                float f15;
                float f16;
                float f17;
                float f18;
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f19 = growableDataBuffer.getFloat();
                float f20 = growableDataBuffer.getFloat();
                Image image = (Image)growableDataBuffer.getObject();
                if (n == 50) {
                    f18 = 0.0f;
                    f17 = 0.0f;
                    f16 = image.getWidth();
                    f15 = image.getHeight();
                } else {
                    f17 = growableDataBuffer.getFloat();
                    f18 = growableDataBuffer.getFloat();
                    f16 = growableDataBuffer.getFloat();
                    f15 = growableDataBuffer.getFloat();
                    float f21 = image.getPixelScale();
                    if (f21 != 1.0f) {
                        f17 *= f21;
                        f18 *= f21;
                        f16 *= f21;
                        f15 *= f21;
                    }
                }
                if (rectBounds != null) {
                    rectBounds.setBounds(f2, f, f2 + f19, f + f20);
                    bl2 = true;
                }
                if (graphics == null) break;
                ResourceFactory resourceFactory = graphics.getResourceFactory();
                Texture texture = resourceFactory.getCachedTexture(image, false);
                graphics.drawTexture(texture, f2, f, f2 + f19, f + f20, f17, f18, f17 + f16, f18 + f15, 0);
                break;
            }
            case 30: 
            case 31: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f22 = growableDataBuffer.getFloat();
                String string = (String)growableDataBuffer.getObject();
                this.ngtext.setFont(this.pgfont);
                this.ngtext.helper.setTextOrigin(this.baseline);
                this.ngtext.setText(string);
                float f23 = this.ngtext.helper.getLogicalWidth();
                float f24 = 0.0f;
                this.ngtext.helper.setTextAlignment(this.align);
                if (this.align != 0) {
                    if (this.align == 2) {
                        f24 = -f23;
                    } else if (this.align == 1) {
                        f24 = -f23 * 0.5f;
                    }
                }
                if ((double)f22 > 0.0 && f23 > f22) {
                    float f25 = f22 / f23;
                    TEMP_TX.setTransform(this.transform);
                    TEMP_TX.translate(f2 += f24 * f25, f);
                    TEMP_TX.scale(f25, 1.0);
                    f2 = 0.0f;
                    f = 0.0f;
                    graphics.setTransform(TEMP_TX);
                } else {
                    f2 += f24;
                }
                if (n == 30) {
                    this.ngtext.setMode(PGShape.Mode.FILL);
                    this.ngtext.setFillPaint(this.fillPaint);
                    this.ngtext.setDrawPaint(null);
                } else {
                    this.ngtext.setMode(PGShape.Mode.STROKE);
                    BasicStroke basicStroke = this.getStroke();
                    if (graphics != null) {
                        graphics.setStroke(basicStroke);
                    }
                    this.ngtext.setDrawStroke(basicStroke);
                    this.ngtext.setFillPaint(null);
                    this.ngtext.setDrawPaint(this.strokePaint);
                }
                this.ngtext.setLocation(f2, f);
                if (rectBounds != null) {
                    this.ngtext.helper.computeContentBounds(rectBounds, this.transform);
                }
                if (graphics == null) break;
                this.ngtext.renderContent(graphics);
                break;
            }
            default: {
                throw new InternalError("Unrecognized PGCanvas rendering token: " + n);
            }
        }
        if (rectBounds != null) {
            BasicStroke basicStroke;
            if (bl && (basicStroke = this.getStroke()).getType() != 1) {
                f = basicStroke.getLineWidth();
                if (basicStroke.getType() == 0) {
                    f /= 2.0f;
                }
                rectBounds.grow(f, f);
            }
            if (bl2) {
                NGCanvas.txBounds(rectBounds, this.transform);
            }
        }
    }

    static void txBounds(RectBounds rectBounds, BaseTransform baseTransform) {
        switch (baseTransform.getType()) {
            case 0: {
                break;
            }
            case 1: {
                float f = (float)baseTransform.getMxt();
                float f2 = (float)baseTransform.getMyt();
                rectBounds.setBounds(rectBounds.getMinX() + f, rectBounds.getMinY() + f2, rectBounds.getMaxX() + f, rectBounds.getMaxY() + f2);
                break;
            }
            default: {
                BaseBounds baseBounds = baseTransform.transform(rectBounds, rectBounds);
                if (baseBounds == rectBounds) break;
                rectBounds.setBounds(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getMaxX(), baseBounds.getMaxY());
            }
        }
    }

    static void inverseTxBounds(RectBounds rectBounds, BaseTransform baseTransform) {
        switch (baseTransform.getType()) {
            case 0: {
                break;
            }
            case 1: {
                float f = (float)baseTransform.getMxt();
                float f2 = (float)baseTransform.getMyt();
                rectBounds.setBounds(rectBounds.getMinX() - f, rectBounds.getMinY() - f2, rectBounds.getMaxX() - f, rectBounds.getMaxY() - f2);
                break;
            }
            default: {
                try {
                    BaseBounds baseBounds = baseTransform.inverseTransform(rectBounds, rectBounds);
                    if (baseBounds == rectBounds) break;
                    rectBounds.setBounds(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getMaxX(), baseBounds.getMaxY());
                    break;
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    rectBounds.makeEmpty();
                }
            }
        }
    }

    @Override
    public void updateBounds(float f, float f2) {
        this.tw = (int)Math.ceil(f * highestPixelScale);
        this.th = (int)Math.ceil(f2 * highestPixelScale);
        this.geometryChanged();
    }

    @Override
    public void updateRendering(GrowableDataBuffer growableDataBuffer) {
        this.thebuf = growableDataBuffer;
        this.geometryChanged();
    }

    static class EffectInput
    extends Effect {
        RTTexture tex;
        float pixelscale;

        EffectInput(RTTexture rTTexture) {
            this.tex = rTTexture;
            this.pixelscale = 1.0f;
        }

        public void setPixelScale(float f) {
            this.pixelscale = f;
        }

        @Override
        public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
            PrDrawable prDrawable = PrDrawable.create(filterContext, this.tex);
            Rectangle rectangle2 = new Rectangle(this.tex.getContentWidth(), this.tex.getContentHeight());
            ImageData imageData = new ImageData(filterContext, prDrawable, rectangle2);
            if (this.pixelscale != 1.0f || !baseTransform.isIdentity()) {
                Affine2D affine2D = new Affine2D();
                affine2D.scale(1.0f / this.pixelscale, 1.0f / this.pixelscale);
                affine2D.concatenate(baseTransform);
                imageData = imageData.transform(affine2D);
            }
            return imageData;
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext filterContext) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
            Rectangle rectangle = new Rectangle(this.tex.getContentWidth(), this.tex.getContentHeight());
            return EffectInput.transformBounds(baseTransform, new RectBounds(rectangle));
        }
    }

    static class MyBlend
    extends Blend {
        public MyBlend(Blend.Mode mode, Effect effect, Effect effect2) {
            super(mode, effect, effect2);
        }

        @Override
        public Rectangle getResultBounds(BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
            Rectangle rectangle2 = super.getResultBounds(baseTransform, rectangle, imageDataArray);
            rectangle2.intersectWith(rectangle);
            return rectangle2;
        }
    }

    class RenderInput
    extends Effect {
        float x;
        float y;
        float w;
        float h;
        int token;
        GrowableDataBuffer<Object> buf;
        Affine2D savedBoundsTx = new Affine2D();

        public RenderInput(int n, GrowableDataBuffer<Object> growableDataBuffer, BaseTransform baseTransform, RectBounds rectBounds) {
            this.token = n;
            this.buf = growableDataBuffer;
            this.savedBoundsTx.setTransform(baseTransform);
            this.x = rectBounds.getMinX();
            this.y = rectBounds.getMinY();
            this.w = rectBounds.getWidth();
            this.h = rectBounds.getHeight();
        }

        @Override
        public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
            PrDrawable prDrawable;
            BaseBounds baseBounds = this.getBounds(baseTransform, effect);
            if (rectangle != null) {
                baseBounds.intersectWith(rectangle);
            }
            Rectangle rectangle2 = new Rectangle(baseBounds);
            if (rectangle2.width < 1) {
                rectangle2.width = 1;
            }
            if (rectangle2.height < 1) {
                rectangle2.height = 1;
            }
            if ((prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, rectangle2.width, rectangle2.height)) != null) {
                Graphics graphics = prDrawable.createGraphics();
                graphics.setExtraAlpha(NGCanvas.this.globalAlpha);
                graphics.translate(-rectangle2.x, -rectangle2.y);
                if (baseTransform != null) {
                    graphics.transform(baseTransform);
                }
                this.buf.restore();
                NGCanvas.this.handleRenderOp(this.token, this.buf, graphics, null);
            }
            return new ImageData(filterContext, prDrawable, rectangle2);
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext filterContext) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
            RectBounds rectBounds = new RectBounds(this.x, this.y, this.x + this.w, this.y + this.h);
            if (!baseTransform.equals(this.savedBoundsTx)) {
                NGCanvas.inverseTxBounds(rectBounds, this.savedBoundsTx);
                NGCanvas.txBounds(rectBounds, baseTransform);
            }
            return rectBounds;
        }
    }

    private static class PixelData {
        private IntBuffer pixels = null;
        private boolean validPixels = false;
        private int cw;
        private int ch;

        private PixelData(Graphics graphics, int n, int n2) {
            this.cw = n;
            this.ch = n2;
            this.pixels = IntBuffer.allocate(n * n2);
        }

        private void save(Graphics graphics, RTTexture rTTexture) {
            int n = rTTexture.getContentWidth();
            int n2 = rTTexture.getContentHeight();
            if (this.cw < n || this.ch < n2) {
                this.cw = n;
                this.ch = n2;
                this.pixels = IntBuffer.allocate(this.cw * this.ch);
            }
            this.pixels.rewind();
            rTTexture.readPixels(this.pixels);
            this.validPixels = true;
        }

        private void restore(Graphics graphics, int n, int n2) {
            if (this.validPixels) {
                Image image = Image.fromIntArgbPreData(this.pixels, n, n2);
                Texture texture = graphics.getResourceFactory().createTexture(image);
                graphics.drawTexture(texture, 0.0f, 0.0f, n, n2);
                texture.dispose();
                this.validPixels = false;
            }
        }
    }

    static class RenderBuf {
        final InitType init_type;
        RTTexture tex;
        Graphics g;
        EffectInput input;
        private PixelData savedPixelData = null;

        public RenderBuf(InitType initType) {
            this.init_type = initType;
        }

        public void dispose() {
            if (this.tex != null) {
                this.tex.dispose();
            }
            this.tex = null;
            this.g = null;
            this.input = null;
        }

        public boolean validate(Graphics graphics, int n, int n2) {
            int n3;
            int n4 = this.tex == null ? 0 : this.tex.getContentWidth();
            int n5 = n3 = this.tex == null ? 0 : this.tex.getContentHeight();
            if (this.tex == null || n4 < n || n3 < n2) {
                RTTexture rTTexture;
                RTTexture rTTexture2 = this.tex;
                this.tex = rTTexture = graphics.getResourceFactory().createRTTexture(n, n2);
                this.g = rTTexture.createGraphics();
                this.input = new EffectInput(rTTexture);
                if (rTTexture2 != null) {
                    if (this.init_type == InitType.PRESERVE_UPPER_LEFT) {
                        this.g.setCompositeMode(CompositeMode.SRC);
                        if (rTTexture2.createGraphics() == null) {
                            if (this.savedPixelData != null) {
                                this.savedPixelData.restore(this.g, n4, n3);
                            }
                        } else {
                            this.g.drawTexture(rTTexture2, 0.0f, 0.0f, n4, n3);
                        }
                        this.g.setCompositeMode(CompositeMode.SRC_OVER);
                    }
                    rTTexture2.dispose();
                }
                if (this.init_type == InitType.FILL_WHITE) {
                    this.g.setPaint(Color.WHITE);
                    this.g.fillRect(0.0f, 0.0f, n, n2);
                }
                return true;
            }
            if (this.g == null) {
                this.g = this.tex.createGraphics();
                if (this.g == null) {
                    this.tex.dispose();
                    this.tex = graphics.getResourceFactory().createRTTexture(n, n2);
                    this.g = this.tex.createGraphics();
                    this.input = new EffectInput(this.tex);
                    if (this.savedPixelData != null) {
                        this.g.setCompositeMode(CompositeMode.SRC);
                        this.savedPixelData.restore(this.g, n, n2);
                        this.g.setCompositeMode(CompositeMode.SRC_OVER);
                    } else if (this.init_type == InitType.FILL_WHITE) {
                        this.g.setPaint(Color.WHITE);
                        this.g.fillRect(0.0f, 0.0f, n, n2);
                    }
                    return true;
                }
            }
            if (this.init_type == InitType.CLEAR) {
                this.g.setCompositeMode(CompositeMode.CLEAR);
                this.g.fillRect(0.0f, 0.0f, n, n2);
                this.g.setCompositeMode(CompositeMode.SRC_OVER);
            }
            return false;
        }

        private void save(Graphics graphics, int n, int n2) {
            if (this.tex.isVolatile()) {
                if (this.savedPixelData == null) {
                    this.savedPixelData = new PixelData(graphics, n, n2);
                }
                this.savedPixelData.save(graphics, this.tex);
            }
        }
    }

    static enum InitType {
        CLEAR,
        FILL_WHITE,
        PRESERVE_UPPER_LEFT;

    }
}

