/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop.toolstrip;

import com.mathworks.project.impl.ResourceUtils;
import com.mathworks.project.impl.desktop.ToolstripProjectClient;
import com.mathworks.project.impl.desktop.toolstrip.ProjectToolstripSection;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSList;
import com.mathworks.toolstrip.sections.FlowToolstripSection;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractFilesetToolstripSection
extends FlowToolstripSection
implements ProjectToolstripSection {
    private Configuration fConfig;
    private TSList fEntryPointList;
    private List<ChangeListener> fChangeListeners;
    private ToolstripProjectClient fClient;
    private static final SecretFile SECRET_FILE = new SecretFile();

    public AbstractFilesetToolstripSection(ToolstripProjectClient toolstripProjectClient, Configuration configuration, String string, String string2) {
        super(string, string2, -4);
        this.fClient = toolstripProjectClient;
        this.fConfig = configuration;
        this.fEntryPointList = this.createTSList();
        this.fEntryPointList.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int n, int n2) {
                if (AbstractFilesetToolstripSection.this.allowSelection()) {
                    super.setSelectionInterval(n, n2);
                }
            }
        });
        this.fChangeListeners = new ArrayList<ChangeListener>();
    }

    protected abstract boolean allowSelection();

    protected void fireChangeListeners() {
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    protected String getFirstFileName() {
        File file = (File)this.fEntryPointList.getModel().getElementAt(0);
        return file == null || file.getName().lastIndexOf(46) == -1 ? null : file.getName().substring(0, file.getName().lastIndexOf(46));
    }

    public abstract FileSetInstance getFileSet();

    public abstract TSButton getButton();

    protected abstract TSList createTSList();

    protected abstract String getEmptyFilesString();

    protected void addEmptyFilesObject() {
        ((DefaultListModel)this.fEntryPointList.getModel()).add(0, SECRET_FILE);
    }

    protected TSList getEntryPointList() {
        return this.fEntryPointList;
    }

    protected Set<File> validateFiles(File[] fileArray) {
        HashSet<File> hashSet = new HashSet<File>();
        if (fileArray != null && fileArray.length > 0) {
            for (File file : fileArray) {
                if (this.isValidFile(file)) continue;
                hashSet.add(file);
            }
        }
        return hashSet;
    }

    protected boolean isValidFile(File file) {
        return this.getFileSet().getDefinition().allow(file);
    }

    @Override
    public boolean readyForPackage() {
        return this.getFileSet().getCurrentCount() > 0;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    @Override
    public void close() {
        this.fChangeListeners.clear();
    }

    public Configuration getConfiguration() {
        return this.fConfig;
    }

    public abstract void removeNonEntryPointFiles(Collection<File> var1);

    public ToolstripProjectClient getClient() {
        return this.fClient;
    }

    private static class SecretFile {
        private SecretFile() {
        }
    }

    protected class EntryPointRenderer
    extends DefaultListCellRenderer {
        public EntryPointRenderer() {
            this.setHorizontalTextPosition(11);
            this.setIconTextGap(4);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            assert (object instanceof File || object instanceof SecretFile);
            if (object instanceof SecretFile) {
                jLabel.setText(AbstractFilesetToolstripSection.this.getEmptyFilesString());
                jLabel.setFont(jLabel.getFont().deriveFont(2));
                jList.setBackground(ResourceUtils.ERROR_COLOR);
                jLabel.setToolTipText(jList.getToolTipText());
            } else {
                File file = (File)object;
                jLabel.setText(file.getName());
                jLabel.setToolTipText(file.getAbsolutePath());
                jLabel.setFont(jLabel.getFont().deriveFont(0));
                if (file.isDirectory()) {
                    jLabel.setIcon(ResourceUtils.FOLDER_ICON);
                } else {
                    jLabel.setIcon(ResourceUtils.FUNCTION_FILE_ICON);
                }
                jList.setBackground(Color.WHITE);
            }
            return jLabel;
        }
    }
}

