/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.project.api.ReadableEntityInstance;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.HyperlinkMJLabel;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.BasicProjectClient;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.ReferenceOptionDialog;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;

public final class FileSetLinkUtils {
    public static final Color DEFAULT_LINK_COLOR = new Color(2118279);

    private FileSetLinkUtils() {
    }

    static HyperlinkMJLabel createRootLevelAddLink(final FileSetEditor fileSetEditor) {
        final FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        String string = BuiltInResources.getString("link.addfiles");
        if (fileSetInstance.getDefinition().allowsDirectories()) {
            string = BuiltInResources.getString("link.addfiles.ordirs");
        }
        if (fileSetInstance.getDefinition().getHierarchyLevels() == 2) {
            if (!fileSetEditor.supportsEntityAddAndRemove()) {
                return null;
            }
            string = MessageFormat.format(BuiltInResources.getString("link.add"), FileSetLinkUtils.capitalizedLinkText(fileSetInstance));
        }
        if (fileSetInstance.getDefinition().getMaxCount() == 1) {
            string = MessageFormat.format(BuiltInResources.getString("link.add"), FileSetLinkUtils.capitalizedLinkText(fileSetInstance));
        }
        HyperlinkMJLabel hyperlinkMJLabel = new HyperlinkMJLabel(string, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (fileSetInstance.getDefinition().getHierarchyLevels() == 2) {
                    ((BasicProjectClient)ProjectGUI.getInstance().getCurrentClient()).addNewEntity();
                } else {
                    FileSetLinkUtils.showRootLevelAddDialog(fileSetEditor);
                }
            }
        }, "link.add." + fileSetEditor.getFileSet().getDefinition().getKey());
        hyperlinkMJLabel.setBackground(FileSetEditor.BACKGROUND);
        hyperlinkMJLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        hyperlinkMJLabel.setVisible(true);
        return hyperlinkMJLabel;
    }

    private static String capitalizedLinkText(FileSetInstance fileSetInstance) {
        String string = fileSetInstance.getDefinition().getName().toLowerCase();
        return string.replace("matlab", "MATLAB");
    }

    static HyperlinkMJLabel createEntityLevelAddLink(final FileSetEditor fileSetEditor, final EntityInstance entityInstance) {
        FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        EntityInstance entityInstance2 = fileSetInstance.getRootEntities().iterator().next();
        int n = fileSetInstance.getChildren((ReadableEntityInstance)entityInstance2).indexOf(entityInstance);
        String string = BuiltInResources.getString("link.addfiles");
        HyperlinkMJLabel hyperlinkMJLabel = new HyperlinkMJLabel(string, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FileSetLinkUtils.showEntityLevelAddDialog(fileSetEditor, entityInstance);
            }
        }, "link.add.entity." + n);
        hyperlinkMJLabel.setBackground(FileSetEditor.BACKGROUND);
        hyperlinkMJLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        return hyperlinkMJLabel;
    }

    static void showRootLevelAddDialog(FileSetEditor fileSetEditor) {
        FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
            File[] fileArray = DeployToolTestUtils.showSimpleFileChooser();
            if (fileArray != null) {
                fileSetEditor.addAndSelect(fileArray, true);
            }
        } else {
            File[] fileArray;
            FileChooser fileChooser = FileSetLinkUtils.createFileChooser(fileSetEditor.getComponent(), fileSetInstance.getDefinition());
            if (!fileSetInstance.getDefinition().getFilters().isEmpty()) {
                fileChooser.setAcceptAllFileFilterUsed(false);
            }
            if ((fileArray = fileChooser.showOpenDialog()) != null) {
                fileSetEditor.addAndSelect(fileArray, true);
            }
        }
    }

    static void showEntityLevelAddDialog(FileSetEditor fileSetEditor, EntityInstance entityInstance) {
        FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
            File[] fileArray = DeployToolTestUtils.showSimpleFileChooser();
            if (fileArray != null) {
                fileSetEditor.addAndSelect(entityInstance, fileArray, true);
            }
        } else {
            FileChooser fileChooser = FileSetLinkUtils.createFileChooser(fileSetEditor.getComponent(), fileSetInstance.getDefinition());
            File[] fileArray = fileChooser.showOpenDialog();
            if (fileArray != null) {
                fileSetEditor.addAndSelect(entityInstance, fileArray, true);
            }
        }
    }

    static FileChooser createFileChooser(Component component, FileSetDefinition fileSetDefinition) {
        return FileChooser.create(component, BuiltInResources.getString("dialog.title.addfiles"), new File(MatlabPath.getCWD()), fileSetDefinition.allowsDirectories(), fileSetDefinition.getFilters());
    }

    static HyperlinkMJLabel createRootLevelRemoveLink(FileSetEditor fileSetEditor) {
        final FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        assert (fileSetInstance.getDefinition().getMaxCount() == 1);
        String string = MessageFormat.format(BuiltInResources.getString("link.remove"), FileSetLinkUtils.capitalizedLinkText(fileSetInstance));
        HyperlinkMJLabel hyperlinkMJLabel = new HyperlinkMJLabel(string, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                assert (fileSetInstance.getCurrentCount() == 1);
                fileSetInstance.remove(Arrays.asList(fileSetInstance.getFiles().iterator().next()));
            }
        }, "link.remove." + fileSetEditor.getFileSet().getDefinition().getKey());
        hyperlinkMJLabel.setBackground(FileSetEditor.BACKGROUND);
        hyperlinkMJLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        return hyperlinkMJLabel;
    }

    static HyperlinkMJLabel createSpecialFileAddLink(final FileSetEditor fileSetEditor, final SpecialFile specialFile, final Configuration configuration) {
        String string = MessageFormat.format(BuiltInResources.getString("link.add"), specialFile.getName());
        HyperlinkMJLabel hyperlinkMJLabel = new HyperlinkMJLabel(string, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ReferenceOptionDialog.show(specialFile, configuration, fileSetEditor, specialFile.getLocationPreferencePanelName());
            }
        }, "link.add." + specialFile.getKey());
        hyperlinkMJLabel.setToolTipText(specialFile.getDescription());
        hyperlinkMJLabel.setBackground(FileSetEditor.BACKGROUND);
        hyperlinkMJLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        return hyperlinkMJLabel;
    }

    static HyperlinkMJLabel createSpecialFileRemoveLink(final FileSetEditor fileSetEditor, SpecialFile specialFile, final File file) {
        String string = MessageFormat.format(BuiltInResources.getString("link.remove"), specialFile.getName());
        HyperlinkMJLabel hyperlinkMJLabel = new HyperlinkMJLabel(string, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                fileSetEditor.getFileSet().remove(Arrays.asList(file));
            }
        }, "link.remove." + specialFile.getKey());
        hyperlinkMJLabel.setBackground(FileSetEditor.BACKGROUND);
        hyperlinkMJLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        return hyperlinkMJLabel;
    }

    public static HyperlinkTextLabel createLink(String string, String string2, Runnable runnable) {
        return FileSetLinkUtils.createLink(string, string2, DEFAULT_LINK_COLOR, runnable);
    }

    public static HyperlinkTextLabel createLink(String string, String string2, final Color color, final Runnable runnable) {
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel("<a href=\"\">" + string + "</a>", new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                runnable.run();
            }
        }, false, string2 + ".innerComponent", string){

            public Color getHyperlinkColor() {
                return color;
            }
        };
        if (!PlatformInfo.isMacintosh()) {
            hyperlinkTextLabel.setFont(FontUtils.getSystemUIFont());
        } else {
            hyperlinkTextLabel.setFont(FontUtils.getSystemUIFont());
        }
        hyperlinkTextLabel.addRule("body", "color", "black");
        hyperlinkTextLabel.addRule("a", "text-decoration", "none");
        hyperlinkTextLabel.addRule("a", "color", "black");
        hyperlinkTextLabel.getComponent().setBackground(FileSetEditor.BACKGROUND);
        hyperlinkTextLabel.getComponent().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        hyperlinkTextLabel.getComponent().setName(string2);
        return hyperlinkTextLabel;
    }
}

