/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plaf;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.project.impl.plaf.SwingUtilities2;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class DeploymentTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Color TAB_GRADIENT_TOP = Color.WHITE;
    private static final Color TAB_GRADIENT_BOTTOM = ColorUtils.convertToCurrentColorScheme((Color)new Color(251, 251, 251), (Color)UIManager.getColor("MenuBar.background"));
    private static final Color UNSELECTED_TAB_BACKGROUND = ColorUtils.convertToCurrentColorScheme((Color)new Color(243, 241, 246), (Color)UIManager.getColor("MenuBar.background"));
    private static final Color TAB_BORDER = ColorUtils.convertToCurrentColorScheme((Color)new Color(128, 128, 128), (Color)UIManager.getColor("control"));
    private static final Color UNSELECTED_TAB_BORDER = ColorUtils.convertToCurrentColorScheme((Color)new Color(158, 156, 159), (Color)UIManager.getColor("control"));
    private static final Color TAB_TEXT_COLOR = UIManager.getColor("Label.foreground");
    private static final Color UNSELECTED_TAB_TEXT_COLOR = ColorUtils.convertToCurrentColorScheme((Color)Color.BLACK, (Color)UIManager.getColor("control"));
    private static final Insets TAB_INSETS = new Insets(4, 0, 4, 0);
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (bl) {
            graphics2D.setPaint(new GradientPaint(new Point2D.Double((float)n5 / 2.0f, n4 + 1), TAB_GRADIENT_TOP, new Point2D.Double((float)n5 / 2.0f, n4 + n6 - 1), TAB_GRADIENT_BOTTOM));
        } else {
            graphics2D.setColor(UNSELECTED_TAB_BACKGROUND);
        }
        assert (n == 1);
        graphics2D.fill(new Rectangle2D.Double(n3 + (n2 == 0 ? 0 : 1), n4 + 1, n5 - (n2 == 0 ? 2 : 3), n6 - 1));
        this.paintContentBorder(graphics2D, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
        graphics2D.dispose();
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        assert (n == 1);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (bl) {
            graphics2D.setColor(TAB_BORDER);
        } else {
            graphics2D.setColor(UNSELECTED_TAB_BORDER);
        }
        if (n2 > 0) {
            graphics2D.drawLine(n3, n4, n3, n4 + n6 - 1);
        }
        graphics2D.drawLine(n3, n4, n3 + n5 - 1, n4);
        graphics2D.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
        graphics2D.dispose();
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicTabbedPaneUI.TabbedPaneLayout(){

            @Override
            protected void padSelectedTab(int n, int n2) {
            }
        };
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        assert (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(font);
        View view = this.getTextViewForTab(n2);
        assert (view == null);
        int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
        Color color = bl ? TAB_TEXT_COLOR : UNSELECTED_TAB_TEXT_COLOR;
        graphics2D.setColor(color);
        SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, graphics2D, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
        graphics2D.dispose();
    }

    @Override
    protected Insets getTabInsets(int n, int n2) {
        return TAB_INSETS;
    }

    @Override
    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        View view = this.getTextViewForTab(n2);
        assert (view == null);
        int n3 = 0;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            String string = this.tabPane.getTitleAt(i);
            n3 = Math.max(n3, fontMetrics.stringWidth(string));
        }
        return n3 + 26;
    }

    @Override
    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            Icon icon2 = icon;
            if (!bl) {
                icon2 = DeploymentTabbedPaneUI.dim(icon);
            }
            Rectangle rectangle2 = new Rectangle();
            int n3 = this.calculateTabWidth(n, n2, this.getFontMetrics()) * n2 + 10;
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                Rectangle rectangle3 = new Rectangle();
                this.getTabBounds(i, rectangle3);
                if (i > 0 && rectangle3.y != rectangle2.y) {
                    n3 = 10;
                    break;
                }
                rectangle2 = rectangle3;
            }
            icon2.paintIcon(this.tabPane, graphics, n3, rectangle.y);
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.textIconGap = 0;
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        if (this.rects.length == 0) {
            return;
        }
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(TAB_BORDER);
        int n3 = this.rects[0].height - 1;
        if (rectangle != null) {
            if (n2 > 0) {
                graphics2D.drawLine(0, n3, rectangle.x, n3);
            }
            graphics2D.drawLine(rectangle.x + rectangle.width - 1, n3, this.tabPane.getWidth(), n3);
        } else {
            graphics2D.drawLine(0, n3, this.tabPane.getWidth(), n3);
        }
        graphics2D.dispose();
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        return ZERO_INSETS;
    }

    @Override
    protected Insets getTabAreaInsets(int n) {
        return ZERO_INSETS;
    }

    private static Icon dim(Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n = bufferedImage.getData().getPixel(i, j, (int[])null)[0];
                Color color = new Color(bufferedImage.getRGB(i, j));
                if (n <= 0) continue;
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                fArray[1] = (float)(0.5 * (double)fArray[1]);
                bufferedImage.setRGB(i, j, Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
            }
        }
        return new ImageIcon(bufferedImage);
    }
}

