/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class LAFUtil {
    private static final Color ARMED_BORDER = new Color(0, 0, 0);
    private static final Color PRESSED_BACKGROUND = new Color(0, 0, 0, 25);
    private static final Color PRESSED_BORDER = new Color(0x606060);
    private static int ARMED_ALPHA = 200;

    private LAFUtil() {
    }

    public static Rectangle getWorkArea(JComponent jComponent) {
        return LAFUtil.getWorkArea(jComponent, jComponent.getWidth(), jComponent.getHeight());
    }

    public static Rectangle getWorkArea(JComponent jComponent, int n, int n2) {
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = n - (insets.right + insets.left);
        rectangle.height = n2 - (insets.bottom + insets.top);
        return rectangle;
    }

    public static void drawRoundButtonPressedRect(Graphics2D graphics2D, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 8.0f, 8.0f);
        RoundRectangle2D.Float float_2 = new RoundRectangle2D.Float(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4, 8.0f, 8.0f);
        LAFUtil.drawButtonPressedRect(graphics2D, shape, float_, float_2);
    }

    public static void drawButtonPressedRect(Graphics2D graphics2D, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        LAFUtil.drawButtonPressedRect(graphics2D, shape, float_, float_2);
    }

    public static void drawButtonPressedRect(Graphics2D graphics2D, Shape shape, Shape shape2, Shape shape3) {
        graphics2D.setColor(PRESSED_BACKGROUND);
        graphics2D.fill(shape);
        Color color = PRESSED_BORDER;
        Rectangle rectangle = shape2.getBounds();
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.y + rectangle.height, LAFUtil.composeWithAlpha(color, 64)));
        graphics2D.draw(shape2);
        Rectangle rectangle2 = shape3.getBounds();
        graphics2D.setPaint(new GradientPaint(rectangle2.x, rectangle2.y, LAFUtil.composeWithAlpha(color, 160), rectangle2.x, rectangle2.y + rectangle2.height, LAFUtil.composeWithAlpha(color, 32)));
        graphics2D.draw(shape3);
        int n = rectangle2.x + 1;
        int n2 = rectangle2.y + 1;
        int n3 = rectangle2.x + rectangle2.width - 1;
        graphics2D.setPaint(LAFUtil.composeWithAlpha(color, 112));
        graphics2D.drawLine(n, n2, n3, n2);
    }

    public static RectangularShape getButtonRect(Rectangle rectangle) {
        return LAFUtil.getButtonRect(rectangle, rectangle.width, rectangle.height);
    }

    public static RectangularShape drawButtonArmedRect(Graphics2D graphics2D, Rectangle rectangle) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        RectangularShape rectangularShape = LAFUtil.getButtonRect(rectangle, n, n2);
        double d = rectangularShape.getHeight();
        Rectangle2D rectangle2D = rectangularShape.getFrame();
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = (int)d;
        Color color = LAFUtil.composeWithAlpha(Color.white, ARMED_ALPHA);
        graphics2D.setPaint(new GradientPaint(n3, n4, color, (float)bl, n5, color));
        rectangle2D.setFrame(n3 + 2, n4 + 2, (double)n3 + rectangularShape.getWidth() - 2.0, n5);
        graphics2D.fill(rectangle2D);
        graphics2D.setColor(LAFUtil.composeWithAlpha(ARMED_BORDER, 32));
        graphics2D.draw(rectangularShape);
        return rectangularShape;
    }

    public static RectangularShape getButtonRect(Rectangle rectangle, int n, int n2) {
        return new RoundRectangle2D.Float(rectangle.x, rectangle.y, n - 1, n2 - 1, 8.0f, 8.0f);
    }

    public static Color composeWithAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }
}

