/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.plugin.PluginDiagnosticMessage;
import com.mathworks.project.impl.plugin.PluginReaderStack;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public final class PluginProblemTracker {
    private final Map<String, Set<String>> fKeysByElementName = new TreeMap<String, Set<String>>();
    private final List<PluginDiagnosticMessage> fMessages = new Vector<PluginDiagnosticMessage>();

    public void checkKey(PluginReaderStack pluginReaderStack, XmlReader xmlReader) {
        String string = xmlReader.readAttribute("key");
        if (string == null) {
            this.fMessages.add(new PluginDiagnosticMessage(pluginReaderStack, "Missing key on " + xmlReader.getCurrentElementName() + " element"));
        } else {
            String string2 = xmlReader.getCurrentElementName();
            Set<String> set = this.fKeysByElementName.get(string2);
            if (set == null) {
                set = new TreeSet<String>();
                this.fKeysByElementName.put(string2, set);
            }
            if (set.contains(string)) {
                this.fMessages.add(new PluginDiagnosticMessage(pluginReaderStack, "Duplicate " + string2 + " key: " + string));
            }
            set.add(string);
            if (pluginReaderStack.getResource(string) == null) {
                this.fMessages.add(new PluginDiagnosticMessage(pluginReaderStack, "Missing resource string: '" + string + "' for " + xmlReader.getCurrentElementName()));
            }
        }
    }

    public void checkRequiredAttribute(PluginReaderStack pluginReaderStack, XmlReader xmlReader, String string) {
        String string2 = xmlReader.readAttribute(string);
        if (string2 == null || string2.trim().length() == 0) {
            this.fMessages.add(new PluginDiagnosticMessage(pluginReaderStack, "Missing required attribute '" + string + "' on " + xmlReader.getCurrentElementName() + (xmlReader.readAttribute("key") != null ? " with key '" + xmlReader.readAttribute("key") + "'" : "")));
        }
    }

    public void checkRequiredSection(PluginReaderStack pluginReaderStack, XmlReader xmlReader, String string, XmlReader xmlReader2) {
        if (!xmlReader2.isPresent()) {
            String string2 = xmlReader.readAttribute("key");
            this.fMessages.add(new PluginDiagnosticMessage(pluginReaderStack, "Missing '" + string + "' section for " + xmlReader.getCurrentElementName() + (string2 == null ? "" : " with key '" + string2 + "'")));
        }
    }

    public void checkType(PluginReaderStack pluginReaderStack, XmlReader xmlReader) {
        String string = xmlReader.readAttribute("type");
        String string2 = xmlReader.readAttribute("key");
        if (string == null) {
            this.fMessages.add(new PluginDiagnosticMessage(pluginReaderStack, "Missing type for param" + (string2 != null ? " with key '" + string2 + "'" : "")));
        } else {
            try {
                if (ParamType.valueOf(string.toUpperCase(Locale.ENGLISH).replace('-', '_')) != null) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fMessages.add(new PluginDiagnosticMessage(pluginReaderStack, "Invalid type '" + string + "' for param" + (string2 != null ? " with key '" + string2 + "'" : "")));
        }
    }

    public void checkBuildSection(PluginReaderStack pluginReaderStack, String string, XmlReader xmlReader) {
        if (!xmlReader.getChild(new String[0]).isPresent()) {
            this.fMessages.add(new PluginDiagnosticMessage(pluginReaderStack, "Empty build section for target" + (string == null ? "" : " with key '" + string + "'")));
        }
    }

    public void flushKeyNamespace(String string) {
        this.fKeysByElementName.remove(string);
    }

    public void addMessage(PluginDiagnosticMessage pluginDiagnosticMessage) {
        this.fMessages.add(pluginDiagnosticMessage);
    }

    public Collection<PluginDiagnosticMessage> getMessages() {
        TreeSet<PluginDiagnosticMessage> treeSet = new TreeSet<PluginDiagnosticMessage>(new Comparator<PluginDiagnosticMessage>(){

            @Override
            public int compare(PluginDiagnosticMessage pluginDiagnosticMessage, PluginDiagnosticMessage pluginDiagnosticMessage2) {
                return pluginDiagnosticMessage.getText().compareTo(pluginDiagnosticMessage2.getText());
            }
        });
        treeSet.addAll(this.fMessages);
        return treeSet;
    }
}

