/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.plaf.LookAndFeel;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.project.impl.settingsui.IconUtils;
import com.mathworks.project.impl.settingsui.ResourceManager;
import com.sun.awt.AWTUtilities;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class IconPicker
extends AbstractParamWidget<List<File>> {
    private PickerIconButton fComponent = new PickerIconButton();
    private MJFrame fFrame;
    private ActionListener fActionListener;
    private ResourceManager fResourceManager;
    private List<File> fSelectedFiles;
    public static final String EXTENSION_48 = "_48.png";
    public static final String EXTENSION_32 = "_32.png";
    public static final String EXTENSION_24 = "_24.png";
    public static final String EXTENSION_16 = "_16.png";
    public static final String FILE_PREFIX = "icon";

    public IconPicker(Param param, Project project) {
        this.fComponent.setName((param == null ? "picker" : param.getKey()) + ".button");
        this.fComponent.setToolTipText(BuiltInResources.getString("details.icon"));
        this.fActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IconPicker.this.fFrame == null) {
                    IconPicker.this.createFrame();
                }
                try {
                    IconPicker.this.fFrame.setLocation(((IconPicker)IconPicker.this).fComponent.getLocationOnScreen().x - 35, ((IconPicker)IconPicker.this).fComponent.getLocationOnScreen().y - 30);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    IconPicker.this.fFrame.setLocation(((IconPicker)IconPicker.this).fComponent.getLocation().x, ((IconPicker)IconPicker.this).fComponent.getLocation().y);
                }
                IconPicker.this.openAction();
                IconPicker.this.fFrame.show();
            }
        };
        this.fComponent.addActionListener(this.fActionListener);
        DetailedToolTip.install((Component)((Object)this.fComponent), project.getConfiguration(), param);
        this.fResourceManager = project.getConfiguration().getResourceManager();
        assert (this.fResourceManager != null);
        this.fResourceManager.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                IconPicker.this.updateFileNames();
            }
        });
        this.fSelectedFiles = this.updateFileNames(this.fResourceManager.getResourceDirectory());
    }

    protected void createFrame() {
        this.fFrame = new MJFrame();
        this.fFrame.setName("icon.picker.frame");
        this.fFrame.setUndecorated(true);
        if (IconPicker.isTranslucencyCapable()) {
            AWTUtilities.setWindowOpaque((Window)this.fFrame, (boolean)false);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.fFrame.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.fFrame.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IconPicker.this.closeFrameWithoutSave();
            }
        });
        this.setPanelLayout(this.fFrame);
    }

    protected abstract void setPanelLayout(MJFrame var1);

    protected abstract void openAction();

    public abstract File getParamIcon();

    protected abstract List<File> updateFileNames(File var1);

    @Override
    public void dispose() {
        this.fComponent.removeActionListener(this.fActionListener);
        DetailedToolTip.uninstall((Component)((Object)this.fComponent));
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void setEnabled(boolean bl) {
    }

    public void closeFrameWithoutSave() {
        this.fFrame.hide();
    }

    protected void repaintIcon(ImageIcon imageIcon) {
        this.fComponent.setIcon(imageIcon);
        this.fComponent.repaint();
        this.updateFileNames();
    }

    public void repaintIcon(BufferedImage bufferedImage) {
        this.repaintIcon(new ImageIcon(bufferedImage));
    }

    public MJFrame getPopupFrame() {
        return this.fFrame;
    }

    private void updateFileNames() {
        this.setData(this.updateFileNames(this.fResourceManager.getResourceDirectory()));
    }

    public ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    public static boolean isTranslucencyCapable() {
        return AWTUtilities.isTranslucencyCapable((GraphicsConfiguration)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    }

    public File getFileWithExtension(String string) {
        if (this.fSelectedFiles != null && !this.fSelectedFiles.isEmpty()) {
            for (File file : this.fSelectedFiles) {
                if (!file.getName().endsWith(string)) continue;
                return file;
            }
        }
        return null;
    }

    public ImageIcon getIcon(String string) throws IOException {
        return new ImageIcon(IconUtils.getIconFromResources(string));
    }

    public void setData(List<File> list) {
        this.fSelectedFiles = list;
        this.fireListeners();
    }

    public List<File> getData() {
        if (this.fResourceManager.getResourceDirectory().exists()) {
            return this.fSelectedFiles;
        }
        return new ArrayList<File>();
    }

    static {
        LookAndFeel.install();
    }

    private class PickerIconButton
    extends MJButton {
        private PickerIconButton() {
        }

        public String getUIClassID() {
            return "Project.PickerButtonUI";
        }
    }
}

