/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.table;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.settingsui.ListTextField;
import com.mathworks.project.impl.settingsui.ListTextFieldStyle;
import com.mathworks.project.impl.settingsui.table.AbstractSettingsCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.TextFieldUtils;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ListCellEditor
extends AbstractSettingsCellEditor {
    private final ListTextField fTextField;
    private final PropertyTable<Param> fTable;
    private final Param fParam;

    public ListCellEditor(PropertyTable<Param> propertyTable, Configuration configuration, Param param) {
        super(configuration, param);
        this.fTable = propertyTable;
        this.fParam = param;
        this.fTextField = ListCellEditor.createListTextField(param);
        if (param.getValidationRule() != null) {
            this.fTextField.installBasicTextValidator(param.getValidationRule());
        }
        this.fTextField.setFont(propertyTable.getFont());
        this.fTextField.addPopupStateListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ListCellEditor.this.fTable.setOverrideStopEditingOnFocusLost(ListCellEditor.this.fTextField.isPopupShowing());
            }
        });
        TextFieldUtils.installCommitAndCancelKeystrokes(propertyTable, this.fTextField.getTextField());
    }

    private static ListTextField createListTextField(Param param) {
        switch (param.getType()) {
            case DIR_LIST: {
                return new ListTextField(param.getKey(), ListTextFieldStyle.DIRECTORIES, true, param.getFileFilters());
            }
            case FILE_LIST: {
                return new ListTextField(param.getKey(), ListTextFieldStyle.FILES, true, param.getFileFilters());
            }
            case STRING_LIST: {
                return new ListTextField(param.getKey(), ListTextFieldStyle.STRINGS, true);
            }
        }
        throw new IllegalArgumentException("This cell editor cannot support " + param.getKey() + " because it does not work with " + (Object)((Object)param.getType()));
    }

    @Override
    public void setData(Object object, String string) {
        if (this.fParam.getType() == ParamType.STRING_LIST) {
            this.fTextField.setStringList((List)object);
        } else {
            this.fTextField.setFileList((List)object);
        }
    }

    @Override
    public Object getData() {
        if (this.fParam.getType() == ParamType.STRING_LIST) {
            return this.fTextField.getStringList();
        }
        return this.fTextField.getFileList();
    }

    @Override
    public JComponent getComponent() {
        return (JComponent)this.fTextField.getComponent();
    }

    @Override
    public void dispose() {
        this.fTextField.dispose();
    }

    @Override
    public void activate() {
    }
}

