/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.table;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.settingsui.ParamUtils;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import com.mathworks.project.impl.table.AbstractSimpleCellEditor;
import com.mathworks.project.impl.table.PropertyTable;

public final class SimpleCellEditor
extends AbstractSimpleCellEditor<Param> {
    private final Configuration fConfiguration;
    private final Param fParam;

    public static SimpleCellEditor create(PropertyTable<Param> propertyTable, Configuration configuration, Param param) {
        if (param.getValidationRule() != null) {
            return new SimpleCellEditor(propertyTable, configuration, param, param.getValidationRule());
        }
        if (param.getType() == ParamType.INT) {
            return new SimpleCellEditor(propertyTable, configuration, param, ParamUtils.getIntParamMin(param), ParamUtils.getIntParamMax(param));
        }
        return new SimpleCellEditor(propertyTable, configuration, param);
    }

    private SimpleCellEditor(PropertyTable<Param> propertyTable, Configuration configuration, Param param) {
        super(propertyTable, param.getType() == ParamType.DECIMAL);
        this.fConfiguration = configuration;
        this.fParam = param;
    }

    private SimpleCellEditor(PropertyTable<Param> propertyTable, Configuration configuration, Param param, ValidationRule validationRule) {
        super(propertyTable, validationRule);
        this.fConfiguration = configuration;
        this.fParam = param;
    }

    private SimpleCellEditor(PropertyTable<Param> propertyTable, Configuration configuration, Param param, int n, int n2) {
        super(propertyTable, n, n2);
        this.fConfiguration = configuration;
        this.fParam = param;
    }

    @Override
    public final void loadData(Object object, String string) {
        this.setData(this.fConfiguration.getParamAsObject(this.fParam.getKey()), string);
    }

    @Override
    public final void commitData() {
        Object object = this.getData();
        this.fConfiguration.setParamAsObject(this.fParam.getKey(), object);
    }
}

