/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.settingsui.SettingsPaintingUtils;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTablePaintingUtils;
import com.mathworks.project.impl.table.RowPaintContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class MacPropertyTablePainter<T>
implements PropertyTablePainter<T> {
    private static final Color MAC_GROUP_BORDER_COLOR = new Color(192, 192, 192);
    private static final Color MAC_GROUP_BACKGROUND_TOP_1 = new Color(236, 238, 249);
    private static final Color MAC_GROUP_BACKGROUND_TOP_2 = new Color(225, 229, 242);
    private static final Color MAC_GROUP_BACKGROUND_BOTTOM_1 = new Color(217, 220, 236);
    private static final Color MAC_GROUP_BACKGROUND_BOTTOM_2 = new Color(189, 193, 211);
    private static final Color MAC_GROUP_HEADER_FOREGROUND = new Color(56, 57, 59);
    private static final Color MAC_ROW_BACKGROUND_1 = new Color(237, 243, 254);
    private static final Color MAC_ROW_BACKGROUND_2 = UIManager.getColor("Table.background");
    private static final Color MAC_SELECTED_ROW_BACKGROUND = new Color(56, 117, 215);
    private static final Color MAC_SELECTED_UNFOCUSED_ROW_BACKGROUND = new Color(215, 215, 215);
    private static final Color MAC_SELECTED_FOREGROUND = Color.WHITE;
    private static final Color MAC_SELECTED_UNFOCUSED_FOREGROUND = Color.BLACK;
    private static final Color MAC_REGULAR_EXPANDER_COLOR = new Color(152, 152, 152);
    private static final Color MAC_REGULAR_FINITE_DROPDOWN_COLOR = new Color(81, 81, 81);
    private static final Color MAC_DEFAULT_FOREGROUND = Color.BLACK;
    private static final Color MAC_DISABLED_FOREGROUND = new Color(109, 109, 109);
    private static final double MAC_EXPANDER_HEIGHT = 8.0;
    private static final double MAC_EXPANDER_WIDTH = 10.0;

    @Override
    public int getGridLineHeight() {
        return 0;
    }

    @Override
    public int getGridLineWidth() {
        return 0;
    }

    @Override
    public void paintGridLine(Graphics2D graphics2D, Rectangle2D rectangle2D) {
    }

    @Override
    public Color paintGroupBackground(RowPaintContext<T> rowPaintContext) {
        PropertyTablePaintingUtils.gradientFill(rowPaintContext.getGraphics(), rowPaintContext.getRowRect(), MAC_GROUP_BACKGROUND_TOP_1, MAC_GROUP_BACKGROUND_TOP_2, MAC_GROUP_BACKGROUND_BOTTOM_1, MAC_GROUP_BACKGROUND_BOTTOM_2);
        PropertyTablePaintingUtils.drawBorder(rowPaintContext, MAC_GROUP_BORDER_COLOR, rowPaintContext.getRowIndex() > 0);
        return MAC_GROUP_BACKGROUND_TOP_1;
    }

    @Override
    public Color paintNormalBackground(RowPaintContext<T> rowPaintContext) {
        Color color = rowPaintContext.getMarkedRowIndex() % 2 > 0 ? MAC_ROW_BACKGROUND_1 : MAC_ROW_BACKGROUND_2;
        PropertyTablePaintingUtils.paintBackgroundWithHighlight(rowPaintContext, color);
        return color;
    }

    @Override
    public Color paintSelectedBackground(RowPaintContext<T> rowPaintContext) {
        Color color = MAC_SELECTED_ROW_BACKGROUND;
        if (!rowPaintContext.isFocused()) {
            color = MAC_SELECTED_UNFOCUSED_ROW_BACKGROUND;
        }
        PropertyTablePaintingUtils.paintBackgroundWithHighlight(rowPaintContext, color);
        return color;
    }

    @Override
    public boolean canFitText(CellPaintContext<T> cellPaintContext) {
        int n = cellPaintContext.getColumnIndex() == 0 ? 3 + 16 * Math.max(cellPaintContext.getNestLevel(), 1) : 3;
        int n2 = 0;
        if (cellPaintContext.getLink() != null && cellPaintContext.getLink().isVisible()) {
            n2 = (int)(cellPaintContext.getLink().getPreferredSize().getWidth() + 14.0);
        }
        String string = SettingsPaintingUtils.trim(cellPaintContext.getGraphics(), cellPaintContext.getText(), (int)(cellPaintContext.getCellRect().getWidth() - (double)n - (double)(cellPaintContext.isFiniteValue() ? 9 : 0) - (double)n2));
        return string.equals(cellPaintContext.getText());
    }

    @Override
    public Color paintText(CellPaintContext<T> cellPaintContext) {
        Color color = MAC_DEFAULT_FOREGROUND;
        if (cellPaintContext.isDisabled()) {
            color = MAC_DISABLED_FOREGROUND;
        } else if (!cellPaintContext.isLeaf() && !cellPaintContext.isSelected()) {
            color = MAC_GROUP_HEADER_FOREGROUND;
        } else if (cellPaintContext.isSelected()) {
            color = cellPaintContext.isFocused() ? MAC_SELECTED_FOREGROUND : MAC_SELECTED_UNFOCUSED_FOREGROUND;
        }
        Graphics2D graphics2D = cellPaintContext.getGraphics();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D rectangle2D = cellPaintContext.getCellRect();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = cellPaintContext.getLineHeight() - (fontMetrics.getAscent() + fontMetrics.getDescent());
        int n2 = cellPaintContext.getColumnIndex() == 0 ? 3 + 16 * Math.max(cellPaintContext.getNestLevel(), 1) : 3;
        Font font = graphics2D.getFont();
        font = !cellPaintContext.isLeaf() || cellPaintContext.isNonDefault() ? font.deriveFont(1) : font.deriveFont(0);
        graphics2D.setFont(font);
        int n3 = 0;
        if (cellPaintContext.getLink() != null && cellPaintContext.getLink().isVisible()) {
            n3 = (int)(cellPaintContext.getLink().getPreferredSize().getWidth() + 14.0);
        }
        String string = cellPaintContext.getText().isEmpty() ? " " : cellPaintContext.getText();
        String string2 = PropertyTablePaintingUtils.trim(graphics2D, string, (int)(rectangle2D.getWidth() - (double)n2 - (double)(cellPaintContext.isFiniteValue() ? 9 : 0) - (double)n3));
        AttributedString attributedString = new AttributedString(string2);
        attributedString.addAttribute(TextAttribute.FONT, font);
        color = PropertyTablePaintingUtils.adjustForegroundColorForHighlight(cellPaintContext, color);
        if (cellPaintContext.getDataChangePhase() < 1.0) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(cellPaintContext.getDataChangePhase() * 255.0));
        }
        attributedString = PropertyTablePaintingUtils.adjustTextForHighlight(cellPaintContext, attributedString, font);
        if (cellPaintContext.matchesSearch()) {
            attributedString = PropertyTablePaintingUtils.markSearchMatch(cellPaintContext, attributedString, string2);
        }
        graphics2D.setColor(color);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        int n4 = (int)cellPaintContext.getCellRect().getX() + n2;
        if (cellPaintContext.getColumn().isNumericallyAligned()) {
            int n5 = string.indexOf(".");
            if (n5 < 0) {
                n5 = string.length();
            }
            int n6 = cellPaintContext.getColumn().getRightMargin(n5 < string.length(), cellPaintContext.getColumn().hasHiddenDigits(cellPaintContext.getValue(), string, graphics2D, cellPaintContext.getCellRect()), graphics2D);
            n4 = (int)(cellPaintContext.getCellRect().getX() + cellPaintContext.getCellRect().getWidth() - (double)n6 - textLayout.getBounds().getWidth());
            n4 = (int)Math.max(cellPaintContext.getCellRect().getX() + (double)n2, (double)n4);
        }
        textLayout.draw(graphics2D, n4, (int)(rectangle2D.getY() + (double)fontMetrics.getAscent() + (double)n / 2.0));
        if (cellPaintContext.isFiniteValue()) {
            Color color2 = MAC_REGULAR_FINITE_DROPDOWN_COLOR;
            if (cellPaintContext.isDisabled()) {
                color2 = MAC_DISABLED_FOREGROUND;
            } else if (cellPaintContext.isSelected() && cellPaintContext.isFocused()) {
                color2 = MAC_SELECTED_FOREGROUND;
            }
            graphics2D.setColor(color2);
            double d = rectangle2D.getX() + (double)n2 + textLayout.getBounds().getWidth() + 4.0;
            double d2 = d + 5.0;
            double d3 = (d + d2) / 2.0;
            double d4 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 6.0;
            double d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 + 1.0;
            double d6 = d4 + 4.0;
            double d7 = d5 + 4.0;
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Line2D.Double(d, d6, d3, d4), true);
            generalPath.append(new Line2D.Double(d3, d4, d2, d6), true);
            generalPath.append(new Line2D.Double(d2, d6, d, d6), true);
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.append(new Line2D.Double(d, d5, d2, d5), true);
            generalPath2.append(new Line2D.Double(d2, d5, d3, d7), true);
            generalPath2.append(new Line2D.Double(d3, d7, d, d5), true);
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(generalPath);
            graphics2D.fill(generalPath2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
        }
        if (cellPaintContext.getLink() != null && cellPaintContext.getLink().isVisible()) {
            JComponent jComponent = cellPaintContext.getLink();
            Dimension dimension = jComponent.getPreferredSize();
            jComponent.setFont(graphics2D.getFont());
            jComponent.setBounds((int)(rectangle2D.getX() + (double)n2 + textLayout.getBounds().getWidth() + 14.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - dimension.getHeight() / 2.0), (int)dimension.getWidth(), (int)dimension.getHeight());
            graphics2D.translate(cellPaintContext.getLink().getX(), cellPaintContext.getLink().getY());
            cellPaintContext.getLink().paint(graphics2D);
            graphics2D.translate(-cellPaintContext.getLink().getX(), -cellPaintContext.getLink().getY());
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        return color;
    }

    @Override
    public int getCollapsedPhaseIndex() {
        return 6;
    }

    @Override
    public Rectangle2D getExpanderRect(RowPaintContext<T> rowPaintContext) {
        Rectangle2D rectangle2D = rowPaintContext.getRowRect();
        double d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 4.0;
        double d2 = rectangle2D.getX() + Math.max(8.0, (double)(3 + Math.max(0, rowPaintContext.getNestLevel() - 1) * 16));
        double d3 = d2 + 10.0;
        double d4 = d + 8.0;
        return new Rectangle2D.Double(d2, d, d3 - d2 + 1.0, d4 - d + 1.0);
    }

    @Override
    public void paintExpander(RowPaintContext<T> rowPaintContext) {
        Graphics2D graphics2D = rowPaintContext.getGraphics();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        Rectangle2D rectangle2D = this.getExpanderRect(rowPaintContext);
        boolean bl = false;
        boolean bl2 = false;
        int n = (int)(rectangle2D.getWidth() - 1.0);
        int n2 = (int)(rectangle2D.getHeight() - 1.0);
        int n3 = (int)(rectangle2D.getWidth() / 2.0);
        generalPath.append(new Line2D.Double((double)bl2, (double)bl, n3, n2), true);
        generalPath.append(new Line2D.Double(n3, n2, n, (double)bl), true);
        generalPath.append(new Line2D.Double(n, (double)bl, (double)bl2, (double)bl), true);
        Color color = MAC_REGULAR_EXPANDER_COLOR;
        if (rowPaintContext.isSelected() && rowPaintContext.isFocused()) {
            color = MAC_SELECTED_FOREGROUND;
            if (rowPaintContext.isPressed()) {
                color = MAC_DISABLED_FOREGROUND;
            }
        } else if (rowPaintContext.isPressed()) {
            color = Color.BLACK;
        }
        Icon icon = PropertyTablePaintingUtils.rotate(generalPath, color, -1.5707963267948966 * ((double)rowPaintContext.getExpansionPhase() / (double)this.getCollapsedPhaseIndex()), true, false);
        icon.paintIcon(null, graphics2D, (int)rectangle2D.getX(), (int)rectangle2D.getY());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

