/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.textfield;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseUtils;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.textfield.AutoCompleter;
import com.mathworks.project.impl.textfield.CharacterFilter;
import com.mathworks.project.impl.textfield.DefaultFormattedTextFieldPainter;
import com.mathworks.project.impl.textfield.FormatTip;
import com.mathworks.project.impl.textfield.FormatTipContent;
import com.mathworks.project.impl.textfield.FormatTipProvider;
import com.mathworks.project.impl.textfield.FormatTokenizer;
import com.mathworks.project.impl.textfield.FormattedCaret;
import com.mathworks.project.impl.textfield.FormattedTextFieldPainter;
import com.mathworks.project.impl.textfield.Token;
import com.mathworks.services.FontPrefs;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FormattedTextField {
    private final StringBuilder fText;
    private final MJPanel fComponent;
    private final Scroller fWrapper;
    private final FormattedTextFieldPainter fPainter;
    private final FormattedCaret fCaret;
    private final FormatTip fFormatTip;
    private final boolean fInitialized;
    private final Graphics2D fDryRunGraphics;
    private final ClipboardManager fClipboardManager;
    private final List<JScrollBar> fScrollBars;
    private final MulticastChangeListener fChangeListeners;
    private boolean fEditable = true;
    private String fPrompt;
    private List<Token> fTokens;
    private List<Token> fCompletionTokens;
    private Map<Token, Rectangle> fTokenRects;
    private int fInsertionPoint;
    private int fSelectionStart;
    private int fSelectionEnd;
    private Integer fDragSelectionStart;
    private Token fHoveredToken;
    private Timer fUnhoverTimer;
    private AutoCompleter fCompleter;
    private FormatTokenizer fTokenizer;
    private CharacterFilter fFilter;
    private FormatTipProvider fTipProvider;
    private Window fWindow;
    private ComponentListener fComponentListener;
    private AdjustmentListener fAdjustmentListener;
    private int fFormatTipLockCount;
    public static final String TEXT_FIELD_PROPERTY = "FormattedTextField";

    public FormattedTextField() {
        this(new DefaultFormattedTextFieldPainter());
    }

    public FormattedTextField(FormattedTextFieldPainter formattedTextFieldPainter) {
        this.fPainter = formattedTextFieldPainter;
        this.fText = new StringBuilder();
        this.fFormatTip = new FormatTip();
        this.fCaret = new FormattedCaret();
        this.fChangeListeners = new MulticastChangeListener();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fDryRunGraphics = bufferedImage.createGraphics();
        this.fClipboardManager = new ClipboardManager();
        this.fScrollBars = new LinkedList<JScrollBar>();
        this.fCaret.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FormattedTextField.this.fComponent.repaint();
            }
        });
        this.fComponent = new TextComponent();
        this.fComponent.setCursor(Cursor.getPredefinedCursor(2));
        this.fComponent.setFocusable(true);
        this.fWrapper = new Scroller((Component)this.fComponent);
        this.fWrapper.setBorder(null);
        this.fWrapper.putClientProperty(TEXT_FIELD_PROPERTY, this);
        this.fComponent.putClientProperty((Object)TEXT_FIELD_PROPERTY, (Object)this);
        this.setCompleter(new AutoCompleter(){

            @Override
            public void getSuggestedCompletion(List<Token> list, ParameterRunnable<List<Token>> parameterRunnable) {
            }
        });
        this.setFilter(new CharacterFilter(){

            @Override
            public boolean accept(FormattedTextField formattedTextField, char c) {
                return true;
            }
        });
        this.setTokenizer(new FormatTokenizer(){

            @Override
            public List<Token> tokenize(String string) {
                return new ArrayList<Token>();
            }
        });
        this.setTipProvider(new FormatTipProvider(){

            @Override
            public FormatTipContent getTipComponent(FormattedTextField formattedTextField) {
                return null;
            }
        });
        this.acceptTypedCharacters();
        this.updatePopupWhenMoved();
        this.handleNavigationByClick();
        this.handleSelectionByDrag();
        this.handleContextMenu();
        this.fAdjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                FormattedTextField.this.fFormatTip.update(FormattedTextField.this);
            }
        };
        this.fInitialized = true;
        this.update();
    }

    public void setFont(Font font) {
        this.fComponent.setFont(font);
    }

    public void setName(String string) {
        this.fComponent.setName(string);
        this.fFormatTip.setName(string + ".popup");
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public FormattedCaret getCaret() {
        return this.fCaret;
    }

    public void setTokenizer(FormatTokenizer formatTokenizer) {
        this.fTokenizer = formatTokenizer;
        this.update();
    }

    public void setCompleter(AutoCompleter autoCompleter) {
        this.fCompleter = autoCompleter;
        this.update();
    }

    public void setFilter(CharacterFilter characterFilter) {
        this.fFilter = characterFilter;
        this.update();
    }

    public void setTipProvider(FormatTipProvider formatTipProvider) {
        this.fTipProvider = formatTipProvider;
    }

    public FormatTipProvider getTipProvider() {
        return this.fTipProvider;
    }

    public Rectangle getTokenRect(Token token) {
        return this.fTokenRects.get(token);
    }

    public int getSelectionStart() {
        return this.fSelectionStart;
    }

    public int getSelectionEnd() {
        return this.fSelectionEnd;
    }

    public Rectangle getSelectionRect() {
        int n;
        if (this.fSelectionStart == this.fSelectionEnd || this.fTokenRects == null) {
            return new Rectangle();
        }
        int n2 = Math.min(this.fSelectionStart, this.fSelectionEnd);
        int n3 = Math.max(this.fSelectionStart, this.fSelectionEnd);
        Token token = this.getTokenForCharIndex(n2);
        Token token2 = this.getTokenForCharIndex(n3);
        Rectangle rectangle = this.getTokenRect(token);
        if (rectangle == null) {
            return new Rectangle();
        }
        int n4 = this.findX(rectangle.x, token.getText(), this.getTokenOffsetAtCharIndex(n2));
        if (token2 != null) {
            Rectangle rectangle2 = this.getTokenRect(token2);
            n = this.findX(rectangle2.x, token2.getText(), this.getTokenOffsetAtCharIndex(n3));
        } else {
            Rectangle rectangle3 = this.getTokenRect(this.fTokens.get(this.fTokens.size() - 1));
            n = rectangle3.x + rectangle3.width;
        }
        return new Rectangle(n4, 1, n - n4 + 1, this.fComponent.getHeight() - 2);
    }

    public JComponent getComponent() {
        return this.fWrapper;
    }

    public JComponent getTextComponent() {
        return this.fComponent;
    }

    public List<Token> getTokens() {
        return new ArrayList<Token>(this.fTokens);
    }

    public int getTokenCount() {
        return this.fTokens.size();
    }

    public List<Token> getTokensWithCompletion() {
        if (this.fCompletionTokens == null || this.fCompletionTokens.isEmpty()) {
            return this.getTokens();
        }
        ArrayList<Token> arrayList = new ArrayList<Token>(this.fTokens.size() + this.fCompletionTokens.size());
        arrayList.addAll(this.fTokens);
        arrayList.addAll(this.fCompletionTokens);
        return arrayList;
    }

    public void dispose() {
        this.fCaret.dispose();
        if (this.fWindow != null) {
            this.fWindow.removeComponentListener(this.fComponentListener);
        }
        for (JScrollBar jScrollBar : this.fScrollBars) {
            jScrollBar.removeAdjustmentListener(this.fAdjustmentListener);
        }
        this.fScrollBars.clear();
        this.fDryRunGraphics.dispose();
        this.fFormatTip.close();
    }

    public void setEditable(boolean bl) {
        this.fEditable = bl;
        if (!this.fEditable) {
            this.closeFormatTip();
        } else {
            this.update();
        }
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void setPrompt(String string) {
        this.fPrompt = string;
    }

    public String getPrompt() {
        return this.fPrompt;
    }

    public void setText(String string) {
        this.fText.setLength(0);
        this.fText.append(string);
        this.fSelectionStart = 0;
        this.fSelectionEnd = 0;
        this.fInsertionPoint = this.fText.length();
        this.update();
        this.scrollToInsertionPoint();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public String getSelectedText() {
        int n = Math.max(0, Math.min(this.fSelectionStart, this.fSelectionEnd));
        int n2 = Math.min(this.fText.length(), Math.max(this.fSelectionStart, this.fSelectionEnd));
        return this.fText.substring(n, n2);
    }

    public String getText() {
        return this.fText.toString();
    }

    public void selectAll() {
        this.select(0, this.fText.length());
    }

    public void setInsertionPoint(int n) {
        this.fInsertionPoint = Math.max(0, Math.min(n, this.fText.length()));
        this.update();
        this.scrollToInsertionPoint();
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    private void scrollToInsertionPoint() {
        List<Token> list;
        Token token = this.getTokenForCharIndex(this.fInsertionPoint);
        int n = this.getTokenOffsetAtCharIndex(this.fInsertionPoint);
        if (token == null) {
            list = this.getTokens();
            if (list.isEmpty()) {
                this.fWrapper.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            } else {
                token = (Token)list.get(list.size() - 1);
            }
        }
        if (token != null) {
            list = this.getTokenRect(token);
            String string = token.getText().substring(0, n);
            this.fDryRunGraphics.setFont(this.fComponent.getFont());
            double d = this.fDryRunGraphics.getFontMetrics().getStringBounds(string, this.fDryRunGraphics).getWidth();
            if (list != null) {
                Rectangle rectangle = new Rectangle((int)(((Rectangle)((Object)list)).getX() + d), 0, 2, 1);
                Rectangle rectangle2 = this.fComponent.getVisibleRect();
                if (rectangle2 != null && !rectangle2.contains(rectangle)) {
                    this.fWrapper.scrollRectToVisible(rectangle);
                } else {
                    this.fWrapper.constrainToSize();
                }
            }
        }
    }

    public void setInsertionPointWithAutoSelect(int n) {
        this.fInsertionPoint = Math.max(0, Math.min(n, this.fText.length()));
        this.fDragSelectionStart = this.fInsertionPoint;
        Token token = this.getFieldTokenForCharIndex(n);
        if (token != null) {
            this.fInsertionPoint = this.fSelectionStart = this.getTextBefore(token).length();
            this.fSelectionEnd = this.fInsertionPoint + token.getText().length();
        } else {
            this.fSelectionStart = this.fInsertionPoint;
            this.fSelectionEnd = this.fInsertionPoint;
        }
        this.update();
        this.scrollToInsertionPoint();
    }

    public void select(int n, int n2) {
        this.fSelectionStart = n;
        this.fSelectionEnd = n2;
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void select(Token token) {
        this.fInsertionPoint = this.fSelectionStart = this.getTextBefore(token).length();
        this.fSelectionEnd = this.fSelectionStart + token.getText().length();
        this.update();
        this.scrollToInsertionPoint();
    }

    private static String assembleTokens(List<Token> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            for (Token token : list) {
                stringBuilder.append(token.getText());
            }
        }
        return stringBuilder.toString();
    }

    public String getCompletionText() {
        return FormattedTextField.assembleTokens(this.fCompletionTokens);
    }

    public String getTextWithCompletion() {
        return this.getText() + this.getCompletionText();
    }

    public int getInsertionPoint() {
        return this.fInsertionPoint;
    }

    public Token getTokenForCharIndex(int n) {
        int n2 = 0;
        for (Token token : this.fTokens) {
            if ((n2 += token.getText().length()) <= n) continue;
            return token;
        }
        return null;
    }

    public int getTokenOffsetAtCharIndex(int n) {
        int n2 = 0;
        for (Token token : this.fTokens) {
            if (n2 + token.getText().length() > n) {
                return n - n2;
            }
            n2 += token.getText().length();
        }
        return this.fTokens.isEmpty() ? 0 : this.fTokens.get(this.fTokens.size() - 1).getText().length();
    }

    public Token getFieldTokenForCharIndex(int n) {
        Token token;
        Token token2 = this.getTokenForCharIndex(n);
        if (token2 != null && this.isField(token2)) {
            return token2;
        }
        if (n > 0 && (token = this.getTokenForCharIndex(n - 1)) != null && this.isField(token)) {
            return token;
        }
        return null;
    }

    public Token getTokenAtX(int n) {
        for (Map.Entry<Token, Rectangle> entry : this.fTokenRects.entrySet()) {
            if (!entry.getValue().contains(n, 2)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getTextBefore(Token token) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token2 : this.fTokens) {
            if (token.equals(token2)) break;
            stringBuilder.append(token2.getText());
        }
        return stringBuilder.toString();
    }

    public boolean isHovered(Token token) {
        return this.fHoveredToken == token;
    }

    public Token getSelectedFieldToken() {
        Token token = this.getTokenForCharIndex(this.fSelectionStart);
        if (token != null && this.isField(token) && this.fSelectionEnd - this.fSelectionStart == token.getText().length()) {
            return token;
        }
        return null;
    }

    public boolean jumpToNextPromptIfAny() {
        for (int i = this.fInsertionPoint + 1; i < this.fText.length(); ++i) {
            Token token = this.getTokenForCharIndex(i);
            if (!this.isField(token) || !this.isPrompt(token)) continue;
            this.select(token);
            return true;
        }
        return false;
    }

    public void requestFocus() {
        this.fComponent.requestFocus();
    }

    private static boolean isSystemControlDown(KeyEvent keyEvent) {
        return (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    private static boolean isGraphicalChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || Character.isWhitespace(c) || "`~!@#$%^&*()_+-=[]{};':\",./<>?\\".indexOf(c) >= 0;
    }

    private void acceptTypedCharacters() {
        this.fComponent.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\b') {
                    FormattedTextField.this.doBackspace();
                } else if (keyEvent.getKeyChar() == '\u007f') {
                    FormattedTextField.this.doDelete();
                } else if (!FormattedTextField.isGraphicalChar(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                } else if (FormattedTextField.this.fFilter.accept(FormattedTextField.this, keyEvent.getKeyChar())) {
                    FormattedTextField.this.type(keyEvent.getKeyChar());
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 37) {
                    FormattedTextField.this.doLeftArrow(keyEvent.isControlDown(), keyEvent.isShiftDown());
                } else if (keyEvent.getKeyCode() == 36) {
                    FormattedTextField.this.doHome(keyEvent.isControlDown(), keyEvent.isShiftDown());
                } else if (keyEvent.getKeyCode() == 35) {
                    FormattedTextField.this.doEnd(keyEvent.isControlDown(), keyEvent.isShiftDown());
                } else if (keyEvent.getKeyCode() == 39) {
                    FormattedTextField.this.doRightArrow(keyEvent.isControlDown(), keyEvent.isShiftDown());
                } else if (keyEvent.getKeyCode() == 10) {
                    FormattedTextField.this.doEnter();
                } else if (keyEvent.getKeyCode() == 27) {
                    FormattedTextField.this.doEscape();
                } else if (keyEvent.getKeyCode() == 67 && FormattedTextField.isSystemControlDown(keyEvent)) {
                    FormattedTextField.this.fClipboardManager.doCopy();
                } else if (keyEvent.getKeyCode() == 88 && FormattedTextField.isSystemControlDown(keyEvent)) {
                    FormattedTextField.this.fClipboardManager.doCut();
                } else if (keyEvent.getKeyCode() == 86 && FormattedTextField.isSystemControlDown(keyEvent)) {
                    FormattedTextField.this.fClipboardManager.doPaste();
                } else if (keyEvent.getKeyCode() == 65 && FormattedTextField.isSystemControlDown(keyEvent)) {
                    FormattedTextField.this.selectAll();
                } else if (keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
                    FormattedTextField.this.showContextMenu(new Point(FormattedTextField.this.findX(0, FormattedTextField.this.fText.toString(), FormattedTextField.this.fInsertionPoint), FormattedTextField.this.fComponent.getHeight()));
                } else if (keyEvent.getKeyCode() == 9) {
                    FormattedTextField.this.doTab(keyEvent.isShiftDown());
                }
            }
        });
    }

    private void handleSelectionByDrag() {
        this.fComponent.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Token token = FormattedTextField.this.getTokenAtX(mouseEvent.getX());
                if (!(token == null || FormattedTextField.this.fHoveredToken != null && FormattedTextField.this.fHoveredToken.equals(token))) {
                    FormattedTextField.this.fHoveredToken = token;
                    FormattedTextField.this.listenForUnhover();
                    FormattedTextField.this.fComponent.revalidate();
                    FormattedTextField.this.fComponent.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = FormattedTextField.this.getInsertionPoint(mouseEvent.getPoint());
                if (n != -1) {
                    if (FormattedTextField.this.fDragSelectionStart != null) {
                        FormattedTextField.this.fSelectionStart = FormattedTextField.this.fDragSelectionStart;
                        FormattedTextField.this.fSelectionEnd = FormattedTextField.this.fDragSelectionStart;
                        FormattedTextField.this.fInsertionPoint = FormattedTextField.this.fSelectionStart;
                        FormattedTextField.this.fDragSelectionStart = null;
                        FormattedTextField.this.update();
                        FormattedTextField.this.scrollToInsertionPoint();
                    }
                    FormattedTextField.this.fSelectionEnd = n;
                    FormattedTextField.this.fComponent.revalidate();
                    FormattedTextField.this.fComponent.repaint();
                }
            }
        });
    }

    private void handleNavigationByClick() {
        this.fComponent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                FormattedTextField.this.fComponent.requestFocus();
                int n = FormattedTextField.this.getInsertionPoint(mouseEvent.getPoint());
                for (int i = FormattedTextField.this.fText.length(); i <= n; ++i) {
                    FormattedTextField.this.fInsertionPoint = FormattedTextField.this.fText.length();
                    FormattedTextField.this.fSelectionStart = FormattedTextField.this.fText.length();
                    FormattedTextField.this.fSelectionEnd = FormattedTextField.this.fText.length();
                    FormattedTextField.this.doRightArrow(false, false);
                }
                if (n != -1) {
                    FormattedTextField.this.setInsertionPointWithAutoSelect(n);
                }
            }
        });
    }

    private void handleContextMenu() {
        this.fComponent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!MouseUtils.isDoubleClickEvent((MouseEvent)mouseEvent) && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    FormattedTextField.this.showContextMenu(mouseEvent.getPoint());
                }
            }
        });
    }

    private int getInsertionPoint(Point point) {
        if (this.fTokenRects == null) {
            return -1;
        }
        if (this.fText.length() == 0) {
            return 0;
        }
        if (point.getX() < 0.0) {
            return 0;
        }
        Token token = this.getTokenAtX((int)point.getX());
        if (token == null) {
            String string = this.getCompletionText();
            Rectangle rectangle = this.fTokenRects.get(this.fTokens.get(this.fTokens.size() - 1));
            int n = rectangle.x + rectangle.width;
            return this.findX(n, (int)point.getX(), this.fText.length(), string);
        }
        Rectangle rectangle = this.fTokenRects.get(token);
        return this.findX(rectangle.x, (int)point.getX(), this.getTextBefore(token).length(), token.getText());
    }

    private int findX(int n, int n2, int n3, String string) {
        FontMetrics fontMetrics = this.fComponent.getFontMetrics(this.fComponent.getFont());
        int[] nArray = fontMetrics.getWidths();
        int n4 = n;
        for (int i = 0; i < string.length(); ++i) {
            if ((n4 += nArray[string.charAt(i)]) <= n2) continue;
            return n3 + i;
        }
        return n3 + string.length();
    }

    private int findX(int n, String string, int n2) {
        FontMetrics fontMetrics = this.fComponent.getFontMetrics(this.fComponent.getFont());
        int[] nArray = fontMetrics.getWidths();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            n3 += nArray[string.charAt(i)];
        }
        return n3;
    }

    private void updatePopupWhenMoved() {
        this.fComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (FormattedTextField.this.fFormatTipLockCount == 0) {
                    FormattedTextField.this.fFormatTip.update(FormattedTextField.this);
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (FormattedTextField.this.fFormatTipLockCount == 0) {
                    FormattedTextField.this.fFormatTip.update(FormattedTextField.this);
                }
            }
        };
        this.fComponent.addComponentListener(this.fComponentListener);
    }

    private void listenForUnhover() {
        if (this.fUnhoverTimer == null) {
            this.fUnhoverTimer = new Timer(25, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Point point;
                    PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                    if (pointerInfo != null && (point = pointerInfo.getLocation()) != null) {
                        SwingUtilities.convertPointFromScreen(point, (Component)FormattedTextField.this.fComponent);
                        if (!FormattedTextField.this.fComponent.contains(point) || FormattedTextField.this.getTokenAtX((int)point.getX()) == null) {
                            FormattedTextField.this.fHoveredToken = null;
                            FormattedTextField.this.fUnhoverTimer.stop();
                            FormattedTextField.this.fUnhoverTimer = null;
                            FormattedTextField.this.fComponent.revalidate();
                            FormattedTextField.this.fComponent.repaint();
                        }
                    }
                }
            });
            this.fUnhoverTimer.setRepeats(true);
            this.fUnhoverTimer.start();
        }
    }

    public void type(char c) {
        if (c == '\r' || c == '\n') {
            return;
        }
        if (!this.fEditable) {
            return;
        }
        if (this.fSelectionStart != this.fSelectionEnd) {
            this.deleteSelection();
        }
        this.fText.insert(this.fInsertionPoint, c);
        ++this.fInsertionPoint;
        this.update();
        this.scrollToInsertionPoint();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void insert(String string) {
        if (this.fSelectionStart != this.fSelectionEnd) {
            this.deleteSelection();
        }
        for (int i = 0; i < string.length(); ++i) {
            this.fText.insert(this.fInsertionPoint++, string.charAt(i));
        }
        this.update();
        this.scrollToInsertionPoint();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void replaceFieldToken(String string, boolean bl) {
        Token token = this.getFieldTokenForCharIndex(this.fInsertionPoint);
        if (token != null) {
            this.fSelectionStart = this.fInsertionPoint = this.getTextBefore(token).length();
            this.fSelectionEnd = this.fInsertionPoint + token.getText().length();
        }
        if (bl) {
            for (int i = 0; i < string.length(); ++i) {
                this.type(string.charAt(i));
            }
        } else {
            this.insert(string);
        }
    }

    private void doBackspace() {
        if (!this.fEditable) {
            return;
        }
        if (this.fSelectionStart != this.fSelectionEnd) {
            this.deleteSelection();
        } else if (this.fInsertionPoint > 0) {
            this.fText.deleteCharAt(this.fInsertionPoint - 1);
            --this.fInsertionPoint;
            this.update();
            this.scrollToInsertionPoint();
        }
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    private void doDelete() {
        if (!this.fEditable) {
            return;
        }
        if (this.fSelectionStart != this.fSelectionEnd) {
            this.deleteSelection();
        } else if (this.fInsertionPoint < this.fText.length()) {
            this.fText.deleteCharAt(this.fInsertionPoint);
        }
        this.update();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    protected void doTab(boolean bl) {
        Token token = this.getFieldTokenForCharIndex(this.fInsertionPoint);
        if (token != null) {
            int n = this.fTokens.indexOf(token);
            if (bl) {
                --n;
                while (n >= 0) {
                    if (this.isField(this.fTokens.get(n))) {
                        this.select(this.fTokens.get(n));
                        return;
                    }
                    --n;
                }
            } else {
                ++n;
                while (n < this.fTokens.size()) {
                    if (this.isField(this.fTokens.get(n))) {
                        this.select(this.fTokens.get(n));
                        return;
                    }
                    ++n;
                }
            }
        }
        if (this.getInsertionPoint() == this.getText().length() && this.fCompletionTokens != null && !this.fCompletionTokens.isEmpty()) {
            String string = this.fCompletionTokens.iterator().next().getText();
            this.fCompletionTokens = null;
            this.setText(this.getText() + string);
        }
    }

    private void doHome(boolean bl, boolean bl2) {
        this.lockFormatTip();
        while (this.fInsertionPoint > 0) {
            this.doLeftArrow(bl, bl2);
        }
        this.unlockFormatTip();
    }

    private void doEnd(boolean bl, boolean bl2) {
        this.lockFormatTip();
        while (this.fInsertionPoint < this.fText.length()) {
            this.doRightArrow(bl, bl2);
        }
        this.unlockFormatTip();
    }

    public void doLeftArrow(boolean bl, boolean bl2) {
        if (this.fInsertionPoint > 0) {
            if (bl2) {
                if (this.fSelectionStart == 0) {
                    this.fSelectionStart = this.fInsertionPoint;
                    this.fSelectionEnd = this.fInsertionPoint;
                }
                --this.fSelectionEnd;
            } else {
                this.fSelectionStart = 0;
                this.fSelectionEnd = 0;
            }
            --this.fInsertionPoint;
            Token token = this.getTokenForCharIndex(this.fInsertionPoint);
            if (token != null && (this.isSkippable(token) || bl)) {
                int n = this.getTokenOffsetAtCharIndex(this.fInsertionPoint);
                this.fInsertionPoint -= n;
                if (bl2) {
                    this.fSelectionEnd -= n;
                }
            }
            if ((token = this.getTokenForCharIndex(this.fInsertionPoint)) != null && this.isPrompt(token)) {
                this.select(token);
            }
            this.fCaret.turnOn();
            this.update();
            this.scrollToInsertionPoint();
        }
    }

    public void doRightArrow(boolean bl, boolean bl2) {
        Token token;
        int n = this.fInsertionPoint;
        if (this.fInsertionPoint < this.fText.length()) {
            ++this.fInsertionPoint;
        } else if (this.fInsertionPoint < this.getTextWithCompletion().length()) {
            this.fText.append(this.getCompletionText().charAt(0));
            this.fTokens = this.fTokenizer.tokenize(this.fText.toString());
            ++this.fInsertionPoint;
            this.fChangeListeners.stateChanged(new ChangeEvent(this));
        }
        if (!bl2) {
            this.fSelectionStart = 0;
            this.fSelectionEnd = 0;
        }
        if (bl2 && n != this.fInsertionPoint) {
            if (this.fSelectionStart == 0) {
                this.fSelectionStart = n;
                this.fSelectionEnd = n;
            }
            ++this.fSelectionEnd;
        }
        if ((token = this.getTokenForCharIndex(this.fInsertionPoint - 1)) != null && (this.isSkippable(token) || bl) && this.fTokens.indexOf(token) != this.fTokens.size() - 1) {
            int n2 = token.getText().length() - this.getTokenOffsetAtCharIndex(this.fInsertionPoint);
            this.fInsertionPoint += n2;
            if (bl2) {
                this.fSelectionEnd += n2;
            }
        }
        if ((token = this.getTokenForCharIndex(this.fInsertionPoint)) != null && this.isPrompt(token)) {
            this.select(token);
        }
        this.fCaret.turnOn();
        this.update();
        this.scrollToInsertionPoint();
    }

    public void doEnter() {
    }

    public void doEscape() {
    }

    private void deleteSelection() {
        if (!this.fEditable) {
            return;
        }
        this.fText.delete(Math.min(this.fSelectionStart, this.fSelectionEnd), Math.max(this.fSelectionStart, this.fSelectionEnd));
        this.fInsertionPoint = Math.min(this.fSelectionStart, this.fSelectionEnd);
        this.fSelectionStart = 0;
        this.fSelectionEnd = 0;
        this.update();
        this.scrollToInsertionPoint();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void update() {
        if (!this.fInitialized) {
            return;
        }
        this.fTokens = this.fTokenizer.tokenize(this.fText.toString());
        if (FormattedTextField.assembleTokens(this.fTokens).length() != this.fText.length()) {
            throw new IllegalStateException("Tokenizer dropped or added characters: " + this.fTokens);
        }
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FormattedTextField.this.fTokenRects = FormattedTextField.this.fPainter.paint(FormattedTextField.this, FormattedTextField.this.fDryRunGraphics);
                if (FormattedTextField.this.fFormatTipLockCount == 0 && FormattedTextField.this.fEditable) {
                    FormattedTextField.this.fFormatTip.update(FormattedTextField.this);
                }
                FormattedTextField.this.fComponent.revalidate();
                FormattedTextField.this.fComponent.repaint();
            }
        };
        final List<Token> list = this.fTokens;
        this.fCompletionTokens = null;
        this.fCompleter.getSuggestedCompletion(this.fTokens, new ParameterRunnable<List<Token>>(){

            public void run(final List<Token> list2) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (FormattedTextField.this.fTokens == list) {
                            FormattedTextField.this.fCompletionTokens = list2;
                            runnable.run();
                        }
                    }
                });
            }
        });
        runnable.run();
    }

    public void closeFormatTip() {
        this.fFormatTip.close();
    }

    public void lockFormatTip() {
        ++this.fFormatTipLockCount;
    }

    public void unlockFormatTip() {
        if (--this.fFormatTipLockCount == 0) {
            this.update();
        }
    }

    protected boolean isField(Token token) {
        return false;
    }

    protected boolean isSkippable(Token token) {
        return false;
    }

    protected boolean isPrompt(Token token) {
        return false;
    }

    protected String doExtraPasteFiltering(String string) {
        return string;
    }

    private void showContextMenu(Point point) {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.add((Action)new MJAbstractAction(BuiltInResources.getString("action.cut")){
            {
                this.setEnabled(FormattedTextField.this.fEditable);
                this.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FormattedTextField.this.fClipboardManager.doCut();
            }
        });
        mJPopupMenu.add((Action)new MJAbstractAction(BuiltInResources.getString("action.copy")){
            {
                this.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FormattedTextField.this.fClipboardManager.doCopy();
            }
        });
        mJPopupMenu.add((Action)new MJAbstractAction(BuiltInResources.getString("action.paste")){
            {
                this.setEnabled(FormattedTextField.this.fEditable);
                this.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FormattedTextField.this.fClipboardManager.doPaste();
            }
        });
        mJPopupMenu.add((Action)new MJAbstractAction(BuiltInResources.getString("action.selectAll")){
            {
                this.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FormattedTextField.this.selectAll();
            }
        });
        this.closeFormatTip();
        this.lockFormatTip();
        mJPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                FormattedTextField.this.unlockFormatTip();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        mJPopupMenu.show((Component)this.fComponent, (int)point.getX(), (int)point.getY());
    }

    private void listenToScrollbar(JScrollBar jScrollBar) {
        if (jScrollBar != null) {
            this.fScrollBars.add(jScrollBar);
            jScrollBar.addAdjustmentListener(this.fAdjustmentListener);
        }
    }

    private static class Scroller
    extends MJPanel {
        private final Component fView;
        private int fOffset;

        Scroller(Component component) {
            this.fView = component;
            this.setLayout(null);
            this.add(component);
            this.setOpaque(false);
        }

        public Dimension getPreferredSize() {
            return new Dimension(1, (int)this.fView.getPreferredSize().getHeight());
        }

        public void doLayout() {
            super.doLayout();
            this.fView.setBounds(-this.fOffset, 0, this.getWidth() + this.fOffset, this.getHeight());
        }

        public void scrollRectToVisible(Rectangle rectangle) {
            if (rectangle.getX() < (double)this.fOffset) {
                this.fOffset = Math.max(0, (int)rectangle.getX());
                this.revalidate();
                this.repaint();
            } else if (this.getWidth() > 10 && rectangle.getX() + rectangle.getWidth() > (double)(this.getWidth() - this.fOffset)) {
                this.fOffset = Math.max(0, (int)(rectangle.getX() + rectangle.getWidth() - (double)this.getWidth()));
                this.revalidate();
                this.repaint();
            } else {
                this.constrainToSize();
            }
        }

        public void constrainToSize() {
            int n = Math.max(0, (int)(this.fView.getPreferredSize().getWidth() - (double)this.getWidth()));
            if (n < this.fOffset) {
                this.fOffset = n;
                this.revalidate();
                this.repaint();
            }
        }
    }

    private class ClipboardManager
    implements ClipboardOwner {
        private ClipboardManager() {
        }

        public void doCut() {
            if (!FormattedTextField.this.fEditable) {
                return;
            }
            if (FormattedTextField.this.fSelectionStart != FormattedTextField.this.fSelectionEnd) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(FormattedTextField.this.getSelectedText()), this);
                FormattedTextField.this.deleteSelection();
            }
        }

        public void doCopy() {
            if (FormattedTextField.this.fSelectionStart != FormattedTextField.this.fSelectionEnd) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(FormattedTextField.this.getSelectedText()), this);
            }
        }

        public void doPaste() {
            if (!FormattedTextField.this.fEditable) {
                return;
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    string = string.replaceAll("[\t\r\n]", " ");
                    while (string.startsWith(" ") && (FormattedTextField.this.fText.length() == 0 || FormattedTextField.this.getSelectedText().length() == FormattedTextField.this.fText.length())) {
                        string = string.substring(1);
                    }
                    string = FormattedTextField.this.doExtraPasteFiltering(string);
                    FormattedTextField.this.insert(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    public class TextComponent
    extends MJPanel {
        private TextComponent() {
            if (PlatformInfo.isMacintosh()) {
                this.setFont(FontPrefs.getTextFont().deriveFont(11.0f));
            }
        }

        public FormattedTextField getOwner() {
            return FormattedTextField.this;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            FormattedTextField.this.fPainter.paint(FormattedTextField.this, graphics2D);
            graphics2D.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getPreferredSize() {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                if (FormattedTextField.this.fTokens.isEmpty()) {
                    Dimension dimension = new Dimension(10, graphics2D.getFontMetrics(this.getFont()).getHeight());
                    return dimension;
                }
                Map<Token, Rectangle> map = FormattedTextField.this.fPainter.paint(FormattedTextField.this, graphics2D);
                Rectangle rectangle = map.get(FormattedTextField.this.fTokens.get(FormattedTextField.this.fTokens.size() - 1));
                Dimension dimension = new Dimension(rectangle.x + rectangle.width, rectangle.height);
                return dimension;
            }
            finally {
                graphics2D.dispose();
            }
        }

        public void addNotify() {
            super.addNotify();
            FormattedTextField.this.fWindow = SwingUtilities.windowForComponent((Component)FormattedTextField.this.fComponent);
            FormattedTextField.this.fWindow.addComponentListener(FormattedTextField.this.fComponentListener);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JScrollPane jScrollPane = (JScrollPane)TreeUtils.findAncestorComponent((Component)FormattedTextField.this.fComponent, JScrollPane.class);
                    while (jScrollPane != null) {
                        FormattedTextField.this.listenToScrollbar(jScrollPane.getVerticalScrollBar());
                        FormattedTextField.this.listenToScrollbar(jScrollPane.getHorizontalScrollBar());
                        jScrollPane = (JScrollPane)TreeUtils.findAncestorComponent((Component)jScrollPane.getParent(), JScrollPane.class);
                    }
                }
            });
        }
    }
}

