/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.impl.engine.DeploymentProcessAdapter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class WorkflowModel {
    private final Configuration fConfiguration;
    private final MulticastChangeListener fChangeListeners;
    private final PropertyChangeListener fConfigurationListener;
    private final Set<String> fRelevantKeys;
    private final Map<String, WorkflowStepResult> fResults;
    private final Set<String> fRunnable;
    private final Set<String> fEnabled;
    private final Set<String> fVisible;
    private DeploymentProcess fCurrentProcess;
    private WorkflowStep fRunningStep;

    public WorkflowModel(Configuration configuration) {
        this.fConfiguration = configuration;
        this.fChangeListeners = new MulticastChangeListener();
        this.fRelevantKeys = WorkflowModel.findRelevantKeys(configuration);
        this.fResults = new HashMap<String, WorkflowStepResult>();
        this.fRunnable = new HashSet<String>();
        this.fEnabled = new HashSet<String>();
        this.fVisible = new HashSet<String>();
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (WorkflowModel.this.isConfigurationEventRelevant(propertyChangeEvent)) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WorkflowModel.this.update();
                        }
                    });
                } else if (WorkflowModel.this.fConfiguration.isWorkflowStepSkippedEvent(propertyChangeEvent)) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WorkflowModel.this.update();
                        }
                    });
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
        this.update();
    }

    public void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
    }

    public DeploymentProcess getCurrentProcess() {
        return this.fCurrentProcess;
    }

    public WorkflowStep getRunningStep() {
        return this.fRunningStep;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public boolean isRunnable(WorkflowStep workflowStep) {
        return this.fCurrentProcess == null && this.fRunnable.contains(workflowStep.getKey());
    }

    public boolean isResettable(WorkflowStep workflowStep) {
        return this.fResults.get(workflowStep.getKey()) != null && workflowStep.isRunnable() || !workflowStep.getSubSteps().isEmpty();
    }

    public boolean isEnabled(WorkflowStep workflowStep) {
        return this.fEnabled.contains(workflowStep.getKey());
    }

    public WorkflowStepResult getResult(WorkflowStep workflowStep) {
        return this.fResults.get(workflowStep.getKey());
    }

    public void setResult(final WorkflowStep workflowStep, final WorkflowStepResult workflowStepResult) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkflowModel.this.fResults.put(workflowStep.getKey(), workflowStepResult);
                WorkflowModel.this.update();
            }
        });
    }

    public void bind(final DeploymentProcess deploymentProcess, final WorkflowStep workflowStep) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (WorkflowStep workflowStep2 = workflowStep; workflowStep2 != null; workflowStep2 = workflowStep2.getParent()) {
                    if (WorkflowModel.this.getResult(workflowStep2) != WorkflowStepResult.SKIPPED) continue;
                    WorkflowModel.this.fResults.put(workflowStep2.getKey(), null);
                    WorkflowModel.this.fChangeListeners.stateChanged(new ChangeEvent(WorkflowModel.this));
                }
            }
        });
        deploymentProcess.addMonitor((DeploymentProcessMonitor)new DeploymentProcessAdapter(){
            private final AtomicBoolean fStarted = new AtomicBoolean(false);

            @Override
            public void commandStarted(String string) {
                if (!this.fStarted.getAndSet(true)) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WorkflowModel.this.fCurrentProcess = deploymentProcess;
                            WorkflowModel.this.fRunningStep = workflowStep;
                            WorkflowModel.this.markNoResult(workflowStep);
                        }
                    });
                }
            }

            @Override
            public void finished() {
                WorkflowModel.this.markCompleted(workflowStep);
            }

            @Override
            public void failed() {
                WorkflowModel.this.markFailed(workflowStep);
            }

            @Override
            public void canceled() {
                WorkflowModel.this.markFailed(workflowStep);
            }
        });
    }

    public Iterator<WorkflowStep> getRunGroupIterator(WorkflowStep workflowStep, ParameterRunnable<WorkflowStep> parameterRunnable) {
        return new RunIterator(workflowStep, null, parameterRunnable);
    }

    public Iterator<WorkflowStep> getRunToIterator(WorkflowStep workflowStep, ParameterRunnable<WorkflowStep> parameterRunnable) {
        return new RunIterator(null, workflowStep, parameterRunnable);
    }

    public void reset(WorkflowStep workflowStep, ParameterRunnable<WorkflowStep> parameterRunnable) {
        List<WorkflowStep> list = this.fConfiguration.getTarget().getWorkflow().getFlattenedSteps();
        int n = list.indexOf(workflowStep);
        MatlabExpression matlabExpression = this.fConfiguration.getTarget().getWorflowResetCode();
        for (int i = list.size() - 1; i >= n; --i) {
            WorkflowStep workflowStep2 = list.get(i);
            this.fResults.put(workflowStep2.getKey(), null);
            if (matlabExpression != null) {
                matlabExpression.evaluate(this.fConfiguration.getProject(), false, new String[]{"'" + workflowStep2.getKey() + "'"});
            }
            if (parameterRunnable == null) continue;
            parameterRunnable.run((Object)workflowStep2);
        }
        this.update();
    }

    public void resetBeforeRun(final WorkflowStep workflowStep, final ParameterRunnable<WorkflowStep> parameterRunnable) {
        this.reset(workflowStep, new ParameterRunnable<WorkflowStep>(){

            public void run(WorkflowStep workflowStep2) {
                if (workflowStep2 != workflowStep) {
                    parameterRunnable.run((Object)workflowStep2);
                }
            }
        });
    }

    private static Set<String> findRelevantKeys(Configuration configuration) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (ParamSet object : configuration.getTarget().getParamSets()) {
            for (Param param : object.getParams()) {
                hashSet2.add(param.getKey());
            }
        }
        for (FileSetDefinition fileSetDefinition : configuration.getTarget().getFileSets()) {
            hashSet2.add(fileSetDefinition.getKey());
        }
        return hashSet;
    }

    private boolean isConfigurationEventRelevant(PropertyChangeEvent propertyChangeEvent) {
        return this.fRelevantKeys.contains(propertyChangeEvent.getPropertyName()) || Configuration.isWorkflowStepVisibilityChange(propertyChangeEvent);
    }

    private void markNoResult(final WorkflowStep workflowStep) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkflowModel.this.fResults.remove(workflowStep.getKey());
                WorkflowModel.this.update();
            }
        });
    }

    private void markCompleted(final WorkflowStep workflowStep) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkflowModel.this.fCurrentProcess = null;
                WorkflowModel.this.fRunningStep = null;
                WorkflowModel.this.fResults.put(workflowStep.getKey(), WorkflowStepResult.COMPLETED);
                WorkflowModel.this.update();
            }
        });
    }

    private void markFailed(final WorkflowStep workflowStep) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkflowModel.this.fCurrentProcess = null;
                WorkflowModel.this.fRunningStep = null;
                WorkflowModel.this.fResults.put(workflowStep.getKey(), WorkflowStepResult.ERROR);
                WorkflowModel.this.update();
            }
        });
    }

    private void update() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkflowModel.this.fRunnable.clear();
                WorkflowModel.this.fEnabled.clear();
                WorkflowModel.this.fVisible.clear();
                for (WorkflowStep object : WorkflowModel.this.fConfiguration.getTarget().getWorkflow().getFlattenedSteps()) {
                    if (!WorkflowModel.this.fConfiguration.isWorkflowStepVisible(object)) continue;
                    WorkflowModel.this.fVisible.add(object.getKey());
                }
                boolean bl = true;
                for (WorkflowStep workflowStep : WorkflowModel.this.fConfiguration.getTarget().getWorkflow().getSteps()) {
                    bl = WorkflowModel.this.updateHelper(workflowStep, bl);
                }
                WorkflowModel.this.fChangeListeners.stateChanged(new ChangeEvent(WorkflowModel.this));
            }
        });
    }

    public boolean isVisible(WorkflowStep workflowStep) {
        return this.fVisible.contains(workflowStep.getKey());
    }

    private boolean updateHelper(WorkflowStep workflowStep, boolean bl) {
        if (!this.isVisible(workflowStep)) {
            return bl;
        }
        if (this.getResult(workflowStep) == WorkflowStepResult.SKIPPED && !this.fConfiguration.isWorkflowStepSkipped(workflowStep)) {
            this.fResults.put(workflowStep.getKey(), null);
        } else if (bl && !this.isParent(workflowStep, this.fRunningStep) && this.fConfiguration.isWorkflowStepSkipped(workflowStep) && !this.allChildrenHaveResult(workflowStep, WorkflowStepResult.COMPLETED) && this.getResult(workflowStep) == null) {
            this.fResults.put(workflowStep.getKey(), WorkflowStepResult.SKIPPED);
        }
        if (bl) {
            if (!workflowStep.isEnabledOnParentComplete() || this.getResult(workflowStep.getParent()) == WorkflowStepResult.COMPLETED) {
                this.fEnabled.add(workflowStep.getKey());
            }
            if (workflowStep.isRunnableOrGroup()) {
                this.fRunnable.add(workflowStep.getKey());
            }
        }
        for (WorkflowStep workflowStep2 : workflowStep.getSubSteps()) {
            if (this.updateHelper(workflowStep2, bl) || this.fConfiguration.isWorkflowStepSkipped(workflowStep2)) continue;
            bl = false;
        }
        if (workflowStep.isRunnable() && this.fResults.get(workflowStep.getKey()) != WorkflowStepResult.COMPLETED && !this.fConfiguration.isWorkflowStepSkipped(workflowStep)) {
            bl = false;
        } else if (!workflowStep.isRunnable() && bl && this.fResults.get(workflowStep.getKey()) != WorkflowStepResult.SKIPPED) {
            if (this.allChildrenHaveResult(workflowStep, WorkflowStepResult.SKIPPED)) {
                this.fResults.put(workflowStep.getKey(), WorkflowStepResult.SKIPPED);
            } else {
                this.fResults.put(workflowStep.getKey(), WorkflowStepResult.COMPLETED);
            }
        }
        return bl;
    }

    private boolean allChildrenHaveResult(WorkflowStep workflowStep, WorkflowStepResult workflowStepResult) {
        if (workflowStep.getSubSteps().isEmpty()) {
            return false;
        }
        for (WorkflowStep workflowStep2 : workflowStep.getSubSteps()) {
            if (this.getResult(workflowStep2) == workflowStepResult || !this.isVisible(workflowStep2)) continue;
            return false;
        }
        return true;
    }

    private boolean isParent(WorkflowStep workflowStep, WorkflowStep workflowStep2) {
        if (workflowStep2 == null || workflowStep == null) {
            return false;
        }
        if (workflowStep2.getKey().equals(workflowStep.getKey())) {
            return true;
        }
        return this.isParent(workflowStep, workflowStep2.getParent());
    }

    private class RunIterator
    implements Iterator<WorkflowStep> {
        private final Stack<Iterator<WorkflowStep>> fStack;
        private final ParameterRunnable<WorkflowStep> fResetCallback;
        private final WorkflowStep fRoot;
        private final WorkflowStep fEnd;
        private boolean fDidReset;
        private boolean fEnabled;
        private Iterator<WorkflowStep> fIterator;
        private WorkflowStep fNext;

        RunIterator(WorkflowStep workflowStep, WorkflowStep workflowStep2, ParameterRunnable<WorkflowStep> parameterRunnable) {
            this.fRoot = workflowStep;
            this.fEnd = workflowStep2;
            this.fResetCallback = parameterRunnable;
            this.fStack = new Stack();
            Iterator<WorkflowStep> iterator = this.fIterator = workflowStep != null ? workflowStep.getSubSteps().iterator() : WorkflowModel.this.fConfiguration.getTarget().getWorkflow().getSteps().iterator();
            if (workflowStep2 != null) {
                while (this.hasNext()) {
                    WorkflowStep workflowStep3 = this.next();
                    if (!workflowStep3.getKey().equals(workflowStep2.getKey()) && WorkflowModel.this.getResult(workflowStep3) != null && WorkflowModel.this.getResult(workflowStep3) != WorkflowStepResult.ERROR) continue;
                    this.fNext = workflowStep3;
                    WorkflowModel.this.resetBeforeRun(this.fNext, this.fResetCallback);
                    this.fDidReset = true;
                    break;
                }
            }
            this.fEnabled = true;
        }

        @Override
        public boolean hasNext() {
            if (this.fNext == null) {
                this.findNext();
            }
            return this.fNext != null;
        }

        @Override
        public WorkflowStep next() {
            this.hasNext();
            if (this.fEnd != null && this.fNext != null && this.fNext.getKey().equals(this.fEnd.getKey())) {
                this.fStack.clear();
                this.fIterator = null;
            }
            WorkflowStep workflowStep = this.fNext;
            this.fNext = null;
            if (!this.fDidReset && this.fEnabled) {
                WorkflowModel.this.resetBeforeRun(workflowStep, this.fResetCallback);
                this.fDidReset = true;
            }
            return workflowStep;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean isParent(WorkflowStep workflowStep, WorkflowStep workflowStep2) {
            return workflowStep2.getParent() != null && (workflowStep2.getParent().getKey().equals(workflowStep.getKey()) || this.isParent(workflowStep, workflowStep2.getParent()));
        }

        private void findNext() {
            while (this.fIterator != null) {
                while (this.fIterator.hasNext()) {
                    WorkflowStep workflowStep = this.fIterator.next();
                    if (WorkflowModel.this.isRunnable(workflowStep) && workflowStep.isRunnable() && (!WorkflowModel.this.fConfiguration.isWorkflowStepSkipped(workflowStep) || this.fEnd != null && workflowStep.getKey().equals(this.fEnd.getKey()))) {
                        this.fNext = workflowStep;
                        return;
                    }
                    if (WorkflowModel.this.fConfiguration.isWorkflowStepSkipped(workflowStep) && (this.fEnd == null || !this.isParent(workflowStep, this.fEnd))) {
                        WorkflowModel.this.fResults.put(workflowStep.getKey(), WorkflowStepResult.SKIPPED);
                        WorkflowModel.this.update();
                        continue;
                    }
                    if (WorkflowModel.this.isVisible(workflowStep) && workflowStep.isRunnable()) {
                        this.fIterator = null;
                        this.fStack.clear();
                        return;
                    }
                    if (workflowStep.getSubSteps().isEmpty()) continue;
                    this.fStack.push(this.fIterator);
                    this.fIterator = workflowStep.getSubSteps().iterator();
                    if (WorkflowModel.this.getResult(workflowStep) != WorkflowStepResult.SKIPPED) continue;
                    WorkflowModel.this.setResult(workflowStep, null);
                }
                this.fIterator = this.fStack.isEmpty() ? null : this.fStack.pop();
            }
            if (this.fRoot != null) {
                WorkflowModel.this.setResult(this.fRoot, WorkflowStepResult.COMPLETED);
            }
        }
    }
}

