/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reliableLog;

import com.sun.jini.reliableLog.LogException;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.LogInputStream;
import com.sun.jini.reliableLog.LogOutputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;

public class ReliableLog {
    private static final String snapshotPrefix = "Snapshot.";
    private static final String logfilePrefix = "Logfile.";
    private static final String versionFile = "Version_Number";
    private static final int MAGIC = -219353113;
    private static final int FORMAT_UNPADDED = 0;
    private static final int FORMAT_PADDED = 1;
    private static final long intBytes = 4L;
    private final File dir;
    private int version = 0;
    private int format = 0;
    private String logName = null;
    private RandomAccessFile log = null;
    private FileDescriptor logFD;
    private long snapshotBytes = 0L;
    private long logBytes = 0L;
    private final LogHandler handler;
    private final byte[] intBuf = new byte[4];
    private final byte[] zeroBuf = new byte[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReliableLog(String string, LogHandler logHandler) throws IOException {
        this.dir = new File(string);
        if (!(!this.dir.exists() ? this.dir.mkdir() : this.dir.isDirectory())) {
            throw new LogException("could not create directory for log: " + string);
        }
        this.handler = logHandler;
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.fName(versionFile)));
            try {
                this.version = dataInputStream.readInt();
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            this.writeVersionFile();
        }
        if (this.version < 0) {
            throw new LogException("corrupted version file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws IOException {
        if (this.version == 0) {
            return;
        }
        String string = this.versionName(snapshotPrefix);
        File file = new File(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            this.handler.recover(bufferedInputStream);
        }
        catch (Exception exception) {
            throw new LogException("recovery failed", exception);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        this.snapshotBytes = file.length();
        string = this.versionName(logfilePrefix);
        file = new File(string);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        long l = file.length();
        try {
            int n = dataInputStream.readInt();
            if (n == -219353113) {
                this.format = dataInputStream.readInt();
                if (this.format != 1) {
                    throw new LogException("corrupted log: bad log format");
                }
                this.logBytes += 8L;
                n = dataInputStream.readInt();
            }
            while (n != 0) {
                int n2;
                if (n < 0) {
                    throw new LogException("corrupted log: bad update length");
                }
                if (l - this.logBytes - 4L < (long)n) {
                    break;
                }
                try {
                    this.handler.readUpdate(new LogInputStream(dataInputStream, n));
                }
                catch (Exception exception) {
                    throw new LogException("read update failed", exception);
                }
                this.logBytes += 4L + (long)n;
                if (this.format == 1 && (n2 = (int)this.logBytes & 3) > 0) {
                    n2 = 4 - n2;
                    this.logBytes += (long)n2;
                    dataInputStream.skipBytes(n2);
                }
                n = dataInputStream.readInt();
            }
        }
        catch (EOFException eOFException) {
        }
        finally {
            dataInputStream.close();
        }
        this.openLogFile();
    }

    public void update(Object object) throws IOException {
        this.update(object, true);
    }

    public void update(Object object, boolean bl) throws IOException {
        long l;
        long l2;
        if (this.log == null) {
            throw new LogException("log file for persistent state is inaccessible, it may have been corrupted or closed");
        }
        try {
            this.handler.writeUpdate(new LogOutputStream(this.log), object);
        }
        catch (Exception exception) {
            throw new LogException("write update failed", exception);
        }
        if (bl) {
            try {
                this.logFD.sync();
            }
            catch (SyncFailedException syncFailedException) {
                throw new LogException("sync log failed", syncFailedException);
            }
        }
        if ((l2 = (l = this.log.getFilePointer()) - this.logBytes - 4L) > Integer.MAX_VALUE) {
            throw new LogException("maximum record length exceeded");
        }
        this.log.seek(this.logBytes);
        this.writeInt(this.log, (int)l2);
        if (this.format == 1) {
            l = l + 3L & 0xFFFFFFFFFFFFFFFCL;
        }
        this.log.seek(l);
        this.log.write(this.zeroBuf);
        this.logBytes = l;
        if (bl) {
            try {
                this.logFD.sync();
            }
            catch (SyncFailedException syncFailedException) {
                throw new LogException("sync log failed", syncFailedException);
            }
        }
    }

    private void writeInt(DataOutput dataOutput, int n) throws IOException {
        this.intBuf[0] = (byte)(n >> 24);
        this.intBuf[1] = (byte)(n >> 16);
        this.intBuf[2] = (byte)(n >> 8);
        this.intBuf[3] = (byte)n;
        dataOutput.write(this.intBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot() throws IOException {
        int n = this.version++;
        String string = this.versionName(snapshotPrefix);
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            try {
                this.handler.snapshot(fileOutputStream);
                fileOutputStream.getFD().sync();
            }
            catch (Exception exception) {
                throw new LogException("snapshot failed", exception);
            }
            this.snapshotBytes = file.length();
        }
        finally {
            fileOutputStream.close();
        }
        this.logBytes = 0L;
        this.openLogFile();
        this.writeVersionFile();
        this.deleteSnapshot(n);
        this.deleteLogFile(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.log.close();
        }
        finally {
            this.log = null;
        }
    }

    public void deletePersistentStore() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.deleteLogFile(this.version);
        }
        catch (LogException logException) {
            // empty catch block
        }
        try {
            this.deleteSnapshot(this.version);
        }
        catch (LogException logException) {
            // empty catch block
        }
        try {
            this.deleteFile(this.fName(versionFile));
        }
        catch (LogException logException) {
            // empty catch block
        }
        try {
            this.dir.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public long snapshotSize() {
        return this.snapshotBytes;
    }

    public long logSize() {
        return this.logBytes;
    }

    private String fName(String string) {
        return this.dir.getPath() + File.separator + string;
    }

    private String versionName(String string) {
        return this.versionName(string, this.version);
    }

    private String versionName(String string, int n) {
        return this.fName(string) + String.valueOf(n);
    }

    private void deleteFile(String string) throws LogException {
        if (!new File(string).delete()) {
            throw new LogException("couldn't delete file: " + string);
        }
    }

    private void deleteSnapshot(int n) throws LogException {
        if (n != 0) {
            this.deleteFile(this.versionName(snapshotPrefix, n));
        }
    }

    private void deleteLogFile(int n) throws LogException {
        if (n != 0) {
            this.deleteFile(this.versionName(logfilePrefix, n));
        }
    }

    private void openLogFile() throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logName = this.versionName(logfilePrefix);
        this.log = new RandomAccessFile(this.logName, "rw");
        this.logFD = this.log.getFD();
        if (this.logBytes == 0L) {
            this.format = 1;
            this.writeInt(this.log, -219353113);
            this.writeInt(this.log, this.format);
            this.logBytes = 8L;
        } else {
            this.log.seek(this.logBytes);
        }
        this.log.setLength(this.logBytes);
        this.log.write(this.zeroBuf);
        this.logFD.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVersionFile() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.fName(versionFile), "rw");
        try {
            this.writeInt(randomAccessFile, this.version);
            randomAccessFile.getFD().sync();
        }
        finally {
            randomAccessFile.close();
        }
    }
}

