/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.AuthenticationManager;
import ice.net.CacheManager;
import ice.net.ConnectionManager;
import ice.net.ConnectionManagerSettings;
import ice.net.CookieManager;
import ice.net.HeaderMap;
import ice.net.HttpURLConnection;
import ice.net.proxy.ProxyResolver;
import ice.util.Defs;
import ice.util.Settings;
import ice.util.memory.MemoryManager;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class HttpURLConnectionSettings
implements Serializable,
Settings {
    private Vector acceptLanguageList;
    private AuthenticationManager authenticationManager;
    private CacheManager cacheManager;
    private ConnectionManager connectionManager;
    private CookieManager cookieManager;
    private String httpVersion;
    private MemoryManager memoryManager;
    private ProxyResolver proxyResolver;
    private boolean redirectsEnabled;
    private HeaderMap requestHeaders = new HeaderMap();
    private boolean retryBrokenConnections;

    public HttpURLConnectionSettings() {
        this.addElement();
    }

    public static boolean areDefaultRedirectsEnabled() {
        return Defs.sysPropertyBoolean((String)"ice.net.redirectsEnabled", (boolean)true);
    }

    public boolean areRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public boolean equals(Object object) {
        return object instanceof HttpURLConnectionSettings && ((HttpURLConnectionSettings)object).acceptLanguageList.equals(this.acceptLanguageList) && ((HttpURLConnectionSettings)object).authenticationManager.equals(this.authenticationManager) && ((HttpURLConnectionSettings)object).cacheManager.equals(this.cacheManager) && ((HttpURLConnectionSettings)object).connectionManager.equals(this.connectionManager) && ((HttpURLConnectionSettings)object).cookieManager.equals(this.cookieManager) && ((HttpURLConnectionSettings)object).httpVersion.equals(this.httpVersion) && ((HttpURLConnectionSettings)object).memoryManager.equals(this.memoryManager) && ((HttpURLConnectionSettings)object).proxyResolver.equals(this.proxyResolver) && ((HttpURLConnectionSettings)object).redirectsEnabled == this.redirectsEnabled && ((HttpURLConnectionSettings)object).requestHeaders.equals(this.requestHeaders) && ((HttpURLConnectionSettings)object).retryBrokenConnections == this.retryBrokenConnections;
    }

    public Vector getAcceptLanguageList() {
        return this.acceptLanguageList;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public static String getDefaultHttpVersion() {
        return Defs.sysProperty((String)"ice.net.httpVersion", (String)"HTTP/1.1");
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public ProxyResolver getProxyResolver() {
        return this.proxyResolver;
    }

    public HeaderMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public void resetToDefault() {
        this.requestHeaders.clear();
        this.authenticationManager = null;
        this.cacheManager = null;
        this.cookieManager = null;
        this.memoryManager = null;
        this.proxyResolver = null;
        this.addElement();
    }

    public void setAcceptLanguageList(Vector vector) {
        if (this.acceptLanguageList == null && vector != null || this.acceptLanguageList != null && !this.acceptLanguageList.equals(vector)) {
            this.acceptLanguageList = vector;
            HttpURLConnection.updateAcceptLanguage(this.requestHeaders, this.acceptLanguageList);
        }
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) throws IllegalArgumentException {
        if (connectionManager == null) {
            throw new IllegalArgumentException("connectionManager is null");
        }
        this.connectionManager = connectionManager;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public static void setDefaultHttpVersion(String string) throws IllegalArgumentException {
        HttpURLConnectionSettings.OEAB(string);
        Defs.setSystemProperty((String)"ice.net.httpVersion", (String)string);
    }

    public static void setDefaultRedirectsEnabled(boolean bl) throws SecurityException {
        HttpURLConnectionSettings.acceptLanguageList();
        Defs.setSystemProperty((String)"ice.net.redirectsEnabled", (String)new Boolean(bl).toString());
    }

    public static void setDefaultRetryBrokenConnections(boolean bl) {
        Defs.setSystemProperty((String)"ice.net.retryBrokenConnections", (String)new Boolean(bl).toString());
    }

    public void setHttpVersion(String string) throws IllegalArgumentException {
        HttpURLConnectionSettings.OEAB(string);
        this.httpVersion = string;
    }

    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public void setProxyResolver(ProxyResolver proxyResolver) {
        this.proxyResolver = proxyResolver;
    }

    public void setRedirectsEnabled(boolean bl) throws SecurityException {
        HttpURLConnectionSettings.acceptLanguageList();
        this.redirectsEnabled = bl;
    }

    public void setRetryBrokenConnections(boolean bl) {
        this.retryBrokenConnections = bl;
    }

    public static boolean shouldDefaultRetryBrokenConnections() {
        return Defs.sysPropertyBoolean((String)"ice.net.retryBrokenConnections", (boolean)true);
    }

    public boolean shouldRetryBrokenConnections() {
        return this.retryBrokenConnections;
    }

    public String toString() {
        return "HttpURLConnectionSettings [authenticationManager: " + this.authenticationManager + ", " + "cacheManager: " + this.cacheManager + ", " + "connectionManager: " + this.connectionManager + ", " + "cookieManager: " + this.cookieManager + ", " + "httpVersion: " + this.httpVersion + ", " + "memoryManager: " + this.memoryManager + ", " + "proxyResolver: " + this.proxyResolver + ", " + "redirectsEnabled: " + this.redirectsEnabled + ", " + "requestHeaders: " + this.requestHeaders + ", " + "retryBrokenConnections: " + this.retryBrokenConnections + "]";
    }

    private static void OEAB(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("httpVersion is null");
        }
        if (!string.equals("HTTP/1.0") && !string.equals("HTTP/1.1")) {
            throw new IllegalArgumentException("illegal httpVersion: " + string);
        }
    }

    private static void acceptLanguageList() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
    }

    private void addElement() {
        this.requestHeaders.putHeader("Accept", "*/*");
        this.requestHeaders.putHeader("Accept-Encoding", "gzip");
        Vector<Locale> vector = new Vector<Locale>();
        vector.addElement(new Locale(Locale.getDefault().getLanguage(), ""));
        this.setAcceptLanguageList(vector);
        this.connectionManager = new ConnectionManager(new ConnectionManagerSettings());
        this.httpVersion = HttpURLConnectionSettings.getDefaultHttpVersion();
        this.redirectsEnabled = HttpURLConnectionSettings.areDefaultRedirectsEnabled();
        this.retryBrokenConnections = HttpURLConnectionSettings.shouldDefaultRetryBrokenConnections();
    }
}

