/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.ConnectionRoute;
import ice.util.Defs;
import java.io.Serializable;

public abstract class Indirect
extends ConnectionRoute
implements Serializable {
    private static long OEAB = Defs.sysPropertyInt((String)"ice.net.indirectRetryInterval", (int)1800000);
    private int failedCounter = 0;
    private String host;
    private Object lock = new Object();
    private int port;
    private long timestamp;

    protected Indirect(String string, int n) throws IllegalArgumentException {
        this.checkHost(string);
        this.checkPort(n);
        this.host = string.trim().toLowerCase();
        this.port = n;
    }

    public boolean equals(Object object) {
        if (object instanceof Indirect) {
            return super.equals(object) && this.host.equals(((Indirect)object).getHost()) && this.port == ((Indirect)object).getPort();
        }
        return false;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final int getStatus() {
        int n = super.getStatus();
        if (n == 3 && this.timestamp < System.currentTimeMillis() - (long)this.failedCounter * OEAB) {
            n = 1;
            super.setStatus(1);
        }
        return n;
    }

    public final void setStatus(int n) {
        this.checkStatus(n);
        Object object = this.lock;
        synchronized (object) {
            super.setStatus(n);
            if (n == 3) {
                ++this.failedCounter;
                this.timestamp = System.currentTimeMillis();
            }
        }
    }

    protected final void checkHost(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("host is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("host is empty");
        }
    }

    protected final void checkPort(int n) throws IllegalArgumentException {
        if (n < 0 || n > 65536) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
    }
}

