/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.compare.impl.CompareInMatlabGenerateHTML;
import com.mathworks.comparisons.decorator.htmlreport.BinaryReportDecorator;
import com.mathworks.comparisons.decorator.htmlreport.HTMLReportDecorator;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.data.CEventDataRefresh;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.parameter.CParameterDetailedBinaryComparison;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.property.CSPropertyInputStream;
import com.mathworks.comparisons.source.property.CSPropertySize;
import com.mathworks.comparisons.util.LocalIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class BinaryComparison
extends CompareInMatlabGenerateHTML {
    private static final String COMPARE_FUNCTION = "comparisons_private";
    private static final int NUM_OUT_ARGS = 1;
    private ComparisonParameterSet fParameterSet;
    private static final ConcurrentHashMap<String, BinaryComparison> COMPARISONS = new ConcurrentHashMap();

    public BinaryComparison() {
        super(COMPARE_FUNCTION, 1);
        BinaryComparison.addComparison(this);
    }

    public static boolean compare(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) throws IOException {
        long l;
        long l2;
        CSPropertySize cSPropertySize = CSPropertySize.getInstance();
        if (comparisonSource.hasProperty(cSPropertySize) && comparisonSource2.hasProperty(cSPropertySize) && (l2 = ((Long)comparisonSource.getPropertyValue(CSPropertySize.getInstance(), new ComparisonSourcePropertyInfo[0])).longValue()) != (l = ((Long)comparisonSource2.getPropertyValue(CSPropertySize.getInstance(), new ComparisonSourcePropertyInfo[0])).longValue()) && l2 != 0L && l != 0L) {
            return false;
        }
        return BinaryComparison.compareContents(comparisonSource, comparisonSource2);
    }

    public static Object[] createInputArgs(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet, String string) {
        if (!comparisonParameterSet.hasParameter(CParameterDetailedBinaryComparison.getInstance())) {
            throw new IllegalArgumentException("Parameter set must include CParameterDetailedBinaryComparison");
        }
        Object[] objectArray = new Object[]{"bindiff", comparisonSource, comparisonSource2, string, comparisonParameterSet.getValue(CParameterDetailedBinaryComparison.getInstance())};
        return objectArray;
    }

    @Override
    public void dispose() {
        super.dispose();
        BinaryComparison.removeComparison(this);
    }

    public boolean compare(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = BinaryComparison.compare(comparisonSource, comparisonSource2);
        }
        catch (IOException iOException) {
            this.handle(iOException, bl);
        }
        return bl2;
    }

    public static boolean compareSize(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        CSPropertySize cSPropertySize = CSPropertySize.getInstance();
        assert (cSPropertySize.isValueType(Long.class));
        assert (comparisonSource.hasProperty(cSPropertySize) && comparisonSource2.hasProperty(cSPropertySize));
        return comparisonSource.getPropertyValue(CSPropertySize.getInstance(), new ComparisonSourcePropertyInfo[0]).equals(comparisonSource2.getPropertyValue(CSPropertySize.getInstance(), new ComparisonSourcePropertyInfo[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareContents(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) throws IOException {
        CSPropertyInputStream cSPropertyInputStream = CSPropertyInputStream.getInstance();
        assert (cSPropertyInputStream.isAssignableFromValueType(InputStream.class));
        assert (comparisonSource.hasProperty(cSPropertyInputStream) && comparisonSource2.hasProperty(cSPropertyInputStream));
        InputStream inputStream = (InputStream)comparisonSource.getPropertyValue(CSPropertyInputStream.getInstance(), new ComparisonSourcePropertyInfo[0]);
        try {
            InputStream inputStream2 = (InputStream)comparisonSource2.getPropertyValue(CSPropertyInputStream.getInstance(), new ComparisonSourcePropertyInfo[0]);
            try {
                boolean bl = LocalIOUtils.contentEquals(inputStream, inputStream2);
                comparisonSource2.refresh();
                return bl;
            }
            catch (Throwable throwable) {
                comparisonSource2.refresh();
                throw throwable;
            }
        }
        finally {
            comparisonSource.refresh();
        }
    }

    public void doRefresh(boolean bl) {
        this.fParameterSet.setValue(CParameterDetailedBinaryComparison.getInstance(), bl);
        this.getMainEventListener().processEvent(new ComparisonEvent(this, CEventDataRefresh.getInstance()));
    }

    public String getReportID() {
        return Integer.toString(this.hashCode());
    }

    private static void addComparison(BinaryComparison binaryComparison) {
        COMPARISONS.put(binaryComparison.getReportID(), binaryComparison);
    }

    private static void removeComparison(BinaryComparison binaryComparison) {
        COMPARISONS.remove(binaryComparison.getReportID());
    }

    public static BinaryComparison getComparison(String string) {
        return COMPARISONS.get(string);
    }

    public static Collection<String> getComparisonCodes() {
        return COMPARISONS.keySet();
    }

    @Override
    protected HTMLReportDecorator createDefaultDecorator() {
        return new BinaryReportDecorator(this.getMainEventListener());
    }

    @Override
    protected void setInputArgs(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet) {
        this.mInputArgs = BinaryComparison.createInputArgs(comparisonSource, comparisonSource2, comparisonParameterSet, this.getReportID());
        this.fParameterSet = comparisonParameterSet;
    }
}

