/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionUtilities;
import com.mathworks.comparisons.compare.concr.BinaryComparison;
import com.mathworks.comparisons.filter.list.ListComparisonFilterState;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.ComparisonSourceUtilities;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.property.CSPropertyComparisonCollection;
import com.mathworks.comparisons.source.property.CSPropertyInputStream;
import com.mathworks.comparisons.source.property.CSPropertyLastModifiedDate;
import com.mathworks.comparisons.source.property.CSPropertyName;
import com.mathworks.comparisons.util.UserCancellationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.SwingUtilities;

public class ComparisonUtilities {
    private ComparisonUtilities() {
    }

    public static void abortIfCancelled(UserInterrupt userInterrupt) throws UserCancellationException {
        if (userInterrupt != null && userInterrupt.isCancelled()) {
            throw new UserCancellationException();
        }
    }

    public static boolean compareFolders(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, UserInterrupt userInterrupt) throws UserCancellationException {
        assert (!SwingUtilities.isEventDispatchThread());
        assert (ComparisonSourceUtilities.isFolder(comparisonSource));
        assert (ComparisonSourceUtilities.isFolder(comparisonSource2));
        try {
            ComparisonSource comparisonSource3;
            CSPropertyComparisonCollection cSPropertyComparisonCollection = CSPropertyComparisonCollection.getInstance();
            assert (comparisonSource.hasProperty(cSPropertyComparisonCollection) && comparisonSource2.hasProperty(cSPropertyComparisonCollection));
            CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders = new CSPInfoIncludeSubFolders(false);
            CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom = new CSPInfoIncludeRelativeFrom("");
            ComparisonCollection comparisonCollection = (ComparisonCollection)comparisonSource.getPropertyValue(cSPropertyComparisonCollection, new ComparisonSourcePropertyInfo[]{cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom});
            ComparisonCollection comparisonCollection2 = (ComparisonCollection)comparisonSource2.getPropertyValue(cSPropertyComparisonCollection, new ComparisonSourcePropertyInfo[]{cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom});
            ComparisonUtilities.abortIfCancelled(userInterrupt);
            Collection<ComparisonSource> collection = comparisonCollection.getComparisonSources();
            Collection<ComparisonSource> collection2 = comparisonCollection2.getComparisonSources();
            ComparisonUtilities.abortIfCancelled(userInterrupt);
            ArrayList<ComparisonSource> arrayList = new ArrayList<ComparisonSource>();
            ArrayList<ComparisonSource> arrayList2 = new ArrayList<ComparisonSource>();
            for (ComparisonSource comparisonSource4 : collection) {
                if (ComparisonUtilities.isFilteredOut(comparisonSource4)) continue;
                arrayList.add(comparisonSource4);
            }
            ComparisonUtilities.abortIfCancelled(userInterrupt);
            for (ComparisonSource comparisonSource4 : collection2) {
                if (ComparisonUtilities.isFilteredOut(comparisonSource4)) continue;
                arrayList2.add(comparisonSource4);
            }
            if (arrayList.size() != arrayList2.size()) {
                return false;
            }
            for (ComparisonSource comparisonSource4 : arrayList) {
                ComparisonUtilities.abortIfCancelled(userInterrupt);
                comparisonSource3 = ComparisonCollectionUtilities.getSourceByName(arrayList2, ComparisonSourceUtilities.getName(comparisonSource4));
                if (comparisonSource3 == null) {
                    return false;
                }
                if (ComparisonSourceUtilities.isFolder(comparisonSource4) ^ ComparisonSourceUtilities.isFolder(comparisonSource3)) {
                    return false;
                }
                if (ComparisonSourceUtilities.isFolder(comparisonSource4) || ComparisonSourceUtilities.getSize(comparisonSource4) == ComparisonSourceUtilities.getSize(comparisonSource3)) continue;
                return false;
            }
            for (ComparisonSource comparisonSource4 : arrayList) {
                boolean bl;
                ComparisonUtilities.abortIfCancelled(userInterrupt);
                comparisonSource3 = ComparisonCollectionUtilities.getSourceByName(collection2, ComparisonSourceUtilities.getName(comparisonSource4));
                assert (comparisonSource3 != null);
                if (ComparisonSourceUtilities.isFolder(comparisonSource3)) {
                    assert (ComparisonSourceUtilities.isFolder(comparisonSource4));
                    bl = ComparisonUtilities.compareFolders(comparisonSource3, comparisonSource4, userInterrupt);
                    if (bl) continue;
                    return false;
                }
                assert (!ComparisonSourceUtilities.isFolder(comparisonSource4));
                bl = ComparisonUtilities.compareFiles(comparisonSource3, comparisonSource4, userInterrupt);
                if (bl) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            ComparisonUtilities.abortIfCancelled(userInterrupt);
            throw runtimeException;
        }
    }

    public static boolean compareFiles(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, UserInterrupt userInterrupt) throws UserCancellationException {
        assert (!ComparisonSourceUtilities.isFolder(comparisonSource));
        assert (!ComparisonSourceUtilities.isFolder(comparisonSource2));
        if (!BinaryComparison.compareSize(comparisonSource, comparisonSource2)) {
            return false;
        }
        CSPropertyInputStream cSPropertyInputStream = CSPropertyInputStream.getInstance();
        if (comparisonSource.hasProperty(cSPropertyInputStream) && comparisonSource2.hasProperty(cSPropertyInputStream)) {
            try {
                return BinaryComparison.compareContents(comparisonSource, comparisonSource2);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return false;
            }
        }
        CSPropertyLastModifiedDate cSPropertyLastModifiedDate = CSPropertyLastModifiedDate.getInstance();
        assert (comparisonSource.hasProperty(cSPropertyLastModifiedDate));
        assert (comparisonSource2.hasProperty(cSPropertyLastModifiedDate));
        Date date = (Date)comparisonSource.getPropertyValue(cSPropertyLastModifiedDate, new ComparisonSourcePropertyInfo[0]);
        Date date2 = (Date)comparisonSource2.getPropertyValue(cSPropertyLastModifiedDate, new ComparisonSourcePropertyInfo[0]);
        return date.equals(date2);
    }

    public static boolean compareFiles(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        try {
            return ComparisonUtilities.compareFiles(comparisonSource, comparisonSource2, null);
        }
        catch (UserCancellationException userCancellationException) {
            throw new RuntimeException("Unexpected cancellation");
        }
    }

    public static boolean isFilteredOut(ComparisonSource comparisonSource) {
        String string = (String)comparisonSource.getPropertyValue(CSPropertyName.getInstance(), new ComparisonSourcePropertyInfo[0]);
        ListComparisonFilterState listComparisonFilterState = new ListComparisonFilterState();
        return listComparisonFilterState.isFilteredOut(string);
    }

    public static interface UserInterrupt {
        public boolean isCancelled();
    }
}

