/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.compare.concr.BinaryComparison;
import com.mathworks.comparisons.compare.impl.CompareInMatlabGenerateHTML;
import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.decorator.htmlreport.HTMLReportDecorator;
import com.mathworks.comparisons.decorator.htmlreport.HTMLTextReportDecorator;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.data.CEventDataRefresh;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.parameter.CParameterColumnsVisible;
import com.mathworks.comparisons.param.parameter.CParameterDetailedBinaryComparison;
import com.mathworks.comparisons.param.parameter.CParameterIgnoreWhitespace;
import com.mathworks.comparisons.param.parameter.CParameterShowDifferencesOnly;
import com.mathworks.comparisons.prefs.ComparisonPrefsManager;
import com.mathworks.comparisons.prefs.preference.CPreferenceColumnsVisible;
import com.mathworks.comparisons.prefs.preference.CPreferenceIgnoreWhitespace;
import com.mathworks.comparisons.prefs.preference.CPreferenceShowDifferencesOnly;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.impl.TextMergeAwareComparisonSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class TextComparison
extends CompareInMatlabGenerateHTML {
    private static final String COMPARE_FUNCTION = "comparisons_private";
    private static final int NUM_OUT_ARGS = 1;
    private HTMLTextReportDecorator fDecoration;
    private ComparisonParameterSet fParameterSet;
    private static final ConcurrentHashMap<String, TextComparison> COMPARISONS = new ConcurrentHashMap();

    public TextComparison() {
        super(COMPARE_FUNCTION, 1);
        TextComparison.addComparison(this);
    }

    protected TextComparison(String string) {
        super(string, 1);
        TextComparison.addComparison(this);
    }

    @Override
    public boolean canClose() {
        boolean bl = super.canClose();
        if (this.fDecoration != null) {
            bl = this.fDecoration.canClose();
        }
        return bl;
    }

    @Override
    public void dispose() {
        super.dispose();
        TextComparison.removeComparison(this);
    }

    @Override
    protected void setInputArgs(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet) {
        ComparisonReportDecorator comparisonReportDecorator;
        this.fParameterSet = comparisonParameterSet;
        if (this.fParameterSet.hasParameter(CParameterDetailedBinaryComparison.getInstance())) {
            this.mInputArgs = BinaryComparison.createInputArgs(comparisonSource, comparisonSource2, comparisonParameterSet, this.getReportID());
            return;
        }
        this.mInputArgs = new Object[7];
        this.mInputArgs[0] = "textdiff";
        this.mInputArgs[1] = comparisonSource;
        this.mInputArgs[2] = comparisonSource2;
        if (!this.fParameterSet.hasParameter(CParameterColumnsVisible.getInstance())) {
            throw new IllegalArgumentException("Parameter set must contain ColumnsVisible parameter");
        }
        if (!this.fParameterSet.hasParameter(CParameterIgnoreWhitespace.getInstance())) {
            throw new IllegalArgumentException("Parameter set must contain IgnoreWhitespace parameter");
        }
        if (!this.fParameterSet.hasParameter(CParameterShowDifferencesOnly.getInstance())) {
            throw new IllegalArgumentException("Parameter set must contain ShowDifferencesOnly parameter");
        }
        Integer n = (Integer)this.fParameterSet.getValue(CParameterColumnsVisible.getInstance());
        this.mInputArgs[3] = n;
        Boolean bl = (Boolean)this.fParameterSet.getValue(CParameterIgnoreWhitespace.getInstance());
        this.mInputArgs[4] = bl;
        Boolean bl2 = (Boolean)this.fParameterSet.getValue(CParameterShowDifferencesOnly.getInstance());
        this.mInputArgs[5] = bl2;
        this.mInputArgs[6] = this.getReportID();
        ComparisonPrefsManager comparisonPrefsManager = ComparisonPrefsManager.getInstance();
        comparisonPrefsManager.setValue(CPreferenceColumnsVisible.getInstance(), n);
        comparisonPrefsManager.setValue(CPreferenceIgnoreWhitespace.getInstance(), bl);
        comparisonPrefsManager.setValue(CPreferenceShowDifferencesOnly.getInstance(), bl2);
        if (this.fWithDisplay && (comparisonReportDecorator = this.getDecorator()) instanceof HTMLTextReportDecorator) {
            ((HTMLTextReportDecorator)comparisonReportDecorator).setComparisonParameters(comparisonParameterSet);
            TextMergeAwareComparisonSource textMergeAwareComparisonSource = TextComparison.wrapComparisonSource(comparisonSource2);
            TextMergeAwareComparisonSource textMergeAwareComparisonSource2 = TextComparison.wrapComparisonSource(comparisonSource);
            ((HTMLTextReportDecorator)comparisonReportDecorator).setComparisonSources(textMergeAwareComparisonSource2, textMergeAwareComparisonSource);
        }
    }

    @Override
    protected HTMLReportDecorator createDefaultDecorator() {
        this.fDecoration = new HTMLTextReportDecorator(this.getEventSupport(), this.getMainEventListener(), this.createColumnsVisibleChangeListener());
        return this.fDecoration;
    }

    @Override
    protected void displayComparisonResult(Object object) throws Exception {
        String string = (String)object;
        boolean bl = string.contains("class=\"binarycomparisonreport\"");
        ComparisonReportDecorator comparisonReportDecorator = this.getDecorator();
        if (comparisonReportDecorator instanceof HTMLTextReportDecorator) {
            ((HTMLTextReportDecorator)comparisonReportDecorator).keepTextComparisonOptionsDisabled(bl);
        }
        super.displayComparisonResult(string);
    }

    protected PropertyChangeListener createColumnsVisibleChangeListener() {
        return new ColumnsVisibleChangeListener();
    }

    private static TextMergeAwareComparisonSource wrapComparisonSource(ComparisonSource comparisonSource) {
        return comparisonSource instanceof TextMergeAwareComparisonSource ? (TextMergeAwareComparisonSource)comparisonSource : new TextMergeAwareComparisonSource(comparisonSource);
    }

    public void doDetailedBinary() {
        this.fParameterSet.setValue(CParameterDetailedBinaryComparison.getInstance(), true);
        this.getMainEventListener().processEvent(new ComparisonEvent(this, CEventDataRefresh.getInstance()));
    }

    public String getReportID() {
        return Integer.toString(this.hashCode());
    }

    private static void addComparison(TextComparison textComparison) {
        COMPARISONS.put(textComparison.getReportID(), textComparison);
    }

    private static void removeComparison(TextComparison textComparison) {
        COMPARISONS.remove(textComparison.getReportID());
    }

    public static TextComparison getComparison(String string) {
        return COMPARISONS.get(string);
    }

    public static Collection<String> getComparisonCodes() {
        return COMPARISONS.keySet();
    }

    private class ColumnsVisibleChangeListener
    implements PropertyChangeListener {
        private ColumnsVisibleChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("value".equals(propertyChangeEvent.getPropertyName())) {
                Integer n = (Integer)propertyChangeEvent.getOldValue();
                Integer n2 = (Integer)propertyChangeEvent.getNewValue();
                Integer n3 = (Integer)TextComparison.this.fParameterSet.getValue(CParameterColumnsVisible.getInstance());
                if (n != 0 && !n2.equals(n3)) {
                    if (n2 > 10000) {
                        n2 = 10000;
                    }
                    TextComparison.this.fParameterSet.setValue(CParameterColumnsVisible.getInstance(), n2);
                    TextComparison.this.getEventSupport().fireComparisonEvent(new ComparisonEvent(this, CEventDataRefresh.getInstance()));
                }
            }
        }
    }
}

