/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport.toolstrip;

import com.mathworks.comparisons.filter.ComparisonFilterStateProvider;
import com.mathworks.comparisons.prefs.ComparisonPrefsManager;
import com.mathworks.comparisons.prefs.preference.CPreferenceColumnsVisible;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripUtils;
import com.mathworks.comparisons.report.toolstrip.FilterToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.TSTabConfigurationFactory;
import com.mathworks.comparisons.report.toolstrip.ToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfigurationFactory;
import com.mathworks.toolstrip.components.TSFormattedTextField;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Disposable;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;

public class TextComparisonViewTabConfigurationFactory
implements ToolstripTabConfigurationFactory {
    private static final TSToolSetContents VIEW_TOOLSET_CONTENTS = TSToolSetContents.readToolSetContents(TextComparisonViewTabConfigurationFactory.class, (String)"resources/TextComparisonViewToolset.xml");
    private static final String RESOURCE_BUNDLE_NAME = "com.mathworks.comparisons.decorator.htmlreport.toolstrip.resources.RES_Text_Comparison_View_Toolstrip";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.comparisons.decorator.htmlreport.toolstrip.resources.RES_Text_Comparison_View_Toolstrip");
    private final PropertyChangeListener fColumnsVisibleChangeListener;
    private final ToolstripTabConfiguration fTabConfiguration;
    private final Collection<ToolSetFactory> fToolSets = new ArrayList<ToolSetFactory>();
    private final Component fHtmlComponent;

    public TextComparisonViewTabConfigurationFactory(ToolstripTabConfiguration toolstripTabConfiguration, PropertyChangeListener propertyChangeListener, ComparisonFilterStateProvider comparisonFilterStateProvider, ActionListener actionListener, Component component) {
        this.fTabConfiguration = toolstripTabConfiguration;
        this.fColumnsVisibleChangeListener = propertyChangeListener;
        this.fHtmlComponent = component;
        this.configureFilterSection(comparisonFilterStateProvider, actionListener);
        this.configureOptionsSection();
    }

    @Override
    public ToolstripTabConfiguration createConfiguration() {
        return new ComparisonToolstripTabConfiguration(this.fTabConfiguration.getTabName(), this.getTSTabConfigurationFactory(), this.getToolSetFactories());
    }

    private TSTabConfigurationFactory getTSTabConfigurationFactory() {
        return new TSTabConfigurationFactory(){

            @Override
            public TSTabConfiguration createConfiguration() {
                TSTabConfiguration tSTabConfiguration = TextComparisonViewTabConfigurationFactory.this.fTabConfiguration.createTSTabConfiguration();
                TSTabConfiguration tSTabConfiguration2 = ComparisonToolstripUtils.readTabConfiguration(TextComparisonViewTabConfigurationFactory.class, "TextComparisonViewTab.xml");
                return ComparisonToolstripUtils.mergeTSTabConfigurations(tSTabConfiguration, tSTabConfiguration2);
            }
        };
    }

    private void configureFilterSection(ComparisonFilterStateProvider comparisonFilterStateProvider, ActionListener actionListener) {
        final TSToolSet tSToolSet = new FilterToolSetFactory(comparisonFilterStateProvider, actionListener).createToolSet();
        this.fToolSets.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private void configureOptionsSection() {
        final TSToolSet tSToolSet = new TSToolSet(VIEW_TOOLSET_CONTENTS);
        final String string = RESOURCE_BUNDLE.getString("Tool.column_width_label.Description");
        tSToolSet.addDecorator("column_width_text_field", new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                if (jComponent instanceof TSFormattedTextField) {
                    TextComparisonViewTabConfigurationFactory.this.decorateFormattedTextField((TSFormattedTextField)jComponent);
                }
                jComponent.setToolTipText(string);
            }
        });
        tSToolSet.addDecorator("column_width_label", new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                jComponent.setToolTipText(string);
            }
        });
        this.fToolSets.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private void decorateFormattedTextField(final TSFormattedTextField tSFormattedTextField) {
        final NumberFormatter numberFormatter = new NumberFormatter();
        numberFormatter.setMinimum(Integer.valueOf(1));
        tSFormattedTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                return numberFormatter;
            }
        });
        tSFormattedTextField.setColumns(4);
        ComparisonPrefsManager comparisonPrefsManager = ComparisonPrefsManager.getInstance();
        tSFormattedTextField.setValue(comparisonPrefsManager.getValue(CPreferenceColumnsVisible.getInstance()));
        tSFormattedTextField.setMaximumSize(tSFormattedTextField.getPreferredSize());
        tSFormattedTextField.setName("NumColumnsTextField");
        tSFormattedTextField.addPropertyChangeListener("value", this.fColumnsVisibleChangeListener);
        tSFormattedTextField.putClientProperty((Object)"disposable", (Object)new Disposable(){

            public void dispose() {
                tSFormattedTextField.removePropertyChangeListener(TextComparisonViewTabConfigurationFactory.this.fColumnsVisibleChangeListener);
            }
        });
        tSFormattedTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    TextComparisonViewTabConfigurationFactory.this.fHtmlComponent.requestFocusInWindow();
                }
            }
        });
        tSFormattedTextField.setMnemonic("C");
    }

    private List<ToolSetFactory> getToolSetFactories() {
        ArrayList<ToolSetFactory> arrayList = new ArrayList<ToolSetFactory>();
        arrayList.addAll(this.fTabConfiguration.getToolSetFactories());
        arrayList.addAll(this.fToolSets);
        return arrayList;
    }
}

