/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.variable.toolstrip;

import com.mathworks.comparisons.decorator.actionid.ActionIDBack;
import com.mathworks.comparisons.decorator.actionid.ActionIDCompareSelected;
import com.mathworks.comparisons.decorator.actionid.ActionIDForward;
import com.mathworks.comparisons.decorator.actionid.ActionIDHelp;
import com.mathworks.comparisons.decorator.impl.ComparisonHelpAction;
import com.mathworks.comparisons.report.ActionManager;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripUtils;
import com.mathworks.comparisons.report.toolstrip.DefaultFindToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultHelpToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultNavigateToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultPrintToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultRefreshToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultSaveAsToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfigurationFactory;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;

public class VariableComparisonTabConfigurationFactory
implements ToolstripTabConfigurationFactory {
    private static final String RESOURCE_BUNDLE_NAME = "com.mathworks.comparisons.decorator.htmlreport.toolstrip.resources.RES_Mat_Comparison_Toolstrip";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.comparisons.decorator.htmlreport.toolstrip.resources.RES_Mat_Comparison_Toolstrip");
    private static final TSToolSetContents TOOLSET_CONTENTS = TSToolSetContents.readToolSetContents(VariableComparisonTabConfigurationFactory.class, (String)"resources/VariableComparisonToolset.xml");
    private final ActionManager fActionManager;
    private final TSTabConfiguration fTSTabConfiguration;
    private final ToolstripTabConfiguration fTabConfiguration;

    public VariableComparisonTabConfigurationFactory(ToolstripTabConfiguration toolstripTabConfiguration, ActionManager actionManager) {
        this.fTabConfiguration = toolstripTabConfiguration;
        this.fActionManager = actionManager;
        this.fTSTabConfiguration = ComparisonToolstripUtils.readTabConfiguration(VariableComparisonTabConfigurationFactory.class, "VariableComparisonTab.xml");
        this.configureDefaults();
        this.configureNavigation();
        this.configureCompareSelectedAction();
        this.configureHelp();
    }

    @Override
    public ToolstripTabConfiguration createConfiguration() {
        return new ComparisonToolstripTabConfiguration(this.fTabConfiguration.getTabName(), this.fTSTabConfiguration, this.getToolSetFactories());
    }

    private void configureDefaults() {
        this.fTabConfiguration.addToolSetFactory(new DefaultRefreshToolSetFactory());
        this.fTabConfiguration.addToolSetFactory(new DefaultSaveAsToolSetFactory());
        this.fTabConfiguration.addToolSetFactory(new DefaultPrintToolSetFactory());
    }

    private void configureNavigation() {
        this.fTabConfiguration.addToolSetFactory(new DefaultFindToolSetFactory());
        final TSToolSet tSToolSet = new DefaultNavigateToolSetFactory().createToolSet();
        tSToolSet.configureAndAdd("previous", (Action)new ChildAction(this.fActionManager.getAction(ActionIDBack.getInstance().getName())));
        tSToolSet.configureAndAdd("next", (Action)new ChildAction(this.fActionManager.getAction(ActionIDForward.getInstance().getName())));
        this.fTabConfiguration.addToolSetFactory(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private void configureCompareSelectedAction() {
        final TSToolSet tSToolSet = new TSToolSet(TOOLSET_CONTENTS);
        TSToolSet tSToolSet2 = this.fTabConfiguration.getTSToolSet("comparison_toolset");
        if (tSToolSet2 == null) {
            return;
        }
        Action action = tSToolSet2.getAction("new");
        if (action != null) {
            tSToolSet.configureAndAdd("new", (Action)new ChildAction(action));
            tSToolSet.configureAndAdd("new_default", (Action)new ChildAction(action));
        }
        tSToolSet.configureAndAdd("new_from_selection", (Action)new ChildAction(this.fActionManager.getAction(ActionIDCompareSelected.getInstance().getName())));
        this.fTabConfiguration.addToolSetFactory(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private void configureHelp() {
        final TSToolSet tSToolSet = new DefaultHelpToolSetFactory().createToolSet();
        ComparisonHelpAction comparisonHelpAction = new ComparisonHelpAction("matlab_env_matcomparison");
        tSToolSet.getContents().configure("help", (Action)((Object)comparisonHelpAction));
        comparisonHelpAction.putValue("ShortDescription", RESOURCE_BUNDLE.getString("Tool.help.Description"));
        tSToolSet.addAction("help", (Action)new ChildAction((Action)((Object)comparisonHelpAction)));
        this.fActionManager.addAction(ActionIDHelp.getInstance().getName(), (Action)((Object)comparisonHelpAction));
        this.fTabConfiguration.addToolSetFactory(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private List<ToolSetFactory> getToolSetFactories() {
        ArrayList<ToolSetFactory> arrayList = new ArrayList<ToolSetFactory>();
        arrayList.addAll(this.fTabConfiguration.getToolSetFactories());
        return arrayList;
    }
}

