/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.gui.dialogs;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.comparisons.gui.dialogs.resources.DialogResources;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.shared.computils.widgets.HTMLMessagePane;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class InternalWarningPanel
implements ComponentBuilder {
    private static final Dimension MINIMUM_WINDOW_SIZE = new Dimension(200, 120);
    private static final int MINIMUM_BUTTON_SIZE = 75;
    private final MJPanel fPanel = new MJPanel();
    private final List<Component> fButtons;
    private final JScrollPane fScrollPane;

    public InternalWarningPanel(String string, OptionListener optionListener) {
        this.fPanel.setName("messagePanel");
        HTMLMessagePane hTMLMessagePane = InternalWarningPanel.createMessagePane(string);
        this.fScrollPane = InternalWarningPanel.createScrollPane((JComponent)hTMLMessagePane);
        this.fButtons = InternalWarningPanel.createButtons(optionListener);
        this.layoutUI();
        this.fPanel.setMinimumSize(MINIMUM_WINDOW_SIZE);
        this.fPanel.setBorder((Border)BorderFactory.createCompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(1, 1, 2, 2)));
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    private static HTMLMessagePane createMessagePane(String string) {
        HTMLMessagePane hTMLMessagePane = new HTMLMessagePane();
        hTMLMessagePane.setWrapping(false);
        hTMLMessagePane.setText(string);
        hTMLMessagePane.setName("messageDialog.editorPane");
        return hTMLMessagePane;
    }

    private static JScrollPane createScrollPane(JComponent jComponent) {
        MJScrollPane mJScrollPane = new MJScrollPane((Component)jComponent);
        mJScrollPane.setOpaque(false);
        mJScrollPane.getViewport().setOpaque(false);
        mJScrollPane.setBorder(null);
        mJScrollPane.setName("messageDialog.scrollPane");
        return mJScrollPane;
    }

    private static List<Component> createButtons(final OptionListener optionListener) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        MJButton mJButton = new MJButton(DialogResources.getString("option.yes", new Object[0]));
        mJButton.setName("option.yes");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                optionListener.selectedOption(Option.YES);
            }
        });
        arrayList.add((Component)mJButton);
        MJButton mJButton2 = new MJButton(DialogResources.getString("option.no", new Object[0]));
        mJButton2.setName("option.no");
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                optionListener.selectedOption(Option.NO);
            }
        });
        arrayList.add((Component)mJButton2);
        return arrayList;
    }

    private void layoutUI() {
        MJLabel mJLabel = new MJLabel((Icon)DialogIcon.WARNING_32x32.getIcon());
        mJLabel.setName("messageDialog.iconLabel");
        GroupLayout groupLayout = new GroupLayout((Container)this.fPanel);
        this.fPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        for (Component component : this.fButtons) {
            sequentialGroup.addComponent(component, 75, -2, -2);
            parallelGroup.addComponent(component, -2, -2, -2);
        }
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent((Component)mJLabel, GroupLayout.Alignment.LEADING).addComponent(this.fScrollPane)).addGroup(parallelGroup));
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout.createSequentialGroup().addComponent((Component)mJLabel, -2, -2, -2).addComponent(this.fScrollPane)).addGroup(sequentialGroup)));
    }

    public static enum Option {
        YES,
        NO;

    }

    public static interface OptionListener {
        public void selectedOption(Option var1);
    }
}

