/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report.toolstrip;

import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import java.io.IOException;
import java.net.URL;
import java.util.zip.DataFormatException;

public class ComparisonToolstripUtils {
    private ComparisonToolstripUtils() {
    }

    public static TSTabConfiguration readTabConfiguration(Class<?> clazz, String string) {
        try {
            return new TSTabConfiguration(SimpleDOMUtils.read((URL)clazz.getResource("resources/" + string)));
        }
        catch (IOException | DataFormatException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static TSTabConfiguration mergeTSTabConfigurations(TSTabConfiguration tSTabConfiguration, TSTabConfiguration tSTabConfiguration2) {
        for (TSTabConfiguration.Section section : tSTabConfiguration2.getSections()) {
            ComparisonToolstripUtils.addSectionToConfiguration(tSTabConfiguration, section);
        }
        return tSTabConfiguration;
    }

    private static void addSectionToConfiguration(TSTabConfiguration tSTabConfiguration, TSTabConfiguration.Section section) {
        TSTabConfiguration.Section section2 = tSTabConfiguration.getSection(section.getName());
        if (section2 != null) {
            tSTabConfiguration.removeSection(section.getName());
        }
        tSTabConfiguration.addSection(section.getName(), section.getLabel(), section.getLayoutType(), section.getPriority());
        for (TSTabConfiguration.Tool tool : section.getTools()) {
            tSTabConfiguration.addTool(section.getName(), new TSTabConfiguration.ToolParameters(tool.getName(), tool.getToolSetName()).setPriority(tool.getPriority()).setOrientation(tool.getOrientation()).setHorizontalAlignment(tool.getHorizontalAlignment()).setVerticalAlignment(tool.getVerticalAlignment()).setVisible(tool.isVisible()).setOptional(tool.isOptional()));
        }
    }

    public static TSTabConfiguration moveSectionToEnd(TSTabConfiguration tSTabConfiguration, String string) {
        TSTabConfiguration.Section section = tSTabConfiguration.getSection(string);
        if (section == null) {
            throw new IllegalArgumentException("Section doesn't exist in configuration");
        }
        tSTabConfiguration.removeSection(string);
        ComparisonToolstripUtils.addSectionToConfiguration(tSTabConfiguration, section);
        return tSTabConfiguration;
    }
}

