/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.mathworks.comparisons.prefs.ComparisonPrefsManager;
import com.mathworks.comparisons.prefs.preference.CPreferenceRecentFiles;
import com.mathworks.comparisons.selection.ListModelPolicy;
import com.mathworks.comparisons.selection.SelectionPolicies;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;

public final class SourceSelectionListModel
extends AbstractListModel {
    private Class<?> mCurrentType;
    private ListModelPolicy mCurrentListPolicy;
    private final SelectionPoliciesRegister mPoliciesRegister;
    private int mMaxSize;
    private final LinkedList<Object> mList = new LinkedList();

    public SourceSelectionListModel(SelectionPoliciesRegister selectionPoliciesRegister, int n) {
        this.mPoliciesRegister = selectionPoliciesRegister;
        this.mMaxSize = n;
        List list = (List)ComparisonPrefsManager.getInstance().getValue(CPreferenceRecentFiles.getInstance());
        for (File file : list) {
            this.mList.add(file);
        }
    }

    public int getMaxSize() {
        return this.mMaxSize;
    }

    @Override
    public int getSize() {
        return this.mList.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.mList.get(n);
    }

    public boolean add(Object object) {
        boolean bl;
        if (object != null && this.canAdd(object)) {
            int n = this.mList.indexOf(object);
            if (n > 0) {
                this.mList.remove(n);
            }
            if (n == -1 && this.getSize() == this.mMaxSize) {
                this.mList.removeLast();
            }
            if (n != 0) {
                this.mList.addFirst(object);
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            bl = true;
            if (n != 0 && n != 1 && object instanceof File) {
                ArrayList<File> arrayList = new ArrayList<File>();
                for (Object e : this.mList) {
                    if (!(e instanceof File)) continue;
                    arrayList.add((File)e);
                }
                ComparisonPrefsManager.getInstance().setValue(CPreferenceRecentFiles.getInstance(), arrayList);
            }
        } else {
            this.fireContentsChanged(this, -1, -1);
            bl = false;
        }
        return bl;
    }

    public void remove(Object object) {
        int n = this.mList.indexOf(object);
        if (n >= 0) {
            this.mList.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }

    private boolean canAdd(Object object) {
        boolean bl = false;
        if (!object.getClass().equals(this.mCurrentType)) {
            this.mCurrentType = object.getClass();
            this.updatePolicy(this.mCurrentType);
        }
        if (this.mCurrentListPolicy != null) {
            bl = this.mCurrentListPolicy.canAdd(object);
        }
        return bl;
    }

    private void updatePolicy(Class<?> clazz) {
        SelectionPolicies selectionPolicies = this.mPoliciesRegister.getPolicies(clazz);
        this.mCurrentListPolicy = selectionPolicies != null ? selectionPolicies.createListModelPolicy() : null;
    }
}

