/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionFactory;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourceProperty;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.property.CSPropertyName;
import com.mathworks.comparisons.source.property.CSPropertyReadableLocation;
import com.mathworks.comparisons.source.type.CSTypeCollectionFile;
import com.mathworks.comparisons.source.type.CSTypeFile;
import com.mathworks.comparisons.util.ResourceManager;
import java.io.File;

public class FileSourceCollection
extends ComparisonSourceImpl {
    private final Class<? extends ComparisonCollection> fCollectionClass;
    private final ComparisonSource fFileSource;

    public FileSourceCollection(ComparisonSource comparisonSource, Class<? extends ComparisonCollection> clazz) {
        super(new CSTypeCollectionFile());
        FileSourceCollection.throwExceptionIfAllPropertiesAreNotFound(comparisonSource);
        this.fFileSource = comparisonSource;
        this.fCollectionClass = clazz;
    }

    @Override
    public Object getPropertyValue(ComparisonSourceProperty comparisonSourceProperty, ComparisonSourcePropertyInfo ... comparisonSourcePropertyInfoArray) {
        this.throwExceptionIfSourceDoesNotHaveProperty(comparisonSourceProperty);
        Object object = this.fFileSource.hasProperty(comparisonSourceProperty) ? this.fFileSource.getPropertyValue(comparisonSourceProperty, comparisonSourcePropertyInfoArray) : this.getLocalPropertyValue(this, comparisonSourceProperty, comparisonSourcePropertyInfoArray);
        return object;
    }

    public Class<? extends ComparisonCollection> getCollectionClass() {
        return this.fCollectionClass;
    }

    @Override
    public void refresh() {
        this.fFileSource.refresh();
    }

    @Override
    public synchronized void dispose() {
        this.fFileSource.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private ComparisonCollection getComparisonCollection(CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders, CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom) {
        CSPropertyName cSPropertyName = CSPropertyName.getInstance();
        CSPropertyReadableLocation cSPropertyReadableLocation = CSPropertyReadableLocation.getInstance();
        assert (this.fFileSource.hasProperty(cSPropertyName) && this.fFileSource.hasProperty(cSPropertyReadableLocation));
        assert (cSPropertyName.isValueType(String.class));
        assert (cSPropertyReadableLocation.isValueType(File.class));
        String string = (String)this.fFileSource.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
        File file = (File)this.fFileSource.getPropertyValue(cSPropertyReadableLocation, new ComparisonSourcePropertyInfo[0]);
        return ComparisonCollectionFactory.createFromFile(this.fCollectionClass, string, file, cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom);
    }

    private static void throwExceptionIfAllPropertiesAreNotFound(ComparisonSource comparisonSource) throws IllegalArgumentException {
        CSTypeFile cSTypeFile = new CSTypeFile();
        if (!comparisonSource.hasProperties(cSTypeFile.getProperties()) || !cSTypeFile.hasProperties(comparisonSource.getProperties())) {
            String string;
            CSPropertyName cSPropertyName = CSPropertyName.getInstance();
            if (comparisonSource.hasProperty(cSPropertyName) && cSPropertyName.getValueType().equals(String.class)) {
                String string2 = (String)comparisonSource.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
                string = ResourceManager.format("exception.notrecognizingallproperties", string2, CSTypeFile.class.getName());
            } else {
                string = ResourceManager.format("exception.notrecognizingallproperties", "Anonymous ComparisonSource", CSTypeFile.class.getName());
            }
            throw new IllegalArgumentException(string);
        }
    }
}

