/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionFactory;
import com.mathworks.comparisons.collection.impl.ZipFileCollection;
import com.mathworks.comparisons.source.ComparisonSourceType;
import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.type.CSTypeFile;
import com.mathworks.comparisons.source.type.CSTypeFolder;
import com.mathworks.comparisons.util.LocalIOUtils;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.Validate;

public class ZipEntrySource
extends ComparisonSourceImpl {
    private final File fFile;
    private final String fFileName;
    private final ZipEntry fEntry;
    private final String fEntryName;
    private volatile ZipFile fZipFile = null;
    private volatile File fTempFile = null;
    private volatile InputStream fInputStream = null;

    public ZipEntrySource(File file, String string, ZipEntry zipEntry) {
        this(file, string, zipEntry, zipEntry.getName());
    }

    public ZipEntrySource(File file, String string, ZipEntry zipEntry, String string2) {
        super(ZipEntrySource.getComparisonSourceType(zipEntry));
        Validate.notNull((Object)file);
        this.fFile = file;
        this.fFileName = string;
        this.fEntry = zipEntry;
        this.fEntryName = string2;
    }

    private static ComparisonSourceType getComparisonSourceType(ZipEntry zipEntry) {
        Validate.notNull((Object)zipEntry);
        return zipEntry.isDirectory() ? new CSTypeFolder() : new CSTypeFile();
    }

    public static ZipEntrySource createFolderPlaceholder(File file, String string, String string2) {
        ZipEntry zipEntry = new ZipEntry(string);
        return new ZipEntrySource(file, string, zipEntry, string2);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public void refresh() {
        this.dispose();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.fZipFile != null) {
            try {
                this.fZipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fZipFile = null;
            this.fInputStream = null;
        }
        if (this.fTempFile != null) {
            this.fTempFile.delete();
            this.fTempFile = null;
        }
    }

    private String getName() {
        return this.fEntryName;
    }

    private long getSize() {
        return this.fEntry.getSize();
    }

    private Date getLastModifiedDate() {
        return new Date(this.fEntry.getTime());
    }

    private String getTitle() {
        return LocalIOUtils.truncatePathName(this.fEntry.getName());
    }

    private String getShortTitle() {
        String string = this.fEntry.getName();
        if (this.fEntry.isDirectory()) {
            return LocalIOUtils.getFileName(string.substring(0, string.length() - 1)) + '/';
        }
        return LocalIOUtils.getFileName(string);
    }

    private synchronized File getReadableLocation() {
        if (this.fTempFile == null) {
            String string = this.fEntry.getName().replace(File.separator, "_");
            if (!"/".equals(File.separator)) {
                string = string.replace('/', '_');
            }
            try {
                this.fTempFile = LocalIOUtils.createTempFile("zip_entry_", string);
                LocalIOUtils.copyStreamToFile(this.getInputStream(), this.fTempFile);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
        return this.fTempFile;
    }

    private String getAbsoluteName() {
        return ResourceManager.format("zipentrysource.absolutename", this.fEntry.getName(), this.fFile.getAbsolutePath());
    }

    private synchronized InputStream getInputStream() {
        this.initZipFile();
        if (this.fInputStream == null) {
            try {
                this.fInputStream = this.fZipFile.getInputStream(this.fEntry);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
        return this.fInputStream;
    }

    private ComparisonCollection getComparisonCollection(CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders, CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom) {
        assert (this.fEntry.isDirectory());
        CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom2 = new CSPInfoIncludeRelativeFrom(cSPInfoIncludeRelativeFrom.getValue() + this.fEntry.getName());
        return ComparisonCollectionFactory.createFromFile(ZipFileCollection.class, this.fFileName, this.fFile, cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom2);
    }

    private void initZipFile() {
        if (this.fZipFile == null) {
            try {
                this.fZipFile = new ZipFile(this.fFile);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
    }
}

