/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class Scroller
extends JPanel
implements AdjustmentListener,
ObjectPainter,
Movable {
    private DocView I;
    private ObjectBox OEAB;
    private JScrollBar add;
    private JScrollBar addAdjustmentListener;
    private View checkAwtTree;

    Scroller(DocView docView) {
        this.I = docView;
        this.setLayout(new BorderLayout());
        this.add = new JScrollBar(0);
        this.addAdjustmentListener = new JScrollBar(1);
        this.checkAwtTree = new View(this, docView);
        this.add((Component)this.add, "South");
        this.add((Component)this.addAdjustmentListener, "East");
        this.add((Component)this.checkAwtTree, "Center");
        this.add.addAdjustmentListener(this);
        this.addAdjustmentListener.addAdjustmentListener(this);
        this.setOpaque(false);
    }

    Container getView() {
        return this.checkAwtTree;
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void doLayout() {
        super.doLayout();
        ScrollBox scrollBox = this.getScrollBox();
        if (scrollBox != null) {
            Dimension dimension = this.checkAwtTree.getSize();
            scrollBox.layoutScrollable(dimension.width, dimension.height);
            int n = scrollBox.getScrollableWidth();
            int n2 = scrollBox.getScrollableHeight();
            this.add.setValues(0, dimension.width, 0, n);
            this.addAdjustmentListener.setValues(0, dimension.height, 0, n2);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        ScrollBox scrollBox = this.getScrollBox();
        if (scrollBox != null) {
            scrollBox.setScrollPosition(this.getScrollX(), this.getScrollY());
        }
        this.checkAwtTree.syncChildren();
        this.checkAwtTree.repaint();
    }

    ScrollBox getScrollBox() {
        ObjectBox objectBox = this.getBox();
        if (objectBox != null) {
            return objectBox.getScrollBox();
        }
        return null;
    }

    int getScrollX() {
        return this.add.getValue();
    }

    int getScrollY() {
        return this.addAdjustmentListener.getValue();
    }

    public void setBox(ObjectBox objectBox) {
        this.OEAB = objectBox;
        this.I.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.OEAB;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
    }

    private static class View
    extends JPanel {
        private Scroller I;
        private DocView OEAB;

        View(Scroller scroller, DocView docView) {
            this.I = scroller;
            this.OEAB = docView;
            this.setLayout(null);
            this.enableEvents(60L);
            this.setOpaque(false);
        }

        public void doLayout() {
            super.doLayout();
            this.syncChildren();
        }

        void syncChildren() {
            Object object = this.getTreeLock();
            synchronized (object) {
                int n = this.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Movable movable;
                    ObjectBox objectBox;
                    Component component = this.getComponent(n2);
                    if (component instanceof Movable && (objectBox = (movable = (Movable)((Object)component)).getBox()) != null) {
                        Point point = new Point(0, 0);
                        objectBox.findAbsolutePosition(point);
                        int n3 = point.x - this.I.getScrollX();
                        int n4 = point.y - this.I.getScrollY();
                        movable.syncDom(n3, n4, objectBox.checkIfVisible());
                    }
                    ++n2;
                }
            }
        }

        public void paintComponent(Graphics graphics) {
            ScrollBox scrollBox = this.I.getScrollBox();
            if (scrollBox != null) {
                int n = this.I.getScrollX();
                int n2 = this.I.getScrollY();
                graphics.translate(-n, -n2);
                scrollBox.paintScrollable(graphics);
                graphics.translate(n, n2);
            }
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (this.OEAB.onComponentEvent(this, aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

