/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.lmlogin;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.lmlogin.EntitlementComponent;
import com.mathworks.lmlogin.LmLoginResourceKey;
import com.mathworks.webservices.mls.model.Entitlement;
import java.awt.Dimension;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

final class EntitlementDialogCreator {
    private String selectedEntitlement = "";
    private final List<Entitlement> entitlementList;
    private final Dimension dimension;

    EntitlementDialogCreator(List<Entitlement> list, Dimension dimension) {
        this.entitlementList = list;
        this.dimension = dimension;
    }

    private void createDialog(List<Entitlement> list) {
        EntitlementComponent entitlementComponent = new EntitlementComponent(list);
        JOptionPane jOptionPane = new JOptionPane(entitlementComponent.getEntitlementPanel(), -1, 2);
        JDialog jDialog = jOptionPane.createDialog(LmLoginResourceKey.ENTILTEMENTS_TITLE.getString(new Object[0]));
        jDialog.setPreferredSize(this.dimension);
        jDialog.setSize(this.dimension);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(ApplicationIcon.MATLAB.getIcon().getImage());
        arrayList.add(ApplicationIcon.MATLAB_32x32.getIcon().getImage());
        arrayList.add(ApplicationIcon.MATLAB_48x48.getIcon().getImage());
        jDialog.setIconImages(arrayList);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object.equals(0)) {
            this.selectedEntitlement = entitlementComponent.getSelectedEntitlement();
        }
    }

    boolean hasSelectedEntitlement() {
        return !this.selectedEntitlement.isEmpty();
    }

    String getSelectedEntitlement() {
        return this.selectedEntitlement;
    }

    void display() throws InvocationTargetException, InterruptedException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EntitlementDialogCreator.this.createDialog(EntitlementDialogCreator.this.entitlementList);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }
}

