/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing.model.table;

import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.Paragraph;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.ParagraphBuilder;
import org.openxml4j.document.wordprocessing.UnderlineStyle;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.model.table.CellWidth;
import org.openxml4j.document.wordprocessing.model.table.TableCellSize;

public class TableCell {
    private static Logger logger = Logger.getLogger((String)"org.openxml4j");
    private String value = null;
    private String cellBackgroundColor = null;
    private TableCellSize cellSize = new TableCellSize();
    private CellWidth cellWitdh = new CellWidth();
    private ParagraphBuilder paraBuilder = new ParagraphBuilder();

    public TableCell(String value, ParagraphAlignment alignment) {
        this.value = value;
        this.paraBuilder.setAlignment(alignment);
    }

    public TableCell(String value, boolean isBold, boolean isItalic, UnderlineStyle isUnderline, ParagraphAlignment alignment) {
        this.value = value;
        this.paraBuilder.setBold(isBold);
        this.paraBuilder.setItalic(isItalic);
        this.paraBuilder.setUnderline(isUnderline);
        this.paraBuilder.setAlignment(alignment);
    }

    public TableCell(CellWidth p_cellWidth) {
        this.cellWitdh = p_cellWidth;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private Element addCellProperties() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Element cellProperties = factory.createElement(new QName("tcPr", WordDocument.namespaceWord));
        if (this.cellBackgroundColor != null) {
            this.addBackgroundProperties(cellProperties);
        }
        this.cellWitdh.build(cellProperties);
        this.cellSize.build(cellProperties);
        return cellProperties;
    }

    private void addBackgroundProperties(Element cellProperties) {
        Element cellBackground = cellProperties.addElement(new QName("shd", WordDocument.namespaceWord));
        cellBackground.addAttribute(new QName("fill", WordDocument.namespaceWord), this.cellBackgroundColor);
    }

    public Element build() {
        if (this.value != null) {
            return this.buildXmlForCell(this.value);
        }
        logger.warn((Object)"cell with null value, empty string assumed");
        return this.buildXmlForCell("");
    }

    private Element buildXmlForCell(String valueInCell) {
        List<Paragraph> paraList = this.paraBuilder.newParagraphs(valueInCell);
        DocumentFactory factory = DocumentFactory.getInstance();
        Element cellAsXml = factory.createElement(new QName("tc", WordDocument.namespaceWord));
        cellAsXml.add(this.addCellProperties());
        for (Paragraph para : paraList) {
            cellAsXml.add(para.build());
        }
        return cellAsXml;
    }

    public String getCellBackgroundColor() {
        return this.cellBackgroundColor;
    }

    public void setCellBackgroundColor(String cellBackgroundColor) {
        this.cellBackgroundColor = cellBackgroundColor;
    }

    public void setBold(boolean isBold) {
        this.paraBuilder.setBold(isBold);
    }

    public void setItalic(boolean isItalic) {
        this.paraBuilder.setItalic(isItalic);
    }

    public void setUnderline(UnderlineStyle isUnderline) {
        this.paraBuilder.setUnderline(isUnderline);
    }

    public void setAlignment(ParagraphAlignment alignment) {
        this.paraBuilder.setAlignment(alignment);
    }

    public void setCellSize(TableCellSize cellsize) {
        this.cellSize = cellsize;
    }
}

