/*
 * Decompiled with CFR 0.152.
 */
package ice.cert;

import cryptix.provider.rsa.CryptixRSAPublicKeyPatch;
import cryptix.provider.rsa.RawRSAPublicKey;
import ice.cert.CertificateException;
import ice.cert.CertificateParsingException;
import ice.cert.DERUtil;
import ice.cert.DERValue;
import ice.cert.OID;
import ice.cert.X500Name;
import ice.cert.X509Certificate;
import ice.cryptix.Base64;
import ice.crypto.DHParameterSpec;
import ice.crypto.DHPublicKey;
import ice.crypto.DSAParams;
import ice.crypto.DSAPublicKeyImpl;
import ice.crypto.ICEsoft;
import ice.debug.Debug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class X509CertificateFactory {
    public X509Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new CertificateParsingException("I/O error while parsing: " + iOException.getMessage());
        }
        return this.addElement(byteArrayOutputStream.toByteArray());
    }

    public X509Certificate[] generateCertificates(InputStream inputStream) throws CertificateException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new CertificateParsingException("I/O error while parsing: " + iOException.getMessage());
        }
        return this.I(byteArrayOutputStream.toByteArray());
    }

    public Provider getProvider() {
        return new ICEsoft();
    }

    public String getType() {
        return "X.509";
    }

    private X509Certificate[] I(byte[] byArray) throws CertificateParsingException {
        if (Base64.isBase64(byArray)) {
            try {
                byArray = Base64.decode(Base64.removeMarkers(byArray));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertificateParsingException("Wrong base64 encoding: " + illegalArgumentException.getMessage());
            }
        }
        DERValue dERValue = new DERValue();
        DERUtil.decode(byArray, dERValue, 1);
        DERValue dERValue2 = new DERValue();
        byte[] byArray2 = DERUtil.decode((byte[])dERValue.getData(), dERValue2);
        if (dERValue2.getTag() == 1) {
            return this.OEAB(byArray);
        }
        if (dERValue2.getTag() == 3 && ((OID)dERValue2.getData()).oidID == 102) {
            DERValue dERValue3 = new DERValue();
            DERUtil.decode(byArray2, dERValue3, 0);
            DERUtil.decode((byte[])dERValue3.getData(), dERValue3);
            DERValue dERValue4 = new DERValue();
            byArray2 = DERUtil.decode((byte[])dERValue3.getData(), dERValue4, 7, (byte)2);
            byArray2 = DERUtil.decode(byArray2, dERValue4, 2, (byte)2);
            DERValue dERValue5 = new DERValue();
            byArray2 = DERUtil.decode(byArray2, dERValue5, 1, (byte)2);
            DERValue dERValue6 = new DERValue();
            DERUtil.decode((byte[])dERValue5.getData(), dERValue6, 3);
            if (((OID)dERValue6.getData()).oidID != 101) {
                throw new CertificateParsingException("Wrong data or encoding not supported.");
            }
            DERValue dERValue7 = new DERValue();
            DERUtil.decode(byArray2, dERValue7);
            if (dERValue7.getTag() != 0 && dERValue7.getTagNumber() != 0) {
                return new X509Certificate[0];
            }
            if (dERValue7.getLength() == 0) {
                return new X509Certificate[0];
            }
            return this.OEAB((byte[])dERValue7.getData());
        }
        if (dERValue2.getTag() == 3 && ((OID)dERValue2.getData()).oidID == 92) {
            DERValue dERValue8 = new DERValue();
            DERUtil.decode(byArray2, dERValue8, 0);
            if (dERValue8.getTagNumber() != 0) {
                throw new CertificateParsingException();
            }
            DERUtil.decode((byte[])dERValue8.getData(), dERValue8, 1);
            if (dERValue8.getLength() == 0) {
                return new X509Certificate[0];
            }
            return this.OEAB((byte[])dERValue8.getData());
        }
        throw new CertificateParsingException("Wrong data or encoding not supported.");
    }

    private X509Certificate[] OEAB(byte[] byArray) throws CertificateParsingException {
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        DERValue dERValue = new DERValue();
        while (byArray.length > 0) {
            byte[] byArray2 = DERUtil.getFirst(byArray);
            vector.addElement(this.addElement(byArray2));
            byArray = DERUtil.decode(byArray, dERValue, 1);
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            x509CertificateArray[n++] = (X509Certificate)enumeration.nextElement();
        }
        return x509CertificateArray;
    }

    private X509Certificate addElement(byte[] byArray) throws CertificateParsingException {
        DERValue dERValue;
        if (Base64.isBase64(byArray)) {
            try {
                byArray = Base64.decode(Base64.removeMarkers(byArray));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertificateParsingException("Wrong base64 encoding: " + illegalArgumentException.getMessage());
            }
        }
        X509Certificate x509Certificate = new X509Certificate();
        DERValue dERValue2 = new DERValue();
        byte[] byArray2 = DERUtil.decode(byArray, dERValue2, 1);
        x509Certificate.encoded = new byte[byArray.length - byArray2.length];
        System.arraycopy(byArray, 0, x509Certificate.encoded, 0, x509Certificate.encoded.length);
        DERValue dERValue3 = new DERValue();
        byte[] byArray3 = DERUtil.getFirst((byte[])dERValue2.getData());
        x509Certificate.tbsCertificate = byArray3;
        byte[] byArray4 = DERUtil.decode((byte[])dERValue2.getData(), dERValue3, 1, (byte)2);
        DERValue dERValue4 = new DERValue();
        byArray4 = DERUtil.decode(byArray4, dERValue4, 1, (byte)2);
        DERValue dERValue5 = new DERValue();
        byte[] byArray5 = DERUtil.decode((byte[])dERValue4.getData(), dERValue5, 3);
        x509Certificate.sigOID = (OID)dERValue5.getData();
        x509Certificate.sigAlgParams = (byte[])(byArray5.length > 0 ? byArray5 : null);
        DERValue dERValue6 = new DERValue();
        DERUtil.decode(byArray4, dERValue6, 4, (byte)1);
        byte[] byArray6 = ((BigInteger)dERValue6.getData()).toByteArray();
        byte[] byArray7 = new byte[byArray6.length + 1];
        System.arraycopy(byArray6, 0, byArray7, 1, byArray6.length);
        x509Certificate.signature = byArray7;
        DERValue dERValue7 = new DERValue();
        byte[] byArray8 = DERUtil.decode((byte[])dERValue3.getData(), dERValue7, (byte)2);
        if (dERValue7.getDerClass() == 2 && dERValue7.getTagNumber() == 0) {
            dERValue = new DERValue();
            DERUtil.decode((byte[])dERValue7.getData(), dERValue, 7, (byte)1);
            x509Certificate.version = 1 + ((BigInteger)dERValue.getData()).intValue();
            byArray8 = DERUtil.decode(byArray8, dERValue7, (byte)2);
        } else {
            x509Certificate.version = 1;
            if (dERValue7.getTag() != 7) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(7) + ") in certificate.");
            }
        }
        x509Certificate.serialNumber = (BigInteger)dERValue7.getData();
        dERValue = new DERValue();
        byArray8 = DERUtil.decode(byArray8, dERValue, 1, (byte)2);
        if (!dERValue.equals(dERValue4)) {
            throw new CertificateParsingException("signature algorithms inside and outside certificate data don't match.");
        }
        DERValue dERValue8 = new DERValue();
        byArray8 = DERUtil.decode(byArray8, dERValue8, 1, (byte)2);
        x509Certificate.issuerDN = X500Name.parseName((byte[])dERValue8.getData());
        DERValue dERValue9 = new DERValue();
        byArray8 = DERUtil.decode(byArray8, dERValue9, 1, (byte)2);
        DERValue dERValue10 = new DERValue();
        byte[] byArray9 = DERUtil.decode((byte[])dERValue9.getData(), dERValue10, 8, (byte)2);
        x509Certificate.notBefore = (Date)dERValue10.getData();
        DERValue dERValue11 = new DERValue();
        DERUtil.decode(byArray9, dERValue11, 8, (byte)1);
        x509Certificate.notAfter = (Date)dERValue11.getData();
        DERValue dERValue12 = new DERValue();
        byArray8 = DERUtil.decode(byArray8, dERValue12, 1, (byte)2);
        x509Certificate.subjectDN = X500Name.parseName((byte[])dERValue12.getData());
        DERValue dERValue13 = new DERValue();
        byArray8 = DERUtil.decode(byArray8, dERValue13, 1);
        x509Certificate.publicKey = this.append((byte[])dERValue13.getData());
        block10: while (byArray8 != null && byArray8.length > 0) {
            DERValue dERValue14 = new DERValue();
            byArray8 = DERUtil.decode(byArray8, dERValue14);
            byte[] byArray10 = (byte[])dERValue14.getData();
            DERValue dERValue15 = new DERValue();
            byArray10 = DERUtil.decode(byArray10, dERValue15, 1, (byte)1);
            DERValue dERValue16 = new DERValue();
            byArray10 = DERUtil.decode((byte[])dERValue15.getData(), dERValue16);
            DERValue dERValue17 = new DERValue();
            byArray10 = DERUtil.decode((byte[])dERValue16.getData(), dERValue17, 3, (byte)2);
            int n = ((OID)dERValue17.getData()).oidID;
            switch (n) {
                case 14: {
                    Debug.trace((String)"subject key id");
                    break;
                }
                case 15: {
                    Debug.trace((String)"Key usage");
                    break;
                }
                case 19: {
                    try {
                        DERValue dERValue18;
                        DERValue dERValue19 = new DERValue();
                        byArray10 = DERUtil.decode(byArray10, dERValue19);
                        DERValue dERValue20 = null;
                        if (dERValue19.getTag() == 5) {
                            dERValue18 = new DERValue();
                            byArray10 = DERUtil.decode((byte[])dERValue19.getData(), dERValue18);
                            dERValue20 = new DERValue();
                            if (((byte[])dERValue18.getData()).length == 0) {
                                x509Certificate.setBasicConstraints(-1);
                                break;
                            }
                            byArray10 = DERUtil.decode((byte[])dERValue18.getData(), dERValue20, 10, (byte)0);
                        } else {
                            dERValue20 = dERValue19;
                        }
                        if (((Boolean)dERValue20.getData()).booleanValue()) {
                            dERValue18 = new DERValue();
                            byArray10 = DERUtil.decode(byArray10, dERValue18, (byte)1);
                            DERValue dERValue21 = null;
                            if (dERValue18.getTag() == 1) {
                                dERValue20 = new DERValue();
                                byArray10 = DERUtil.decode((byte[])dERValue18.getData(), dERValue20, 10, (byte)0);
                                if (((Boolean)dERValue20.getData()).booleanValue()) {
                                    dERValue21 = new DERValue();
                                    byArray10 = DERUtil.decode((byte[])dERValue18.getData(), dERValue21, 7, (byte)1);
                                }
                            } else {
                                dERValue21 = dERValue18;
                            }
                            int n2 = ((BigInteger)dERValue21.getData()).intValue();
                            x509Certificate.setBasicConstraints(n2);
                            break;
                        }
                        x509Certificate.setBasicConstraints(-1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue block10;
                }
                case 35: {
                    Debug.trace((String)"object id");
                    break;
                }
                default: {
                    Debug.trace((String)"unsupported extension");
                }
            }
        }
        return x509Certificate;
    }

    private PublicKey append(byte[] byArray) throws CertificateParsingException {
        DERValue dERValue = new DERValue();
        byte[] byArray2 = DERUtil.decode(byArray, dERValue, 1, (byte)2);
        DERValue dERValue2 = new DERValue();
        byte[] byArray3 = DERUtil.decode((byte[])dERValue.getData(), dERValue2, 3);
        DERValue dERValue3 = null;
        if (byArray3.length != 0) {
            dERValue3 = new DERValue();
            DERUtil.decode(byArray3, dERValue3, (byte)1);
        }
        DERValue dERValue4 = new DERValue();
        DERUtil.decode(byArray2, dERValue4, 4, (byte)1);
        byte[] byArray4 = ((BigInteger)dERValue4.getData()).toByteArray();
        int n = ((OID)dERValue2.getData()).oidID;
        if (n == 21) {
            DERValue dERValue5 = new DERValue();
            DERUtil.decode(byArray4, dERValue5, 1, (byte)1);
            DERValue dERValue6 = new DERValue();
            byte[] byArray5 = DERUtil.decode((byte[])dERValue5.getData(), dERValue6, 7, (byte)2);
            DERValue dERValue7 = new DERValue();
            DERUtil.decode(byArray5, dERValue7, 7, (byte)1);
            return new CryptixRSAPublicKeyPatch(new RawRSAPublicKey((BigInteger)dERValue6.getData(), (BigInteger)dERValue7.getData()));
        }
        if (n == 22) {
            Object object;
            if (dERValue3 != null && dERValue3.getTag() != 1) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(1) + ") in certificate.");
            }
            DERValue dERValue8 = null;
            DERValue dERValue9 = null;
            DERValue dERValue10 = null;
            if (dERValue3 != null) {
                dERValue8 = new DERValue();
                object = DERUtil.decode((byte[])dERValue3.getData(), dERValue8, 7, (byte)2);
                dERValue9 = new DERValue();
                object = DERUtil.decode((byte[])object, dERValue9, 7, (byte)2);
                dERValue10 = new DERValue();
                DERUtil.decode((byte[])object, dERValue10, 7, (byte)1);
            }
            object = new DERValue();
            DERUtil.decode(byArray4, (DERValue)object, 7, (byte)1);
            DSAParams dSAParams = dERValue3 != null ? new DSAParams((BigInteger)dERValue8.getData(), (BigInteger)dERValue9.getData(), (BigInteger)dERValue10.getData()) : new DSAParams(null, null, null);
            return new DSAPublicKeyImpl((BigInteger)((DERValue)object).getData(), dSAParams, byArray4, "X.509");
        }
        if (n == 23) {
            if (dERValue3.getTag() != 1) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(1) + ") in certificate.");
            }
            DERValue dERValue11 = new DERValue();
            byte[] byArray6 = DERUtil.decode((byte[])dERValue3.getData(), dERValue11, 7, (byte)2);
            DERValue dERValue12 = new DERValue();
            byArray6 = DERUtil.decode(byArray6, dERValue12, 7, (byte)2);
            DERValue dERValue13 = new DERValue();
            DERUtil.decode(byArray4, dERValue13, 7, (byte)1);
            DHParameterSpec dHParameterSpec = new DHParameterSpec((BigInteger)dERValue11.getData(), (BigInteger)dERValue12.getData());
            return new DHPublicKey((BigInteger)dERValue13.getData(), dHParameterSpec);
        }
        return null;
    }
}

