/*
 * Decompiled with CFR 0.152.
 */
package ice.crypto;

import ice.cert.CertificateException;
import ice.cert.X509Certificate;
import ice.crypto.KeyStoreEntry;
import ice.crypto.KeyStoreException;
import ice.crypto.UnrecoverableKeyException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class KeyStore
implements Cloneable {
    private Hashtable OEAB;
    private boolean append = false;
    private static final byte[] arraycopy = "ICEKeyStore1.0".getBytes();

    public final String getType() {
        return "IceKeyStore";
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        KeyStoreEntry keyStoreEntry = (KeyStoreEntry)this.OEAB.get(string);
        return keyStoreEntry == null || keyStoreEntry.encryptedKey == null ? null : this.append(keyStoreEntry.encryptedKey, cArray);
    }

    public final X509Certificate[] getCertificateChain(String string) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        KeyStoreEntry keyStoreEntry = (KeyStoreEntry)this.OEAB.get(string);
        return keyStoreEntry == null || keyStoreEntry.certChain == null ? null : (X509Certificate[])keyStoreEntry.certChain.clone();
    }

    public final X509Certificate getCertificate(String string) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        KeyStoreEntry keyStoreEntry = (KeyStoreEntry)this.OEAB.get(string);
        return keyStoreEntry == null ? null : keyStoreEntry.cert;
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        KeyStoreEntry keyStoreEntry = (KeyStoreEntry)this.OEAB.get(string);
        return keyStoreEntry == null ? null : keyStoreEntry.creationDate;
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, X509Certificate[] x509CertificateArray) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        if (key instanceof PrivateKey && (x509CertificateArray == null || x509CertificateArray.length == 0)) {
            throw new IllegalArgumentException("Private key must be accompanied by certificate chain");
        }
        KeyStoreEntry keyStoreEntry = new KeyStoreEntry();
        if (x509CertificateArray != null) {
            keyStoreEntry.certChain = (X509Certificate[])x509CertificateArray.clone();
        }
        keyStoreEntry.creationDate = new Date();
        keyStoreEntry.encryptedKey = this.OEAB(key, cArray);
        this.OEAB.put(string, keyStoreEntry);
    }

    public final void setKeyEntry(String string, byte[] byArray, X509Certificate[] x509CertificateArray) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        throw new IllegalArgumentException("This method is not implemented !");
    }

    public final void setCertificateEntry(String string, X509Certificate x509Certificate) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        KeyStoreEntry keyStoreEntry = new KeyStoreEntry();
        keyStoreEntry.cert = x509Certificate;
        keyStoreEntry.creationDate = new Date();
        this.OEAB.put(string, keyStoreEntry);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.OEAB.remove(string);
    }

    public final Enumeration aliases() throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.OEAB.keys();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.OEAB.containsKey(string);
    }

    public final int size() throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.OEAB.size();
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        KeyStoreEntry keyStoreEntry = (KeyStoreEntry)this.OEAB.get(string);
        return keyStoreEntry != null && keyStoreEntry.encryptedKey != null;
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        KeyStoreEntry keyStoreEntry = (KeyStoreEntry)this.OEAB.get(string);
        return keyStoreEntry != null && keyStoreEntry.cert != null;
    }

    public final String getCertificateAlias(X509Certificate x509Certificate) throws KeyStoreException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        Enumeration enumeration = this.OEAB.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            KeyStoreEntry keyStoreEntry = (KeyStoreEntry)this.OEAB.get(string);
            if (keyStoreEntry != null && keyStoreEntry.cert != null && keyStoreEntry.cert.equals(x509Certificate)) {
                return string;
            }
            if (keyStoreEntry == null || keyStoreEntry.certChain == null || keyStoreEntry.certChain.length <= 0 || !keyStoreEntry.certChain[0].equals(x509Certificate)) continue;
            return string;
        }
        return null;
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.append) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            byArray[n + cArray.length] = (byte)(cArray[n] >> 8);
            ++n;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(noSuchAlgorithmException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.OEAB);
        objectOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(arraycopy);
        messageDigest.reset();
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        objectOutputStream.writeObject(messageDigest.digest());
        objectOutputStream.writeObject(byArray2);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException {
        Object object;
        if (inputStream == null) {
            this.OEAB = new Hashtable();
            this.append = true;
            return;
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            object = new ObjectInputStream(inputStream);
            byte[] byArray3 = (byte[])((ObjectInputStream)object).readObject();
            if (byArray3.length != arraycopy.length) {
                throw new IOException("Wrong data version, cannot load.");
            }
            int n = 0;
            while (n < byArray3.length) {
                if (byArray3[n] != arraycopy[n]) {
                    throw new IOException("Wrong data version, cannot load.");
                }
                ++n;
            }
            byArray = (byte[])((ObjectInputStream)object).readObject();
            byArray2 = (byte[])((ObjectInputStream)object).readObject();
            ((ObjectInputStream)object).close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Corrupted data, cannot load.");
        }
        object = new byte[cArray.length * 2];
        int n = 0;
        while (n < cArray.length) {
            object[n] = (byte)cArray[n];
            object[n + cArray.length] = (byte)(cArray[n] >> 8);
            ++n;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        messageDigest.reset();
        messageDigest.update((byte[])object);
        messageDigest.update(byArray2);
        byte[] byArray4 = messageDigest.digest();
        if (byArray.length != byArray4.length) {
            throw new IOException("Corrupted data or wrong password.");
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != byArray4[n2]) {
                throw new IOException("Corrupted data or wrong password.");
            }
            ++n2;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.OEAB = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Corrupted data, cannot load.");
        }
        this.append = true;
    }

    private byte[] OEAB(Key key, char[] cArray) throws KeyStoreException {
        Object object;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(noSuchAlgorithmException.getMessage());
        }
        byte[] byArray = null;
        try {
            object = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
            objectOutputStream.writeObject(key);
            objectOutputStream.flush();
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            objectOutputStream.close();
            ((ByteArrayOutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new KeyStoreException("Cannot encrypt the key " + iOException.getMessage());
        }
        object = new byte[cArray.length * 2];
        int n = 0;
        while (n < cArray.length) {
            object[n] = (byte)cArray[n];
            object[n + cArray.length] = (byte)(cArray[n] >> 8);
            ++n;
        }
        messageDigest.update((byte[])object);
        byte[] byArray2 = messageDigest.digest();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        int n2 = byArray.length / byArray2.length + 1;
        int n3 = 0;
        while (n3 < n2) {
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest.update((byte[])object);
            byArray2 = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray3, n3 * byArray2.length, byArray2.length);
            ++n3;
        }
        byte[] byArray4 = new byte[byArray3.length];
        int n4 = 0;
        while (n4 < byArray.length) {
            byArray4[n4] = (byte)(byArray[n4] ^ byArray3[n4]);
            ++n4;
        }
        messageDigest.reset();
        messageDigest.update(byArray);
        byArray2 = messageDigest.digest();
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        return byArray4;
    }

    private Key append(byte[] byArray, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray2 = new byte[cArray.length * 2];
        int n = 0;
        while (n < cArray.length) {
            byArray2[n] = (byte)cArray[n];
            byArray2[n + cArray.length] = (byte)(cArray[n] >> 8);
            ++n;
        }
        messageDigest.update(byArray2);
        byte[] byArray3 = messageDigest.digest();
        byte[] byArray4 = new byte[byArray.length];
        int n2 = byArray.length / byArray3.length;
        int n3 = 0;
        while (n3 < n2) {
            messageDigest.reset();
            messageDigest.update(byArray3);
            messageDigest.update(byArray2);
            byArray3 = messageDigest.digest();
            System.arraycopy(byArray3, 0, byArray4, n3 * byArray3.length, byArray3.length);
            ++n3;
        }
        byte[] byArray5 = new byte[byArray.length - byArray3.length];
        int n4 = 0;
        while (n4 < byArray5.length) {
            byArray5[n4] = (byte)(byArray[n4] ^ byArray4[n4]);
            ++n4;
        }
        messageDigest.reset();
        messageDigest.update(byArray5);
        byArray3 = messageDigest.digest();
        int n5 = 0;
        while (n5 < byArray3.length) {
            if (byArray[n5 + byArray5.length] != byArray3[n5]) {
                throw new UnrecoverableKeyException("Invalid key or incorrect password.");
            }
            ++n5;
        }
        Key key = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray5);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            key = (Key)objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnrecoverableKeyException(classNotFoundException.getMessage());
        }
        return key;
    }

    public Object clone() {
        try {
            KeyStore keyStore = (KeyStore)super.clone();
            return keyStore;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

