/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.cert.CertificateExpiredException;
import ice.cert.CertificateNotYetValidException;
import ice.cert.X500Name;
import ice.cert.X509Certificate;
import ice.debug.Debug;
import ice.ssl.CertificateCallback;
import ice.ssl.CertificateErrorInfo;
import ice.ssl.ClientCertificateList;
import ice.ssl.SSLSocket;
import ice.ssl.ServerCertificateList;
import java.net.InetAddress;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.Enumeration;
import java.util.Vector;

public class CertificateManager
implements CertificateCallback {
    public static CertificateManager theInstance = null;
    static final int CERT_REJECT = 0;
    static final int CERT_SESSIONACCEPT = 1;
    static final int CERT_ALWAYSACCEPT = 2;
    private ServerCertificateList OEAB = new ServerCertificateList();
    private ServerCertificateList Z = new ServerCertificateList();
    private ClientCertificateList addElement = new ClientCertificateList();
    private ClientCertificateList checkValidity = new ClientCertificateList();

    public static void setCertificateManager(CertificateManager certificateManager) {
        theInstance = certificateManager;
    }

    public static CertificateManager getCertificateManager() {
        return theInstance;
    }

    public CertificateErrorInfo[] getErrorInfo(X509Certificate[] x509CertificateArray, SSLSocket sSLSocket) {
        Object object;
        boolean bl = true;
        String string = "";
        Vector<CertificateErrorInfo> vector = new Vector<CertificateErrorInfo>();
        try {
            x509CertificateArray[0].checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            vector.addElement(new CertificateErrorInfo(4, "Certificate is expired\n", null, null));
            bl = false;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            vector.addElement(new CertificateErrorInfo(5, "Certificate is not yet valid\n", null, null));
            bl = false;
        }
        String string2 = sSLSocket.getTargetHostName();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string2);
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = ((X500Name)x509CertificateArray[0].getSubjectDN()).getElement("CN");
        string3 = string3.toLowerCase();
        string2 = string2.toLowerCase();
        if (string3.startsWith("*.")) {
            object = string3.substring(2);
            if (!string2.endsWith((String)object)) {
                vector.addElement(new CertificateErrorInfo(3, "Certificate is not issued for this host\n", null, null));
                bl = false;
            }
        } else {
            object = new InetAddress[]{};
            try {
                object = InetAddress.getAllByName(string3);
                string3 = InetAddress.getByName(string3).getHostName().toLowerCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl2 = false;
            int n = 0;
            while (n < ((InetAddress[])object).length) {
                if (object[n].equals(inetAddress)) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            if (string3.equals(string2)) {
                bl2 = true;
            }
            if (!bl2) {
                vector.addElement(new CertificateErrorInfo(3, "Certificate is not issued for this host\n", null, null));
                bl = false;
            }
        }
        int n = 1;
        while (n < x509CertificateArray.length - 1) {
            if (!x509CertificateArray[n - 1].getIssuerDN().equals(x509CertificateArray[n].getSubjectDN())) {
                vector.addElement(new CertificateErrorInfo(1, "Issuer and subject dont match in chain \n", null, null));
            }
            try {
                x509CertificateArray[n - 1].verify(x509CertificateArray[n].getPublicKey());
            }
            catch (Exception exception) {
                vector.addElement(new CertificateErrorInfo(1, "Signature chain is incorrect\n", null, null));
            }
            if (x509CertificateArray[n].getBasicConstraints() < n) {
                vector.addElement(new CertificateErrorInfo(1, "Basic constraints are violated\n", null, null));
            }
            ++n;
        }
        Enumeration enumeration = this.OEAB.getList();
        X509Certificate x509Certificate = null;
        while (enumeration.hasMoreElements()) {
            block26: {
                x509Certificate = (X509Certificate)enumeration.nextElement();
                if (x509Certificate.getSubjectDN().equals(x509CertificateArray[x509CertificateArray.length - 1].getIssuerDN())) {
                    try {
                        x509CertificateArray[x509CertificateArray.length - 1].verify(x509Certificate.getPublicKey());
                        break;
                    }
                    catch (Exception exception) {
                        if (!Debug.ex) break block26;
                        Debug.ex((Throwable)exception);
                    }
                }
            }
            x509Certificate = null;
        }
        if (x509Certificate == null) {
            bl = false;
            vector.addElement(new CertificateErrorInfo(1, "Certificate is not trusted \n", null, null));
        }
        CertificateErrorInfo[] certificateErrorInfoArray = new CertificateErrorInfo[vector.size()];
        if (!bl) {
            Enumeration enumeration2 = vector.elements();
            int n2 = 0;
            while (n2 < vector.size()) {
                certificateErrorInfoArray[n2] = (CertificateErrorInfo)enumeration2.nextElement();
                ++n2;
            }
            return certificateErrorInfoArray;
        }
        return null;
    }

    private boolean OEAB(X509Certificate[] x509CertificateArray) {
        Enumeration enumeration = this.Z.getList();
        X509Certificate x509Certificate = x509CertificateArray[0];
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate2 = (X509Certificate)enumeration.nextElement();
            if (!x509Certificate.getSubject().equals(x509Certificate2.getSubject())) continue;
            return true;
        }
        return false;
    }

    public boolean acceptCertificate(X509Certificate[] x509CertificateArray, SSLSocket sSLSocket) {
        if (this.getErrorInfo(x509CertificateArray, sSLSocket) == null) {
            return true;
        }
        return this.OEAB(x509CertificateArray);
    }

    public X509Certificate[] selectName(X500Name[] x500NameArray) {
        X509Certificate[] x509CertificateArray = this.Z(x500NameArray, this.checkValidity);
        if (x509CertificateArray.length <= 0) {
            return null;
        }
        return x509CertificateArray;
    }

    public PrivateKey supplyPrivateKey(X509Certificate x509Certificate) {
        return this.checkValidity.getPrivateKey(x509Certificate);
    }

    public void setCAList(ServerCertificateList serverCertificateList) {
        this.OEAB = serverCertificateList;
    }

    public ServerCertificateList getCAList() {
        return this.OEAB;
    }

    public void setTrustedSites(ServerCertificateList serverCertificateList) {
        this.Z = serverCertificateList;
    }

    public ServerCertificateList getTrustedSites() {
        return this.Z;
    }

    public void setClientCertificates(ClientCertificateList clientCertificateList) {
        this.addElement = clientCertificateList;
    }

    public ClientCertificateList getClientCertificates() {
        return this.addElement;
    }

    public void setSignList(ClientCertificateList clientCertificateList) {
        this.checkValidity = clientCertificateList;
    }

    public ClientCertificateList getSignList() {
        return this.checkValidity;
    }

    private X509Certificate[] Z(X500Name[] x500NameArray, ClientCertificateList clientCertificateList) {
        X509Certificate[] x509CertificateArray;
        Enumeration enumeration = clientCertificateList.getList();
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        int n = 0;
        while (n < x500NameArray.length) {
            x509CertificateArray = x500NameArray[n];
            enumeration = clientCertificateList.getList();
            while (enumeration.hasMoreElements()) {
                Principal principal;
                X509Certificate x509Certificate = (X509Certificate)enumeration.nextElement();
                if (x509Certificate == null || !x509CertificateArray.equals(principal = x509Certificate.getIssuerDN())) continue;
                vector.addElement(x509Certificate);
            }
            ++n;
        }
        x509CertificateArray = new X509Certificate[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            x509CertificateArray[n2] = (X509Certificate)vector.elementAt(n2);
            ++n2;
        }
        return x509CertificateArray;
    }

    public X509Certificate[] matchIssuers(X500Name[] x500NameArray) {
        if (this.addElement != null) {
            return this.Z(x500NameArray, this.addElement);
        }
        return null;
    }
}

