/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.ssl.CertificateRequest;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.SSLSocket;
import ice.ssl.ServerCertificate;
import ice.ssl.ServerFinished;
import ice.ssl.ServerHello;
import ice.ssl.ServerHelloDone;
import ice.ssl.ServerKeyExchange;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.IOException;

abstract class ServerHandshake {
    static final int CHANGE_CIPHER_SPEC = -1;
    static final int HELLO_REQUEST = 0;
    static final int SERVER_HELLO = 2;
    static final int CERTIFICATE = 11;
    static final int SERVER_KEY_EXCHANGE = 12;
    static final int CERTIFICATE_REQUEST = 13;
    static final int SERVER_HELLO_DONE = 14;
    static final int SERVER_FINISHED = 20;
    static final int V2_SERVER_HELLO = 4;
    static final int V2_SERVER_VERIFY = 5;
    static final int V2_SERVER_FINISHED = 6;
    static final int V2_CERTIFICATE_REQUEST = 7;
    protected SSLSocket socket;
    protected HandshakeState handState;
    protected SessionState sesState;
    protected ConnectionState conState;
    protected int length;
    protected int headerSize;

    ServerHandshake(SSLSocket sSLSocket, SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        this.handState = handshakeState;
        this.sesState = sessionState;
        this.conState = connectionState;
        this.socket = sSLSocket;
        this.headerSize = sessionState.nowProto == 1 ? 0 : 4;
        if (sessionState.nowProto != 1) {
            this.length = Util.byteArrayToInt(handshakeState.data, handshakeState.offset + 1, 3);
            this.length += this.headerSize;
            byte[] byArray = new byte[this.length];
            System.arraycopy(handshakeState.data, handshakeState.offset, byArray, 0, this.length);
            try {
                handshakeState.messages.write(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        handshakeState.offset += this.headerSize;
    }

    static int getNextLength(HandshakeState handshakeState) {
        return 4 + Util.byteArrayToInt(handshakeState.data, handshakeState.offset + 1, 3);
    }

    static ServerHandshake makeChild(SSLSocket sSLSocket, SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) throws IOException {
        if (handshakeState.data[handshakeState.offset] == 0) {
            handshakeState.offset += 4;
        }
        byte by = handshakeState.data[handshakeState.offset];
        int n = 0;
        n = 0;
        while (n < handshakeState.next.length) {
            if (by == handshakeState.next[n]) break;
            ++n;
        }
        switch (by) {
            case 2: {
                return new ServerHello(sSLSocket, sessionState, connectionState, handshakeState);
            }
            case 11: {
                return new ServerCertificate(sSLSocket, sessionState, connectionState, handshakeState);
            }
            case 12: {
                return new ServerKeyExchange(sSLSocket, sessionState, connectionState, handshakeState);
            }
            case 13: {
                return new CertificateRequest(sSLSocket, sessionState, connectionState, handshakeState);
            }
            case 14: {
                return new ServerHelloDone(sSLSocket, sessionState, connectionState, handshakeState);
            }
            case 20: {
                return new ServerFinished(sSLSocket, sessionState, connectionState, handshakeState);
            }
        }
        throw new IOException("Unexpected handshake message received from the server: " + handshakeState.data[handshakeState.offset]);
    }

    int getLength() {
        return this.length;
    }
}

