/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatchers;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextMatcher<E>
implements Matcher<E> {
    private final TextFilterator<? super E> filterator;
    private final int mode;
    private final Object strategy;
    private final SearchTerm[] searchTerms;
    private final TextSearchStrategy[] filterStrategies;
    private final List<String> filterStrings = new ArrayList<String>();

    public TextMatcher(SearchTerm[] searchTerms, TextFilterator<? super E> filterator, int mode, Object strategy) {
        this.filterator = filterator;
        this.searchTerms = TextMatchers.normalizeSearchTerms(searchTerms, (TextSearchStrategy.Factory)strategy);
        this.mode = mode;
        this.strategy = strategy;
        this.filterStrategies = new TextSearchStrategy[this.searchTerms.length];
        for (int i = 0; i < this.searchTerms.length; ++i) {
            this.filterStrategies[i] = TextMatcher.selectTextSearchStrategy(this.searchTerms[i], mode, (TextSearchStrategy.Factory)strategy);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public Object getStrategy() {
        return this.strategy;
    }

    public SearchTerm[] getSearchTerms() {
        return this.searchTerms;
    }

    public String[] getSearchTermStrings() {
        String[] strings = new String[this.searchTerms.length];
        for (int i = 0; i < this.searchTerms.length; ++i) {
            strings[i] = this.searchTerms[i].getText();
        }
        return strings;
    }

    @Override
    public boolean matches(E element) {
        return TextMatchers.matches(this.filterStrings, this.filterator, this.searchTerms, this.filterStrategies, element);
    }

    public TextMatcher newMode(int mode) {
        return new TextMatcher<E>(this.searchTerms, this.filterator, mode, this.strategy);
    }

    public TextMatcher newStrategy(Object strategy) {
        return new TextMatcher<E>(this.searchTerms, this.filterator, this.mode, strategy);
    }

    private static TextSearchStrategy selectTextSearchStrategy(SearchTerm filter, int mode, TextSearchStrategy.Factory strategy) {
        TextSearchStrategy result = strategy.create(mode, filter.getText());
        result.setSubtext(filter.getText());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMatcher that = (TextMatcher)o;
        HashSet<SearchTerm> thisSearchTerms = new HashSet<SearchTerm>(Arrays.asList(this.searchTerms));
        HashSet<SearchTerm> thatSearchTerms = new HashSet<SearchTerm>(Arrays.asList(that.searchTerms));
        if (this.mode != that.mode) {
            return false;
        }
        if (!((Object)thisSearchTerms).equals(thatSearchTerms)) {
            return false;
        }
        return this.strategy.equals(that.strategy);
    }

    public int hashCode() {
        int result = this.mode;
        result = 31 * result + this.strategy.hashCode();
        result = 31 * result + new HashSet<SearchTerm>(Arrays.asList(this.searchTerms)).hashCode();
        return result;
    }
}

